/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.PDEUIStateWrapper;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.pde.internal.build.site.BuildTimeSite;
import org.eclipse.pde.internal.build.site.BuildTimeSiteFactory;
import org.eclipse.update.core.SiteManager;

public abstract class AbstractScriptGenerator
implements IXMLConstants,
IPDEBuildConstants,
IBuildPropertiesConstants {
    protected static boolean embeddedSource = false;
    protected static boolean forceUpdateJarFormat = false;
    private static List configInfos;
    protected static String workingDirectory;
    protected static boolean buildingOSGi;
    protected AntScript script;
    private static PDEUIStateWrapper pdeUIState;
    protected String[] pluginPath;
    protected BuildTimeSiteFactory siteFactory;
    protected boolean reportResolutionErrors;

    static {
        buildingOSGi = true;
        configInfos = new ArrayList(1);
        configInfos.add(Config.genericConfig());
    }

    public static List getConfigInfos() {
        return configInfos;
    }

    public abstract void generate() throws CoreException;

    public static void setConfigInfo(String spec) throws CoreException {
        configInfos.clear();
        String[] configs = Utils.getArrayFromStringWithBlank(spec, "&");
        configInfos = new ArrayList(configs.length);
        String[] os = new String[configs.length];
        String[] ws = new String[configs.length];
        String[] archs = new String[configs.length];
        int i = 0;
        while (i < configs.length) {
            String[] configElements = Utils.getArrayFromStringWithBlank(configs[i], ",");
            if (configElements.length != 3) {
                Status error = new Status(4, "org.eclipse.pde.build", 22, NLS.bind((String)Messages.error_configWrongFormat, (Object)configs[i]), null);
                throw new CoreException((IStatus)error);
            }
            Config aConfig = new Config(configs[i]);
            if (aConfig.equals(Config.genericConfig())) {
                configInfos.add(Config.genericConfig());
            } else {
                configInfos.add(aConfig);
            }
            os[i] = aConfig.getOs();
            ws[i] = aConfig.getWs();
            archs[i] = aConfig.getArch();
            ++i;
        }
        SiteManager.setOS((String)Utils.getStringFromArray(os, ","));
        SiteManager.setWS((String)Utils.getStringFromArray(ws, ","));
        SiteManager.setOSArch((String)Utils.getStringFromArray(archs, ","));
    }

    public void setWorkingDirectory(String location) {
        workingDirectory = location;
    }

    public String getLocation(BundleDescription model) {
        return model.getLocation();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties readProperties(String location, String fileName, int errorLevel) throws CoreException {
        Properties result = new Properties();
        File file = new File(location, fileName);
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            try {
                result.load(input);
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                ((InputStream)input).close();
                throw throwable;
            }
            {
                Object var6_10 = null;
                ((InputStream)input).close();
                return result;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (errorLevel == 1) return MissingProperties.getInstance();
            if (errorLevel == 0) return MissingProperties.getInstance();
            String message = NLS.bind((String)Messages.exception_missingFile, (Object)file);
            BundleHelper.getDefault().getLog().log((IStatus)new Status(errorLevel, "org.eclipse.pde.build", 10, message, null));
            return MissingProperties.getInstance();
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.exception_readingFile, (Object)file);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
        }
    }

    public void openScript(String scriptLocation, String scriptName) throws CoreException {
        if (this.script != null) {
            return;
        }
        try {
            BufferedOutputStream scriptStream = new BufferedOutputStream(new FileOutputStream(String.valueOf(scriptLocation) + '/' + scriptName));
            try {
                this.script = new AntScript(scriptStream);
            }
            catch (IOException e) {
                try {
                    ((OutputStream)scriptStream).close();
                    String message = NLS.bind((String)Messages.exception_writingFile, (Object)(String.valueOf(scriptLocation) + '/' + scriptName));
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException e) {
            String message = NLS.bind((String)Messages.exception_writingFile, (Object)(String.valueOf(scriptLocation) + '/' + scriptName));
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
    }

    public void closeScript() {
        this.script.close();
    }

    public void setBuildingOSGi(boolean b) {
        buildingOSGi = b;
    }

    public static boolean isBuildingOSGi() {
        return buildingOSGi;
    }

    public static String getWorkingDirectory() {
        return workingDirectory;
    }

    public static String getDefaultOutputFormat() {
        return "zip";
    }

    public static boolean getDefaultEmbeddedSource() {
        return false;
    }

    public static void setEmbeddedSource(boolean embed) {
        embeddedSource = embed;
    }

    public static boolean getForceUpdateJarFormat() {
        return false;
    }

    public static void setForceUpdateJar(boolean force) {
        forceUpdateJarFormat = force;
    }

    public static String getDefaultConfigInfos() {
        return "*, *, *";
    }

    public static boolean getDefaultBuildingOSGi() {
        return true;
    }

    public BuildTimeSite getSite(boolean refresh) throws CoreException {
        if (this.siteFactory != null && !refresh) {
            return (BuildTimeSite)this.siteFactory.createSite();
        }
        if (this.siteFactory == null || refresh) {
            this.siteFactory = new BuildTimeSiteFactory();
            this.siteFactory.setReportResolutionErrors(this.reportResolutionErrors);
        }
        this.siteFactory.setSitePaths(this.getPaths());
        this.siteFactory.setInitialState(pdeUIState);
        return (BuildTimeSite)this.siteFactory.createSite();
    }

    private String[] getPaths() {
        if (this.pluginPath != null) {
            return this.pluginPath;
        }
        return new String[]{workingDirectory};
    }

    public void setBuildSiteFactory(BuildTimeSiteFactory siteFactory) {
        this.siteFactory = siteFactory;
    }

    public String[] getPluginPath() {
        return this.pluginPath;
    }

    public void setPluginPath(String[] path) {
        this.pluginPath = path;
    }

    public void setPDEState(State state) {
        this.ensurePDEUIStateNotNull();
        pdeUIState.setState(state);
    }

    public void setStateExtraData(HashMap p) {
        this.ensurePDEUIStateNotNull();
        pdeUIState.setExtraData(p);
    }

    public void setNextId(long nextId) {
        this.ensurePDEUIStateNotNull();
        pdeUIState.setNextId(nextId);
    }

    protected void flushState() {
        pdeUIState = null;
    }

    private void ensurePDEUIStateNotNull() {
        if (pdeUIState == null) {
            pdeUIState = new PDEUIStateWrapper();
        }
    }

    public static class MissingProperties
    extends Properties {
        private static final long serialVersionUID = 3546924667060303927L;
        private static MissingProperties singleton;

        private MissingProperties() {
        }

        public synchronized Object setProperty(String key, String value) {
            throw new UnsupportedOperationException();
        }

        public synchronized Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public static MissingProperties getInstance() {
            if (singleton == null) {
                singleton = new MissingProperties();
            }
            return singleton;
        }
    }
}

