/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.team.internal.ccvs.ssh.CVSSSHMessages;
import org.eclipse.team.internal.ccvs.ssh.Cipher;
import org.eclipse.team.internal.ccvs.ssh.Misc;
import org.eclipse.team.internal.ccvs.ssh.Packet;

class ServerPacket
extends Packet {
    private PacketInputStream pis = null;

    public ServerPacket(InputStream is, Cipher cipher) throws IOException {
        this.packetLength = Misc.readInt(is);
        this.paddingLength = 8 - this.packetLength % 8;
        this.pis = new PacketInputStream(is, this.packetLength + this.paddingLength, cipher);
        Misc.skipFully(this.pis, this.paddingLength);
        this.packetType = (byte)this.pis.read();
    }

    public void close(boolean doCrcCheck) throws IOException {
        this.pis.close(doCrcCheck);
    }

    public InputStream getInputStream() {
        return this.pis;
    }

    private static class PacketInputStream
    extends FilterInputStream {
        private static int MAX_BUFFER_SIZE = 1024;
        private byte[] buffer = new byte[MAX_BUFFER_SIZE];
        private int bufpos = 0;
        private int buflen = 0;
        private int bufrem = 0;
        private long remaining = 0L;
        private Cipher cipher = null;
        private long crc = 0L;
        private boolean closed = false;

        public PacketInputStream(InputStream in, long length, Cipher cipher) {
            super(in);
            this.remaining = length;
            this.cipher = cipher;
        }

        public int available() throws IOException {
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            return (int)Math.min(this.remaining - 4L, Integer.MAX_VALUE);
        }

        public void close() throws IOException {
            this.close(true);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close(boolean doCrcCheck) throws IOException {
            if (this.closed) return;
            try {
                long toRead = doCrcCheck ? this.remaining - 4L : this.remaining;
                try {
                    Misc.skipFully(this, toRead);
                }
                catch (IOException iOException) {}
                if (doCrcCheck && (int)this.crc != Misc.readInt(this.buffer, this.bufpos)) {
                    throw new IOException(CVSSSHMessages.ServerPacket_crc);
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.closed = true;
                throw throwable;
            }
            {
                Object var4_5 = null;
                this.closed = true;
                return;
            }
        }

        private void fill() throws IOException {
            if (this.bufrem > 0) {
                System.arraycopy(this.buffer, this.bufpos, this.buffer, 0, this.bufrem);
            }
            int totalBytesRead = this.bufrem;
            int read = 0;
            int toRead = (int)Math.min(this.remaining - (long)totalBytesRead, (long)(MAX_BUFFER_SIZE - totalBytesRead));
            while (toRead > 0) {
                read = this.in.read(this.buffer, totalBytesRead, toRead);
                if (read == -1) {
                    throw new IOException(CVSSSHMessages.stream);
                }
                totalBytesRead += read;
                toRead -= read;
            }
            this.bufpos = 0;
            this.buflen = totalBytesRead / 8 * 8;
            this.bufrem = totalBytesRead - this.buflen;
            if (this.cipher != null) {
                this.cipher.decipher(this.buffer, 0, this.buffer, 0, this.buflen);
            }
            this.crc = Misc.crc32(this.buffer, 0, (long)this.buflen == this.remaining ? this.buflen - 4 : this.buflen, this.crc);
        }

        public int read() throws IOException {
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            if (this.remaining - 4L == 0L) {
                return -1;
            }
            if (this.bufpos == this.buflen) {
                this.fill();
            }
            int b = this.buffer[this.bufpos] & 0xFF;
            ++this.bufpos;
            --this.remaining;
            return b;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            if (this.remaining - 4L == 0L) {
                return -1;
            }
            if (this.bufpos == this.buflen) {
                this.fill();
            }
            len = Math.min(len, ((long)this.buflen == this.remaining + (long)this.bufpos ? this.buflen - 4 : this.buflen) - this.bufpos);
            System.arraycopy(this.buffer, this.bufpos, b, off, len);
            this.bufpos += len;
            this.remaining -= (long)len;
            return len;
        }
    }
}

