/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.ltk.internal.core.refactoring.Assert;

public class ListenerList {
    private int capacity;
    private int size;
    private Object[] listeners = null;
    private static final Object[] EmptyArray = new Object[0];

    public ListenerList() {
        this(3);
    }

    public ListenerList(int cap) {
        Assert.isTrue(cap >= 1);
        this.capacity = cap;
    }

    public void add(Object listener) {
        Assert.isNotNull(listener);
        if (this.size == 0) {
            this.listeners = new Object[this.capacity];
        } else {
            int i = 0;
            while (i < this.size) {
                if (this.listeners[i] == listener) {
                    return;
                }
                ++i;
            }
            if (this.size == this.listeners.length) {
                this.listeners = new Object[this.size * 2 + 1];
                System.arraycopy(this.listeners, 0, this.listeners, 0, this.size);
            }
        }
        this.listeners[this.size++] = listener;
    }

    public Object[] getListeners() {
        if (this.size == 0) {
            return EmptyArray;
        }
        Object[] result = new Object[this.size];
        System.arraycopy(this.listeners, 0, result, 0, this.size);
        return result;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void remove(Object listener) {
        Assert.isNotNull(listener);
        int i = 0;
        while (i < this.size) {
            if (this.listeners[i] == listener) {
                if (--this.size == 0) {
                    this.listeners = new Object[1];
                } else {
                    if (i < this.size) {
                        this.listeners[i] = this.listeners[this.size];
                    }
                    this.listeners[this.size] = null;
                }
                return;
            }
            ++i;
        }
    }

    public int size() {
        return this.size;
    }
}

