/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.actions.StatusLineCLabelContribution;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public class StatusLineContributionGroup
extends ActionGroup
implements ISyncInfoSetChangeListener {
    private static final String INCOMING_ID = "org.eclipse.team.uiorg.eclipse.team.iu.statusline.incoming";
    private static final String OUTGOING_ID = "org.eclipse.team.uiorg.eclipse.team.iu.statusline.outgoing";
    private static final String CONFLICTING_ID = "org.eclipse.team.uiorg.eclipse.team.iu.statusline.conflicting";
    private static final String TOTALS_ID = "org.eclipse.team.uiorg.eclipse.team.iu.statusline.totals";
    private static final int TEXT_FIELD_MAX_SIZE = 25;
    private StatusLineCLabelContribution incoming;
    private StatusLineCLabelContribution outgoing;
    private StatusLineCLabelContribution conflicting;
    private StatusLineCLabelContribution totalChanges;
    private Image incomingImage = TeamUIPlugin.getImageDescriptor("elcl16/incom_synch.gif").createImage();
    private Image outgoingImage = TeamUIPlugin.getImageDescriptor("elcl16/outgo_synch.gif").createImage();
    private Image conflictingImage = TeamUIPlugin.getImageDescriptor("elcl16/conflict_synch.gif").createImage();
    private ISynchronizePageConfiguration configuration;

    public StatusLineContributionGroup(Shell shell, ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        if (this.isThreeWay()) {
            this.incoming = this.createStatusLineContribution(INCOMING_ID, 1, "0", this.incomingImage);
            this.outgoing = this.createStatusLineContribution(OUTGOING_ID, 2, "0", this.outgoingImage);
            this.conflicting = this.createStatusLineContribution(CONFLICTING_ID, 8, "0", this.conflictingImage);
        } else {
            this.totalChanges = new StatusLineCLabelContribution(TOTALS_ID, 25);
        }
        SyncInfoSet set = this.getSyncInfoSet();
        set.addSyncSetChangedListener((ISyncInfoSetChangeListener)this);
        this.updateCounts();
    }

    private boolean isThreeWay() {
        return this.configuration.getComparisonType() == "three-way";
    }

    private SubscriberParticipant getParticipant() {
        return (SubscriberParticipant)this.configuration.getParticipant();
    }

    private StatusLineCLabelContribution createStatusLineContribution(String id, final int mode, String label, Image image) {
        StatusLineCLabelContribution item = new StatusLineCLabelContribution(id, 15);
        item.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                StatusLineContributionGroup.this.configuration.setMode(mode);
            }
        });
        item.setText(label);
        item.setImage(image);
        return item;
    }

    public void dispose() {
        this.getSyncInfoSet().removeSyncSetChangedListener((ISyncInfoSetChangeListener)this);
        if (this.isThreeWay()) {
            this.incomingImage.dispose();
            this.outgoingImage.dispose();
            this.conflictingImage.dispose();
        }
    }

    public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
        this.updateCounts();
    }

    private void updateCounts() {
        if (this.getParticipant().getSubscriber() != null) {
            SyncInfoSet workspaceSetStats = this.getSyncInfoSet();
            final int total = workspaceSetStats.size();
            final int workspaceConflicting = (int)workspaceSetStats.countFor(12, 12);
            final int workspaceOutgoing = (int)workspaceSetStats.countFor(4, 12);
            final int workspaceIncoming = (int)workspaceSetStats.countFor(8, 12);
            TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (StatusLineContributionGroup.this.isThreeWay()) {
                        StatusLineContributionGroup.this.conflicting.setText(new Integer(workspaceConflicting).toString());
                        StatusLineContributionGroup.this.incoming.setText(new Integer(workspaceIncoming).toString());
                        StatusLineContributionGroup.this.outgoing.setText(new Integer(workspaceOutgoing).toString());
                        StatusLineContributionGroup.this.conflicting.setTooltip(NLS.bind((String)TeamUIMessages.StatisticsPanel_numbersTooltip, (Object[])new String[]{TeamUIMessages.StatisticsPanel_conflicting}));
                        StatusLineContributionGroup.this.outgoing.setTooltip(NLS.bind((String)TeamUIMessages.StatisticsPanel_numbersTooltip, (Object[])new String[]{TeamUIMessages.StatisticsPanel_outgoing}));
                        StatusLineContributionGroup.this.incoming.setTooltip(NLS.bind((String)TeamUIMessages.StatisticsPanel_numbersTooltip, (Object[])new String[]{TeamUIMessages.StatisticsPanel_incoming}));
                    } else if (total == 1) {
                        StatusLineContributionGroup.this.totalChanges.setText(NLS.bind((String)TeamUIMessages.StatisticsPanel_numberTotalSingular, (Object[])new String[]{Integer.toString(total)}));
                    } else {
                        StatusLineContributionGroup.this.totalChanges.setText(NLS.bind((String)TeamUIMessages.StatisticsPanel_numberTotalPlural, (Object[])new String[]{Integer.toString(total)}));
                    }
                }
            });
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        IStatusLineManager mgr = actionBars.getStatusLineManager();
        if (this.isThreeWay()) {
            mgr.add((IContributionItem)this.incoming);
            mgr.add((IContributionItem)this.outgoing);
            mgr.add((IContributionItem)this.conflicting);
        } else {
            mgr.add((IContributionItem)this.totalChanges);
        }
    }

    public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
        this.updateCounts();
    }

    public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
    }

    private SyncInfoSet getSyncInfoSet() {
        return (SyncInfoSet)this.configuration.getProperty("org.eclipse.team.ui.P_WORKING_SET_SYNC_INFO_SET");
    }
}

