/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoCollector;

public class RefreshChangeListener
implements ISubscriberChangeListener {
    private List changes = new ArrayList();
    private SubscriberSyncInfoCollector collector;

    public RefreshChangeListener(SubscriberSyncInfoCollector collector) {
        this.collector = collector;
    }

    public void subscriberResourceChanged(ISubscriberChangeEvent[] deltas) {
        int i = 0;
        while (i < deltas.length) {
            ISubscriberChangeEvent delta = deltas[i];
            if (delta.getFlags() == 1) {
                this.changes.add(delta);
            }
            ++i;
        }
    }

    public SyncInfo[] getChanges(IProgressMonitor monitor) {
        this.collector.waitForCollector(monitor);
        ArrayList<SyncInfo> changedSyncInfos = new ArrayList<SyncInfo>();
        SyncInfoTree set = this.collector.getSyncInfoSet();
        Iterator it = this.changes.iterator();
        while (it.hasNext()) {
            ISubscriberChangeEvent delta = (ISubscriberChangeEvent)it.next();
            SyncInfo info = set.getSyncInfo(delta.getResource());
            if (info == null || !this.interestingChange(info)) continue;
            changedSyncInfos.add(info);
        }
        return changedSyncInfos.toArray(new SyncInfo[changedSyncInfos.size()]);
    }

    private boolean interestingChange(SyncInfo info) {
        int kind = info.getKind();
        if (this.isThreeWay()) {
            int direction = SyncInfo.getDirection((int)kind);
            return direction == 8 || direction == 12;
        }
        return SyncInfo.getChange((int)kind) != 0;
    }

    private boolean isThreeWay() {
        return this.collector.getSubscriber().getResourceComparator().isThreeWay();
    }
}

