/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PrimitiveOptionsDialog
extends Dialog {
    private Button fHexButton;
    private Button fCharButton;
    private Button fUnsignedButton;
    private String fPrefix;

    public PrimitiveOptionsDialog(Shell parentShell, String prefix) {
        super(parentShell);
        this.fPrefix = prefix;
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IJavaDebugHelpContextIds.PRIMITIVE_DISPLAY_OPTIONS_DIALOG);
        this.getShell().setText(ActionMessages.PrimitiveOptionsDialog_Primitive_Type_Display_Options_1);
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fHexButton = new Button(composite, 32);
        this.fHexButton.setText(DebugUIMessages.JavaDebugPreferencePage_Display__hexadecimal_values__byte__short__char__int__long__3);
        this.fHexButton.setSelection(PrimitiveOptionsDialog.getBooleanPreferenceValue(this.fPrefix, IJDIPreferencesConstants.PREF_SHOW_HEX));
        this.fCharButton = new Button(composite, 32);
        this.fCharButton.setText(DebugUIMessages.JavaDebugPreferencePage_Display_ASCII__character_values__byte__short__int__long__4);
        this.fCharButton.setSelection(PrimitiveOptionsDialog.getBooleanPreferenceValue(this.fPrefix, IJDIPreferencesConstants.PREF_SHOW_CHAR));
        this.fUnsignedButton = new Button(composite, 32);
        this.fUnsignedButton.setText(DebugUIMessages.JavaDebugPreferencePage_Display__unsigned_values__byte__5);
        this.fUnsignedButton.setSelection(PrimitiveOptionsDialog.getBooleanPreferenceValue(this.fPrefix, IJDIPreferencesConstants.PREF_SHOW_UNSIGNED));
        PrimitiveOptionsDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        IPreferenceStore store = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        store.setValue(String.valueOf(this.fPrefix) + "." + IJDIPreferencesConstants.PREF_SHOW_HEX, this.fHexButton.getSelection());
        store.setValue(String.valueOf(this.fPrefix) + "." + IJDIPreferencesConstants.PREF_SHOW_CHAR, this.fCharButton.getSelection());
        store.setValue(String.valueOf(this.fPrefix) + "." + IJDIPreferencesConstants.PREF_SHOW_UNSIGNED, this.fUnsignedButton.getSelection());
        super.okPressed();
    }

    public static boolean getBooleanPreferenceValue(String id, String preference) {
        String compositeKey = String.valueOf(id) + "." + preference;
        IPreferenceStore store = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        boolean value = false;
        value = store.contains(compositeKey) ? store.getBoolean(compositeKey) : store.getBoolean(preference);
        return value;
    }
}

