/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvocationException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IEvaluationRunnable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceType;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.EvaluationContextManager;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.internal.debug.ui.JavaDetailFormattersManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class JavaDetailFormattersManager
implements IPropertyChangeListener,
IDebugEventSetListener,
ILaunchesListener {
    private static JavaDetailFormattersManager fgDefault;
    private HashMap fDetailFormattersMap;
    private HashMap fCacheMap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static JavaDetailFormattersManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new JavaDetailFormattersManager();
        }
        return fgDefault;
    }

    private JavaDetailFormattersManager() {
        this.populateDetailFormattersMap();
        JDIDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fCacheMap = new HashMap();
    }

    private void populateDetailFormattersMap() {
        String[] detailFormattersList = JavaDebugOptionsManager.parseList(JDIDebugUIPlugin.getDefault().getPreferenceStore().getString(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST));
        this.fDetailFormattersMap = new HashMap(detailFormattersList.length / 3);
        int i = 0;
        int length = detailFormattersList.length;
        while (i < length) {
            String typeName = detailFormattersList[i++];
            String snippet = detailFormattersList[i++].replace('\u0000', ',');
            boolean enabled = !"0".equals(detailFormattersList[i++]);
            this.fDetailFormattersMap.put(typeName, new DetailFormatter(typeName, snippet, enabled));
        }
    }

    public void computeValueDetail(final IJavaValue objectValue, final IJavaThread thread, final IValueDetailListener listener) {
        Runnable postEventDispatch = new Runnable(){

            public void run() {
                Runnable postEventProcess = new Runnable(this, thread, listener, objectValue){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ IJavaThread val$thread;
                    private final /* synthetic */ IValueDetailListener val$listener;
                    private final /* synthetic */ IJavaValue val$objectValue;
                    {
                        this.this$1 = var1_1;
                        this.val$thread = iJavaThread;
                        this.val$listener = iValueDetailListener;
                        this.val$objectValue = iJavaValue;
                    }

                    public void run() {
                        if (!this.val$thread.isSuspended() && !this.val$thread.isPerformingEvaluation()) {
                            this.val$listener.detailComputed((IValue)this.val$objectValue, DebugUIMessages.JavaDetailFormattersManager_9);
                        } else {
                            this.val$thread.queueRunnable(new Runnable(this, this.val$objectValue, this.val$thread, this.val$listener){
                                final /* synthetic */ 3 this$2;
                                private final /* synthetic */ IJavaValue val$objectValue;
                                private final /* synthetic */ IJavaThread val$thread;
                                private final /* synthetic */ IValueDetailListener val$listener;
                                {
                                    this.this$2 = var1_1;
                                    this.val$objectValue = iJavaValue;
                                    this.val$thread = iJavaThread;
                                    this.val$listener = iValueDetailListener;
                                }

                                public void run() {
                                    JavaDetailFormattersManager.access$0(2.access$0(3.access$0(this.this$2)), this.val$objectValue, this.val$thread, this.val$listener);
                                }
                            });
                        }
                    }

                    static /* synthetic */ 2 access$0(3 var0) {
                        return var0.this$1;
                    }
                };
                JDIDebugUIPlugin.getStandardDisplay().asyncExec(postEventProcess);
            }

            static /* synthetic */ JavaDetailFormattersManager access$0(2 var0) {
                return var0.JavaDetailFormattersManager.this;
            }
        };
        DebugPlugin.getDefault().asyncExec(postEventDispatch);
    }

    private void resolveFormatter(IJavaValue value, IJavaThread thread, IValueDetailListener listener) {
        EvaluationListener evaluationListener = new EvaluationListener(value, thread, listener);
        if (value instanceof IJavaObject && !(value instanceof IJavaArray)) {
            IJavaObject objectValue = (IJavaObject)value;
            try {
                IJavaDebugTarget debugTarget = (IJavaDebugTarget)thread.getDebugTarget();
                Expression expression = this.getCompiledExpression(objectValue, debugTarget, thread);
                if (expression != null) {
                    expression.getEngine().evaluateExpression(expression.getExpression(), objectValue, thread, (IEvaluationListener)evaluationListener, 128, false);
                    return;
                }
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e);
                return;
            }
        }
        try {
            evaluationListener.valueToString(value);
        }
        catch (DebugException e) {
            listener.detailComputed((IValue)value, e.getStatus().getMessage());
        }
    }

    private IJavaProject getJavaProject(IJavaObject javaValue, IJavaThread thread) throws DebugException {
        IJavaProject resourceProject;
        ISourceLocator locator = javaValue.getLaunch().getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = null;
        if (locator instanceof ISourceLookupDirector) {
            String[] sourcePaths;
            IJavaReferenceType type = (IJavaReferenceType)javaValue.getJavaType();
            if (type instanceof JDIReferenceType && (sourcePaths = ((JDIReferenceType)type).getSourcePaths(null)).length > 0) {
                sourceElement = ((ISourceLookupDirector)locator).getSourceElement((Object)sourcePaths[0]);
            }
            if (!(sourceElement instanceof IJavaElement) && sourceElement instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)sourceElement;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                sourceElement = iAdaptable.getAdapter((Class)clazz);
            }
        }
        if (sourceElement == null) {
            IJavaDebugTarget target;
            IJavaStackFrame stackFrame = null;
            IDebugTarget iDebugTarget = javaValue.getDebugTarget();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!((target = (IJavaDebugTarget)iDebugTarget.getAdapter((Class)clazz)) == null || (stackFrame = EvaluationContextManager.getEvaluationContext(null)) != null && stackFrame.getDebugTarget().equals(target) || (stackFrame = thread.getTopStackFrame()) == null || stackFrame.getDebugTarget().equals(target))) {
                stackFrame = null;
            }
            if (stackFrame == null) {
                return null;
            }
            sourceElement = locator.getSourceElement((IStackFrame)stackFrame);
            if (!(sourceElement instanceof IJavaElement) && sourceElement instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)sourceElement;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                sourceElement = iAdaptable.getAdapter((Class)clazz2);
            }
        }
        IJavaProject project = null;
        if (sourceElement instanceof IJavaElement) {
            project = ((IJavaElement)sourceElement).getJavaProject();
        } else if (sourceElement instanceof IResource && (resourceProject = JavaCore.create((IProject)((IResource)sourceElement).getProject())).exists()) {
            project = resourceProject;
        }
        return project;
    }

    public boolean hasAssociatedDetailFormatter(IJavaType type) {
        return this.getAssociatedDetailFormatter(type) != null;
    }

    public DetailFormatter getAssociatedDetailFormatter(IJavaType type) {
        String typeName;
        block4: {
            try {
                while (type instanceof IJavaArrayType) {
                    type = ((IJavaArrayType)type).getComponentType();
                }
                if (type instanceof IJavaClassType) {
                    typeName = type.getName();
                    break block4;
                }
                return null;
            }
            catch (DebugException debugException) {
                return null;
            }
        }
        return (DetailFormatter)this.fDetailFormattersMap.get(typeName);
    }

    public void setAssociatedDetailFormatter(DetailFormatter detailFormatter) {
        this.fDetailFormattersMap.put(detailFormatter.getTypeName(), detailFormatter);
        this.savePreference();
    }

    private void savePreference() {
        Collection valuesList = this.fDetailFormattersMap.values();
        String[] values = new String[valuesList.size() * 3];
        int i = 0;
        Iterator iter = valuesList.iterator();
        while (iter.hasNext()) {
            DetailFormatter detailFormatter = (DetailFormatter)iter.next();
            values[i++] = detailFormatter.getTypeName();
            values[i++] = detailFormatter.getSnippet().replace(',', '\u0000');
            String string = values[i++] = detailFormatter.isEnabled() ? "1" : "0";
        }
        String pref = JavaDebugOptionsManager.serializeList(values);
        JDIDebugUIPlugin.getDefault().getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST, pref);
        JDIDebugUIPlugin.getDefault().savePluginPreferences();
    }

    private String getDetailFormatter(IJavaClassType type) throws DebugException {
        String snippet = this.getDetailFormatterSuperClass(type);
        if (snippet != null) {
            return snippet;
        }
        IJavaInterfaceType[] allInterfaces = type.getAllInterfaces();
        int i = 0;
        while (i < allInterfaces.length) {
            DetailFormatter detailFormatter = (DetailFormatter)this.fDetailFormattersMap.get(allInterfaces[i].getName());
            if (detailFormatter != null && detailFormatter.isEnabled()) {
                return detailFormatter.getSnippet();
            }
            ++i;
        }
        return null;
    }

    private String getDetailFormatterSuperClass(IJavaClassType type) throws DebugException {
        if (type == null) {
            return null;
        }
        DetailFormatter detailFormatter = (DetailFormatter)this.fDetailFormattersMap.get(type.getName());
        if (detailFormatter != null && detailFormatter.isEnabled()) {
            return detailFormatter.getSnippet();
        }
        return this.getDetailFormatterSuperClass(type.getSuperclass());
    }

    private Expression getCompiledExpression(IJavaObject javaObject, IJavaDebugTarget debugTarget, IJavaThread thread) throws DebugException {
        String snippet;
        IJavaClassType type = (IJavaClassType)javaObject.getJavaType();
        String typeName = type.getName();
        Key key = new Key(typeName, debugTarget);
        if (this.fCacheMap.containsKey(key)) {
            return (Expression)this.fCacheMap.get(key);
        }
        IJavaProject project = this.getJavaProject(javaObject, thread);
        if (project != null && (snippet = this.getDetailFormatter(type)) != null) {
            IAstEvaluationEngine evaluationEngine = JDIDebugPlugin.getDefault().getEvaluationEngine(project, debugTarget);
            ICompiledExpression res = evaluationEngine.getCompiledExpression(snippet, javaObject);
            Expression exp = new Expression(res, evaluationEngine);
            this.fCacheMap.put(key, exp);
            return exp;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST) || property.equals(IJDIPreferencesConstants.PREF_SHOW_DETAILS)) {
            this.populateDetailFormattersMap();
            this.fCacheMap.clear();
            IAdaptable selected = DebugUITools.getDebugContext();
            if (selected != null) {
                IJavaStackFrame frame;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((frame = (IJavaStackFrame)selected.getAdapter((Class)clazz)) != null) {
                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)frame, 16)});
                }
            }
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource() instanceof IJavaDebugTarget && event.getKind() == 8) {
                this.deleteCacheForTarget((IJavaDebugTarget)event.getSource());
            }
            ++i;
        }
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            IDebugTarget[] debugTargets = launch.getDebugTargets();
            int j = 0;
            while (j < debugTargets.length) {
                if (debugTargets[j] instanceof IJavaDebugTarget) {
                    this.deleteCacheForTarget((IJavaDebugTarget)debugTargets[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private synchronized void deleteCacheForTarget(IJavaDebugTarget debugTarget) {
        Iterator iter = this.fCacheMap.keySet().iterator();
        while (iter.hasNext()) {
            Key key = (Key)iter.next();
            if (key.fDebugTarget != debugTarget) continue;
            iter.remove();
        }
    }

    public void removeAssociatedDetailFormatter(DetailFormatter detailFormatter) {
        this.fDetailFormattersMap.remove(detailFormatter.getTypeName());
        this.savePreference();
    }

    static /* synthetic */ void access$0(JavaDetailFormattersManager javaDetailFormattersManager, IJavaValue iJavaValue, IJavaThread iJavaThread, IValueDetailListener iValueDetailListener) {
        javaDetailFormattersManager.resolveFormatter(iJavaValue, iJavaThread, iValueDetailListener);
    }

    private static class Key {
        private String fTypeName;
        private IJavaDebugTarget fDebugTarget;

        Key(String typeName, IJavaDebugTarget debugTarget) {
            this.fTypeName = typeName;
            this.fDebugTarget = debugTarget;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key key = (Key)obj;
                return this.fTypeName != null && this.fDebugTarget != null && this.fTypeName.equals(key.fTypeName) && this.fDebugTarget.equals(key.fDebugTarget);
            }
            return false;
        }

        public int hashCode() {
            return this.fTypeName.hashCode() / 2 + this.fDebugTarget.hashCode() / 2;
        }
    }

    private static class Expression {
        private ICompiledExpression fExpression;
        private IAstEvaluationEngine fEngine;

        Expression(ICompiledExpression expression, IAstEvaluationEngine engine) {
            this.fExpression = expression;
            this.fEngine = engine;
        }

        public ICompiledExpression getExpression() {
            return this.fExpression;
        }

        public IAstEvaluationEngine getEngine() {
            return this.fEngine;
        }
    }

    private static class EvaluationListener
    implements IEvaluationListener {
        private static final String fgToString = "toString";
        private static final String fgToStringSignature = "()Ljava/lang/String;";
        private IJavaValue fValue;
        private IValueDetailListener fListener;
        private IJavaThread fThread;

        public EvaluationListener(IJavaValue value, IJavaThread thread, IValueDetailListener listener) {
            this.fValue = value;
            this.fThread = thread;
            this.fListener = listener;
        }

        public void evaluationComplete(IEvaluationResult result) {
            if (result.hasErrors()) {
                StringBuffer error = new StringBuffer(DebugUIMessages.JavaDetailFormattersManager_Detail_formatter_error___1);
                DebugException exception = result.getException();
                if (exception != null) {
                    Throwable throwable = exception.getStatus().getException();
                    error.append("\n\t\t");
                    if (throwable instanceof InvocationException) {
                        error.append(MessageFormat.format(DebugUIMessages.JavaDetailFormattersManager_An_exception_occurred___0__3, ((InvocationException)throwable).exception().referenceType().name()));
                    } else {
                        error.append(exception.getStatus().getMessage());
                    }
                } else {
                    String[] errors = result.getErrorMessages();
                    int i = 0;
                    int length = errors.length;
                    while (i < length) {
                        error.append("\n\t\t").append(errors[i]);
                        ++i;
                    }
                }
                this.fListener.detailComputed((IValue)this.fValue, error.toString());
            } else {
                try {
                    this.valueToString(result.getValue());
                }
                catch (DebugException e) {
                    this.fListener.detailComputed((IValue)this.fValue, e.getStatus().getMessage());
                }
            }
        }

        public void valueToString(IJavaValue objectValue) throws DebugException {
            IEvaluationRunnable eval = new IEvaluationRunnable(this, objectValue){
                final /* synthetic */ EvaluationListener this$1;
                private final /* synthetic */ IJavaValue val$objectValue;
                {
                    this.this$1 = evaluationListener;
                    this.val$objectValue = iJavaValue;
                }

                public void run(IJavaThread thread, IProgressMonitor monitor) throws DebugException {
                    StringBuffer result = new StringBuffer();
                    if (this.val$objectValue.getSignature() == null) {
                        result.append(DebugUIMessages.JavaDetailFormattersManager_null);
                    } else if (this.val$objectValue instanceof IJavaPrimitiveValue) {
                        this.this$1.appendJDIPrimitiveValueString(result, this.val$objectValue);
                    } else if (EvaluationListener.access$0(this.this$1) == null || !EvaluationListener.access$0(this.this$1).isSuspended()) {
                        result.append(DebugUIMessages.JavaDetailFormattersManager_no_suspended_threads);
                        this.this$1.appendJDIValueString(result, this.val$objectValue);
                    } else if (this.val$objectValue instanceof IJavaArray) {
                        this.this$1.appendArrayDetail(result, (IJavaArray)this.val$objectValue);
                    } else if (this.val$objectValue instanceof IJavaObject) {
                        this.this$1.appendObjectDetail(result, (IJavaObject)this.val$objectValue);
                    } else {
                        this.this$1.appendJDIValueString(result, this.val$objectValue);
                    }
                    EvaluationListener.access$1(this.this$1).detailComputed((IValue)EvaluationListener.access$2(this.this$1), result.toString());
                }
            };
            this.fThread.runEvaluation(eval, null, 128, false);
        }

        protected void appendArrayDetail(StringBuffer result, IJavaArray arrayValue) throws DebugException {
            IJavaClassType type;
            IJavaType[] types;
            IJavaType componentType = null;
            try {
                IJavaArrayType javaArrayType = (IJavaArrayType)arrayValue.getJavaType();
                componentType = javaArrayType.getComponentType();
            }
            catch (DebugException de) {
                if (de.getStatus().getException() instanceof ClassNotLoadedException) {
                    result.append(DebugUIMessages.JavaDetailFormattersManager_0);
                } else {
                    JDIDebugUIPlugin.log(de);
                    result.append(de.getStatus().getMessage());
                }
                return;
            }
            if (!(componentType instanceof IJavaReferenceType)) {
                this.appendArrayDetailIndividually(result, arrayValue);
                return;
            }
            IJavaDebugTarget target = (IJavaDebugTarget)arrayValue.getDebugTarget();
            try {
                types = target.getJavaTypes("java.lang.Class");
            }
            catch (DebugException debugException) {
                types = null;
            }
            if (types != null && types.length > 0) {
                try {
                    type = (IJavaClassType)types[0];
                    IJavaValue arg = target.newValue("java.util.Arrays");
                    type.sendMessage("forName", "(Ljava/lang/String;)Ljava/lang/Class;", new IJavaValue[]{arg}, this.fThread);
                }
                catch (DebugException debugException) {
                    this.appendArrayDetailIndividually(result, arrayValue);
                }
            } else {
                this.appendArrayDetailIndividually(result, arrayValue);
            }
            types = null;
            types = target.getJavaTypes("java.util.Arrays");
            if (types != null && types.length > 0) {
                IJavaObject javaObject;
                type = (IJavaClassType)types[0];
                try {
                    javaObject = (IJavaObject)type.sendMessage("asList", "([Ljava/lang/Object;)Ljava/util/List;", new IJavaValue[]{arrayValue}, this.fThread);
                }
                catch (DebugException debugException) {
                    this.appendArrayDetailIndividually(result, arrayValue);
                    return;
                }
                this.appendObjectDetail(result, javaObject);
            } else {
                this.appendArrayDetailIndividually(result, arrayValue);
            }
        }

        private void appendArrayDetailIndividually(StringBuffer result, IJavaArray arrayValue) throws DebugException {
            IJavaValue[] arrayValues;
            result.append('[');
            try {
                arrayValues = arrayValue.getValues();
            }
            catch (DebugException de) {
                JDIDebugUIPlugin.log(de);
                result.append(de.getStatus().getMessage());
                return;
            }
            int i = 0;
            while (i < arrayValues.length) {
                IJavaValue value = arrayValues[i];
                if (value instanceof IJavaArray) {
                    this.appendArrayDetail(result, (IJavaArray)value);
                } else if (value instanceof IJavaObject) {
                    this.appendObjectDetail(result, (IJavaObject)value);
                } else {
                    this.appendJDIValueString(result, value);
                }
                if (i < arrayValues.length - 1) {
                    result.append(',');
                    result.append(' ');
                }
                ++i;
            }
            result.append(']');
        }

        protected void appendJDIPrimitiveValueString(StringBuffer result, IJavaValue value) throws DebugException {
            result.append(value.getValueString());
        }

        protected void appendJDIValueString(StringBuffer result, IJavaValue value) throws DebugException {
            result.append(value.getValueString());
        }

        protected void appendObjectDetail(StringBuffer result, IJavaObject objectValue) throws DebugException {
            IJavaValue toStringValue = objectValue.sendMessage(fgToString, fgToStringSignature, null, this.fThread, false);
            if (toStringValue == null) {
                result.append(DebugUIMessages.JavaDetailFormattersManager__unknown_);
            } else {
                this.appendJDIValueString(result, toStringValue);
            }
        }

        static /* synthetic */ IJavaThread access$0(EvaluationListener evaluationListener) {
            return evaluationListener.fThread;
        }

        static /* synthetic */ IValueDetailListener access$1(EvaluationListener evaluationListener) {
            return evaluationListener.fListener;
        }

        static /* synthetic */ IJavaValue access$2(EvaluationListener evaluationListener) {
            return evaluationListener.fValue;
        }
    }
}

