/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import com.sun.jdi.ObjectCollectedException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaClassPrepareBreakpoint;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodEntryBreakpoint;
import org.eclipse.jdt.debug.core.IJavaModifiers;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPatternBreakpoint;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaTargetPatternBreakpoint;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.EvaluationContextManager;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIImageDescriptor;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.internal.debug.ui.JavaDetailFormattersManager;
import org.eclipse.jdt.internal.debug.ui.LocalFileStorageEditorInput;
import org.eclipse.jdt.internal.debug.ui.ZipEntryStorageEditorInput;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaContendedMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaOwnedMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaOwningThread;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaWaitingThread;
import org.eclipse.jdt.internal.debug.ui.monitors.NoMonitorInformationElement;
import org.eclipse.jdt.internal.debug.ui.monitors.ThreadMonitorManager;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class JDIModelPresentation
extends LabelProvider
implements IDebugModelPresentation,
IColorProvider {
    public static final String DISPLAY_QUALIFIED_NAMES = "DISPLAY_QUALIFIED_NAMES";
    public static final String SHOW_HEX_VALUES = "SHOW_HEX_VALUES";
    public static final String SHOW_CHAR_VALUES = "SHOW_CHAR_VALUES";
    public static final String SHOW_UNSIGNED_VALUES = "SHOW_UNSIGNED_VALUES";
    protected HashMap fAttributes = new HashMap(3);
    static final Point BIG_SIZE = new Point(16, 16);
    private org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry fJavaElementImageRegistry;
    private ImageDescriptorRegistry fDebugImageRegistry;
    protected static final String fgStringName = "java.lang.String";
    private JavaElementLabelProvider fJavaLabelProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void computeDetail(IValue value, IValueDetailListener listener) {
        IJavaThread thread = JDIModelPresentation.getEvaluationThread((IJavaDebugTarget)value.getDebugTarget());
        if (thread == null) {
            listener.detailComputed(value, DebugUIMessages.JDIModelPresentation_no_suspended_threads);
        } else {
            JavaDetailFormattersManager.getDefault().computeValueDetail((IJavaValue)value, thread, listener);
        }
    }

    public static IJavaThread getEvaluationThread(IJavaDebugTarget target) {
        IJavaStackFrame frame = EvaluationContextManager.getEvaluationContext(null);
        IJavaThread thread = null;
        if (frame != null) {
            thread = (IJavaThread)frame.getThread();
        }
        if (!(thread == null || thread.getDebugTarget().equals(target) && (thread.isSuspended() || thread.isPerformingEvaluation()))) {
            thread = null;
        }
        if (thread == null) {
            try {
                IThread[] threads = target.getThreads();
                int i = 0;
                while (i < threads.length) {
                    if (threads[i].isSuspended()) {
                        thread = (IJavaThread)threads[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return thread;
    }

    public String getText(Object item) {
        try {
            boolean showQualified = this.isShowQualifiedNames();
            if (item instanceof IJavaVariable) {
                return this.getVariableText((IJavaVariable)item);
            }
            if (item instanceof IStackFrame) {
                StringBuffer label = new StringBuffer(this.getStackFrameText((IStackFrame)item));
                if (item instanceof IJavaStackFrame && ((IJavaStackFrame)item).isOutOfSynch()) {
                    label.append(DebugUIMessages.JDIModelPresentation___out_of_synch__1);
                }
                return label.toString();
            }
            if (item instanceof IMarker) {
                IBreakpoint breakpoint = this.getBreakpoint((IMarker)item);
                if (breakpoint != null) {
                    return this.getBreakpointText(breakpoint);
                }
                return null;
            }
            if (item instanceof IBreakpoint) {
                return this.getBreakpointText((IBreakpoint)item);
            }
            if (item instanceof IWatchExpression) {
                return this.getWatchExpressionText((IWatchExpression)item);
            }
            if (item instanceof IExpression) {
                return this.getExpressionText((IExpression)item);
            }
            if (item instanceof JavaOwnedMonitor) {
                return this.getJavaOwnedMonitorText((JavaOwnedMonitor)((Object)item));
            }
            if (item instanceof JavaContendedMonitor) {
                return this.getJavaContendedMonitorText((JavaContendedMonitor)((Object)item));
            }
            if (item instanceof JavaOwningThread) {
                return this.getJavaOwningTreadText((JavaOwningThread)((Object)item));
            }
            if (item instanceof JavaWaitingThread) {
                return this.getJavaWaitingTreadText((JavaWaitingThread)item);
            }
            if (item instanceof NoMonitorInformationElement) {
                return DebugUIMessages.JDIModelPresentation_5;
            }
            StringBuffer label = new StringBuffer();
            if (item instanceof IJavaThread) {
                label.append(this.getThreadText((IJavaThread)item, showQualified));
                if (((IJavaThread)item).isOutOfSynch()) {
                    label.append(DebugUIMessages.JDIModelPresentation___out_of_synch__1);
                } else if (((IJavaThread)item).mayBeOutOfSynch()) {
                    label.append(DebugUIMessages.JDIModelPresentation___may_be_out_of_synch__2);
                }
            } else if (item instanceof IJavaDebugTarget) {
                label.append(this.getDebugTargetText((IJavaDebugTarget)item));
                if (((IJavaDebugTarget)item).isOutOfSynch()) {
                    label.append(DebugUIMessages.JDIModelPresentation___out_of_synch__1);
                } else if (((IJavaDebugTarget)item).mayBeOutOfSynch()) {
                    label.append(DebugUIMessages.JDIModelPresentation___may_be_out_of_synch__2);
                }
            } else if (item instanceof IJavaValue) {
                label.append(this.getValueText((IJavaValue)item));
            }
            if (item instanceof ITerminate && ((ITerminate)item).isTerminated()) {
                label.insert(0, DebugUIMessages.JDIModelPresentation__terminated__2);
                return label.toString();
            }
            if (item instanceof IDisconnect && ((IDisconnect)item).isDisconnected()) {
                label.insert(0, DebugUIMessages.JDIModelPresentation__disconnected__4);
                return label.toString();
            }
            if (label.length() > 0) {
                return label.toString();
            }
        }
        catch (CoreException coreException) {
            return DebugUIMessages.JDIModelPresentation__not_responding__6;
        }
        return null;
    }

    private String getJavaOwningTreadText(JavaOwningThread thread) throws CoreException {
        return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_0, this.getThreadText(thread.getThread().getThread(), this.isShowQualifiedNames()));
    }

    private String getJavaWaitingTreadText(JavaWaitingThread thread) throws CoreException {
        return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_1, this.getThreadText(thread.getThread().getThread(), this.isShowQualifiedNames()));
    }

    private String getJavaContendedMonitorText(JavaContendedMonitor monitor) throws DebugException {
        return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_2, this.getValueText((IJavaValue)monitor.getMonitor().getMonitor()));
    }

    private String getJavaOwnedMonitorText(JavaOwnedMonitor monitor) throws DebugException {
        return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_3, this.getValueText((IJavaValue)monitor.getMonitor().getMonitor()));
    }

    protected IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }

    protected String getThreadText(IJavaThread thread, boolean qualified) throws CoreException {
        if (thread.isTerminated()) {
            if (thread.isSystemThread()) {
                return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_System_Thread____0____Terminated__7, thread.getName());
            }
            return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_Thread____0____Terminated__8, thread.getName());
        }
        if (thread.isStepping()) {
            if (thread.isSystemThread()) {
                return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_System_Thread___0____Stepping__9, thread.getName());
            }
            return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_Thread___0____Stepping__10, thread.getName());
        }
        if (thread.isPerformingEvaluation()) {
            if (thread.isSystemThread()) {
                return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_System_Thread___0____Evaluating__9, thread.getName());
            }
            return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_Thread___0____Evaluating__10, thread.getName());
        }
        if (!thread.isSuspended() || thread instanceof JDIThread && ((JDIThread)thread).isSuspendedQuiet()) {
            if (thread.isSystemThread()) {
                return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_System_Thread___0____Running__11, thread.getName());
            }
            return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_Thread___0____Running__12, thread.getName());
        }
        IBreakpoint[] breakpoints = thread.getBreakpoints();
        if (breakpoints.length > 0) {
            IJavaLineBreakpoint jlbp;
            int lineNumber;
            IJavaBreakpoint breakpoint = (IJavaBreakpoint)breakpoints[0];
            int i = 0;
            int numBreakpoints = breakpoints.length;
            while (i < numBreakpoints) {
                if (BreakpointUtils.isProblemBreakpoint(breakpoints[i])) {
                    breakpoint = (IJavaBreakpoint)breakpoints[i];
                    break;
                }
                ++i;
            }
            String typeName = this.getMarkerTypeName(breakpoint, qualified);
            if (BreakpointUtils.isProblemBreakpoint((IBreakpoint)breakpoint)) {
                IJavaStackFrame frame = (IJavaStackFrame)thread.getTopStackFrame();
                IMarker problem = null;
                if (frame != null) {
                    problem = JavaDebugOptionsManager.getDefault().getProblem(frame);
                }
                if (problem != null) {
                    String message = problem.getAttribute("message", DebugUIMessages.JDIModelPresentation_Compilation_error_1);
                    if (thread.isSystemThread()) {
                        return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_System_Thread___0____Suspended___1____2, new String[]{thread.getName(), message});
                    }
                    return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_Thread___0____Suspended___1____3, new String[]{thread.getName(), message});
                }
            }
            if (breakpoint instanceof IJavaExceptionBreakpoint) {
                String exName = ((IJavaExceptionBreakpoint)breakpoint).getExceptionTypeName();
                if (exName == null) {
                    exName = typeName;
                } else if (!qualified) {
                    int index = exName.lastIndexOf(46);
                    exName = exName.substring(index + 1);
                }
                if (thread.isSystemThread()) {
                    return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_System_Thread___0____Suspended__exception__1____13, new String[]{thread.getName(), exName});
                }
                return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_Thread___0____Suspended__exception__1____14, new String[]{thread.getName(), exName});
            }
            if (breakpoint instanceof IJavaWatchpoint) {
                IJavaWatchpoint wp = (IJavaWatchpoint)breakpoint;
                String fieldName = wp.getFieldName();
                if (wp.isAccessSuspend(thread.getDebugTarget())) {
                    if (thread.isSystemThread()) {
                        return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_System_Thread___0____Suspended__access_of_field__1__in__2____16, new String[]{thread.getName(), fieldName, typeName});
                    }
                    return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_Thread___0____Suspended__access_of_field__1__in__2____17, new String[]{thread.getName(), fieldName, typeName});
                }
                if (thread.isSystemThread()) {
                    return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_System_Thread___0____Suspended__modification_of_field__1__in__2____18, new String[]{thread.getName(), fieldName, typeName});
                }
                return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_Thread___0____Suspended__modification_of_field__1__in__2____19, new String[]{thread.getName(), fieldName, typeName});
            }
            if (breakpoint instanceof IJavaMethodBreakpoint) {
                IJavaMethodBreakpoint me = (IJavaMethodBreakpoint)breakpoint;
                String methodName = me.getMethodName();
                if (me.isEntrySuspend(thread.getDebugTarget())) {
                    if (thread.isSystemThread()) {
                        return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_System_Thread___0____Suspended__entry_into_method__1__in__2____21, new String[]{thread.getName(), methodName, typeName});
                    }
                    return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_Thread___0____Suspended__entry_into_method__1__in__2____22, new String[]{thread.getName(), methodName, typeName});
                }
                if (thread.isSystemThread()) {
                    return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_System_Thread___0____Suspended__exit_of_method__1__in__2____21, new String[]{thread.getName(), methodName, typeName});
                }
                return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_Thread___0____Suspended__exit_of_method__1__in__2____22, new String[]{thread.getName(), methodName, typeName});
            }
            if (breakpoint instanceof IJavaLineBreakpoint && (lineNumber = (jlbp = (IJavaLineBreakpoint)breakpoint).getLineNumber()) > -1) {
                if (thread.isSystemThread()) {
                    if (BreakpointUtils.isRunToLineBreakpoint(jlbp)) {
                        return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_System_Thread___0____Suspended__run_to_line__1__in__2____23, new String[]{thread.getName(), String.valueOf(lineNumber), typeName});
                    }
                    return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_System_Thread___0____Suspended__breakpoint_at_line__1__in__2____24, new String[]{thread.getName(), String.valueOf(lineNumber), typeName});
                }
                if (BreakpointUtils.isRunToLineBreakpoint(jlbp)) {
                    return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_Thread___0____Suspended__run_to_line__1__in__2____25, new String[]{thread.getName(), String.valueOf(lineNumber), typeName});
                }
                return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_Thread___0____Suspended__breakpoint_at_line__1__in__2____26, new String[]{thread.getName(), String.valueOf(lineNumber), typeName});
            }
            if (breakpoint instanceof IJavaClassPrepareBreakpoint) {
                return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_115, new String[]{thread.getName(), this.getQualifiedName(breakpoint.getTypeName())});
            }
        }
        if (thread.isSystemThread()) {
            return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_System_Thread___0____Suspended__27, thread.getName());
        }
        return JDIModelPresentation.getFormattedString(DebugUIMessages.JDIModelPresentation_Thread___0____Suspended__28, thread.getName());
    }

    protected String getDebugTargetText(IJavaDebugTarget debugTarget) throws DebugException {
        String labelString = debugTarget.getName();
        if (debugTarget.isSuspended()) {
            labelString = String.valueOf(labelString) + DebugUIMessages.JDIModelPresentation_target_suspended;
        }
        return labelString;
    }

    protected String getValueText(IJavaValue value) throws DebugException {
        String refTypeName = value.getReferenceTypeName();
        String valueString = value.getValueString();
        boolean isString = refTypeName.equals(fgStringName);
        IJavaType type = value.getJavaType();
        String signature = null;
        if (type != null) {
            signature = type.getSignature();
        }
        if ("V".equals(signature)) {
            valueString = DebugUIMessages.JDIModelPresentation__No_explicit_return_value__30;
        }
        boolean isObject = JDIModelPresentation.isObjectValue(signature);
        boolean isArray = value instanceof IJavaArray;
        StringBuffer buffer = new StringBuffer();
        if (isObject && !isString && refTypeName.length() > 0) {
            String qualTypeName = this.getQualifiedName(refTypeName);
            if (isArray) {
                qualTypeName = this.adjustTypeNameForArrayIndex(qualTypeName, ((IJavaArray)value).getLength());
            }
            buffer.append(qualTypeName);
            buffer.append(' ');
        }
        if (valueString != null && (isString || valueString.length() > 0)) {
            if (isString) {
                buffer.append('\"');
            }
            buffer.append(valueString);
            if (isString) {
                buffer.append('\"');
            }
        }
        if (this.isShowUnsignedValues()) {
            buffer = this.appendUnsignedText(value, buffer);
        }
        if (this.isShowHexValues()) {
            buffer = this.appendHexText(value, buffer);
        }
        if (this.isShowCharValues()) {
            buffer = this.appendCharText(value, buffer);
        }
        return buffer.toString();
    }

    private StringBuffer appendUnsignedText(IJavaValue value, StringBuffer buffer) throws DebugException {
        String unsignedText = this.getValueUnsignedText(value);
        if (unsignedText != null) {
            buffer.append(" [");
            buffer.append(unsignedText);
            buffer.append("]");
        }
        return buffer;
    }

    protected StringBuffer appendHexText(IJavaValue value, StringBuffer buffer) throws DebugException {
        String hexText = this.getValueHexText(value);
        if (hexText != null) {
            buffer.append(" [");
            buffer.append(hexText);
            buffer.append("]");
        }
        return buffer;
    }

    protected StringBuffer appendCharText(IJavaValue value, StringBuffer buffer) throws DebugException {
        String charText = this.getValueCharText(value);
        if (charText != null) {
            buffer.append(" [");
            buffer.append(charText);
            buffer.append("]");
        }
        return buffer;
    }

    public static boolean isObjectValue(String signature) {
        if (signature == null) {
            return false;
        }
        int sigChar = 32;
        int i = 0;
        if (i < signature.length()) {
            sigChar = signature.charAt(i);
            if (sigChar == 91) {
                return true;
            }
        }
        return sigChar == 76 || sigChar == 81;
    }

    protected String getPrimitiveValueTypeSignature(IJavaValue value) throws DebugException {
        String sig;
        IJavaType type = value.getJavaType();
        if (type != null && (sig = type.getSignature()) != null && sig.length() == 1) {
            return sig;
        }
        return null;
    }

    protected String getValueCharText(IJavaValue value) throws DebugException {
        long longValue;
        String sig = this.getPrimitiveValueTypeSignature(value);
        if (sig == null) {
            return null;
        }
        String valueString = value.getValueString();
        try {
            longValue = Long.parseLong(valueString);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        switch (sig.charAt(0)) {
            case 'B': {
                longValue &= 0xFFL;
                break;
            }
            case 'I': {
                if ((longValue &= 0xFFFFFFFFFFFFFFFFL) <= 65535L && longValue >= 0L) break;
                return null;
            }
            case 'S': {
                longValue &= 0xFFFFL;
                break;
            }
            case 'J': {
                if (longValue <= 65535L && longValue >= 0L) break;
                return null;
            }
            default: {
                return null;
            }
        }
        char charValue = (char)longValue;
        StringBuffer charText = new StringBuffer();
        if (Character.getType(charValue) == 15) {
            Character ctrl = new Character((char)(charValue + 64));
            charText.append('^');
            charText.append(ctrl);
            switch (charValue) {
                case '\u0000': {
                    charText.append(" (NUL)");
                    break;
                }
                case '\b': {
                    charText.append(" (BS)");
                    break;
                }
                case '\t': {
                    charText.append(" (TAB)");
                    break;
                }
                case '\n': {
                    charText.append(" (LF)");
                    break;
                }
                case '\r': {
                    charText.append(" (CR)");
                    break;
                }
                case '\u0015': {
                    charText.append(" (NL)");
                    break;
                }
                case '\u001b': {
                    charText.append(" (ESC)");
                    break;
                }
                case '\u007f': {
                    charText.append(" (DEL)");
                }
            }
        } else {
            charText.append(new Character(charValue));
        }
        return charText.toString();
    }

    protected String getMarkerTypeName(IJavaBreakpoint breakpoint, boolean qualified) throws CoreException {
        int index;
        String typeName = null;
        typeName = breakpoint instanceof IJavaPatternBreakpoint ? breakpoint.getMarker().getResource().getName() : breakpoint.getTypeName();
        if (!qualified && (index = typeName.lastIndexOf(46)) != -1) {
            typeName = typeName.substring(index + 1);
        }
        return typeName;
    }

    public Image getImage(Object item) {
        try {
            IBreakpoint bp;
            if (item instanceof IJavaVariable) {
                return this.getVariableImage((IAdaptable)item);
            }
            if (item instanceof IMarker && (bp = this.getBreakpoint((IMarker)item)) != null && bp instanceof IJavaBreakpoint) {
                return this.getBreakpointImage((IJavaBreakpoint)bp);
            }
            if (item instanceof IJavaBreakpoint) {
                return this.getBreakpointImage((IJavaBreakpoint)item);
            }
            if (item instanceof IJavaStackFrame || item instanceof IJavaThread || item instanceof IJavaDebugTarget) {
                return this.getDebugElementImage(item);
            }
            if (item instanceof IJavaValue) {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpub_obj.gif");
            }
            if (item instanceof IExpression) {
                return this.getExpressionImage(item);
            }
            if (item instanceof JavaOwnedMonitor) {
                return this.getJavaOwnedMonitorImage((JavaOwnedMonitor)((Object)item));
            }
            if (item instanceof JavaContendedMonitor) {
                return this.getJavaContendedMonitorImage((JavaContendedMonitor)((Object)item));
            }
            if (item instanceof JavaOwningThread) {
                return this.getJavaOwningThreadImage((JavaOwningThread)((Object)item));
            }
            if (item instanceof JavaWaitingThread) {
                return this.getJavaWaitingThreadImage((JavaWaitingThread)item);
            }
            if (item instanceof NoMonitorInformationElement) {
                return this.getDebugImageRegistry().get((ImageDescriptor)new JDIImageDescriptor(this.getImageDescriptor("IMG_OBJS_MONITOR"), 0));
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private Image getJavaWaitingThreadImage(JavaWaitingThread thread) {
        int flag = 0x2000 | (thread.getThread().isInDeadlock() ? 32768 : 0);
        JDIImageDescriptor descriptor = thread.isSuspended() ? new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_SUSPENDED"), flag) : new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_RUNNING"), flag);
        return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
    }

    private Image getJavaOwningThreadImage(JavaOwningThread thread) {
        int flag = 0x400 | (thread.getThread().isInDeadlock() ? 32768 : 0);
        JDIImageDescriptor descriptor = thread.isSuspended() ? new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_SUSPENDED"), flag) : new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_RUNNING"), flag);
        return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
    }

    private Image getJavaContendedMonitorImage(JavaContendedMonitor monitor) {
        int flag = monitor.getMonitor().isInDeadlock() ? 32768 : 0;
        JDIImageDescriptor descriptor = new JDIImageDescriptor(this.getImageDescriptor("IMG_OBJS_CONTENDED_MONITOR"), flag);
        return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
    }

    private Image getJavaOwnedMonitorImage(JavaOwnedMonitor monitor) {
        int flag = monitor.getMonitor().isInDeadlock() ? 32768 : 0;
        JDIImageDescriptor descriptor = new JDIImageDescriptor(this.getImageDescriptor("IMG_OBJS_OWNED_MONITOR"), flag);
        return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
    }

    protected Image getBreakpointImage(IJavaBreakpoint breakpoint) throws CoreException {
        if (breakpoint instanceof IJavaExceptionBreakpoint) {
            return this.getExceptionBreakpointImage((IJavaExceptionBreakpoint)breakpoint);
        }
        if (breakpoint instanceof IJavaClassPrepareBreakpoint) {
            return this.getClassPrepareBreakpointImage((IJavaClassPrepareBreakpoint)breakpoint);
        }
        if (breakpoint instanceof IJavaLineBreakpoint && BreakpointUtils.isRunToLineBreakpoint((IJavaLineBreakpoint)breakpoint)) {
            return null;
        }
        return this.getJavaBreakpointImage(breakpoint);
    }

    protected Image getExceptionBreakpointImage(IJavaExceptionBreakpoint exception) throws CoreException {
        int flags = this.computeBreakpointAdornmentFlags((IJavaBreakpoint)exception);
        JDIImageDescriptor descriptor = null;
        descriptor = (flags & 0x20) == 0 ? new JDIImageDescriptor(this.getImageDescriptor("IMG_OBJS_EXCEPTION_DISABLED"), flags) : (exception.isChecked() ? new JDIImageDescriptor(this.getImageDescriptor("IMG_OBJS_EXCEPTION"), flags) : new JDIImageDescriptor(this.getImageDescriptor("IMG_OBJS_ERROR"), flags));
        return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
    }

    protected Image getJavaBreakpointImage(IJavaBreakpoint breakpoint) throws CoreException {
        if (breakpoint instanceof IJavaMethodBreakpoint) {
            IJavaMethodBreakpoint mBreakpoint = (IJavaMethodBreakpoint)breakpoint;
            return this.getJavaMethodBreakpointImage(mBreakpoint);
        }
        if (breakpoint instanceof IJavaWatchpoint) {
            IJavaWatchpoint watchpoint = (IJavaWatchpoint)breakpoint;
            return this.getJavaWatchpointImage(watchpoint);
        }
        if (breakpoint instanceof IJavaMethodEntryBreakpoint) {
            IJavaMethodEntryBreakpoint meBreakpoint = (IJavaMethodEntryBreakpoint)breakpoint;
            return this.getJavaMethodEntryBreakpointImage(meBreakpoint);
        }
        int flags = this.computeBreakpointAdornmentFlags(breakpoint);
        JDIImageDescriptor descriptor = null;
        descriptor = breakpoint.isEnabled() ? new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), flags) : new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), flags);
        return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
    }

    protected Image getJavaMethodBreakpointImage(IJavaMethodBreakpoint mBreakpoint) throws CoreException {
        int flags = this.computeBreakpointAdornmentFlags((IJavaBreakpoint)mBreakpoint);
        JDIImageDescriptor descriptor = null;
        descriptor = mBreakpoint.isEnabled() ? new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), flags) : new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), flags);
        return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
    }

    protected Image getJavaMethodEntryBreakpointImage(IJavaMethodEntryBreakpoint mBreakpoint) throws CoreException {
        int flags = this.computeBreakpointAdornmentFlags((IJavaBreakpoint)mBreakpoint);
        JDIImageDescriptor descriptor = null;
        descriptor = mBreakpoint.isEnabled() ? new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), flags) : new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), flags);
        return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
    }

    protected Image getClassPrepareBreakpointImage(IJavaClassPrepareBreakpoint breakpoint) throws CoreException {
        int flags = this.computeBreakpointAdornmentFlags((IJavaBreakpoint)breakpoint);
        JDIImageDescriptor descriptor = null;
        descriptor = breakpoint.getMemberType() == 0 ? new JDIImageDescriptor(JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.class_obj.gif"), flags) : new JDIImageDescriptor(JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.int_obj.gif"), flags);
        return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
    }

    protected Image getJavaWatchpointImage(IJavaWatchpoint watchpoint) throws CoreException {
        boolean enabled;
        int flags = this.computeBreakpointAdornmentFlags((IJavaBreakpoint)watchpoint);
        JDIImageDescriptor descriptor = null;
        boolean bl = enabled = (flags & 0x20) != 0;
        descriptor = watchpoint.isAccess() ? (watchpoint.isModification() ? (enabled ? new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_WATCHPOINT"), flags) : new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_WATCHPOINT_DISABLED"), flags)) : (enabled ? new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_ACCESS_WATCHPOINT"), flags) : new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_ACCESS_WATCHPOINT_DISABLED"), flags))) : (watchpoint.isModification() ? (enabled ? new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_MODIFICATION_WATCHPOINT"), flags) : new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_MODIFICATION_WATCHPOINT_DISABLED"), flags)) : new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_WATCHPOINT_DISABLED"), flags));
        return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
    }

    protected Image getVariableImage(IAdaptable element) {
        JavaElementImageDescriptor descriptor = new JavaElementImageDescriptor(this.computeBaseImageDescriptor(element), this.computeAdornmentFlags(element), BIG_SIZE);
        return this.getJavaElementImageRegistry().get((ImageDescriptor)descriptor);
    }

    protected Image getDebugElementImage(Object element) {
        IJavaThread thread;
        ImageDescriptor image = null;
        image = element instanceof IJavaThread ? ((thread = (IJavaThread)element).isSuspended() && !thread.isPerformingEvaluation() ? DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_SUSPENDED") : (thread.isTerminated() ? DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_TERMINATED") : DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_RUNNING"))) : DebugUITools.getDefaultImageDescriptor((Object)element);
        if (image == null) {
            return null;
        }
        int flags = this.computeJDIAdornmentFlags(element);
        JDIImageDescriptor descriptor = new JDIImageDescriptor(image, flags);
        return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
    }

    protected Image getExpressionImage(Object expression) {
        ImageDescriptor image = null;
        boolean bigSize = false;
        if (expression instanceof JavaInspectExpression) {
            image = JavaDebugImages.getImageDescriptor("IMG_OBJ_JAVA_INSPECT_EXPRESSION");
            bigSize = true;
        }
        if (image == null) {
            return null;
        }
        JDIImageDescriptor descriptor = new JDIImageDescriptor(image, 0);
        if (bigSize) {
            descriptor.setSize(BIG_SIZE);
        }
        return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
    }

    private int computeJDIAdornmentFlags(Object element) {
        try {
            if (element instanceof IJavaStackFrame) {
                IJavaStackFrame javaStackFrame = (IJavaStackFrame)element;
                if (javaStackFrame.isOutOfSynch()) {
                    return 1;
                }
                if (!javaStackFrame.isObsolete() && javaStackFrame.isSynchronized()) {
                    return 16384;
                }
            }
            if (element instanceof IJavaThread) {
                int flag = 0;
                IJavaThread javaThread = (IJavaThread)element;
                if (ThreadMonitorManager.getDefault().isInDeadlock((IThread)javaThread)) {
                    flag = 32768;
                }
                if (javaThread.isOutOfSynch()) {
                    return flag | 1;
                }
                if (javaThread.mayBeOutOfSynch()) {
                    return flag | 2;
                }
                return flag;
            }
            if (element instanceof IJavaDebugTarget) {
                if (((IJavaDebugTarget)element).isOutOfSynch()) {
                    return 1;
                }
                if (((IJavaDebugTarget)element).mayBeOutOfSynch()) {
                    return 2;
                }
            }
        }
        catch (DebugException debugException) {}
        return 0;
    }

    private int computeBreakpointAdornmentFlags(IJavaBreakpoint breakpoint) {
        int flags = 0;
        try {
            if (breakpoint.isEnabled()) {
                flags |= 0x20;
            }
            if (breakpoint.isInstalled()) {
                flags |= 4;
            }
            if (breakpoint instanceof IJavaLineBreakpoint) {
                if (((IJavaLineBreakpoint)breakpoint).isConditionEnabled()) {
                    flags |= 0x40;
                }
                if (breakpoint instanceof IJavaMethodBreakpoint) {
                    IJavaMethodBreakpoint mBreakpoint = (IJavaMethodBreakpoint)breakpoint;
                    if (mBreakpoint.isEntry()) {
                        flags |= 8;
                    }
                    if (mBreakpoint.isExit()) {
                        flags |= 0x10;
                    }
                }
                if (breakpoint instanceof IJavaMethodEntryBreakpoint) {
                    flags |= 8;
                }
            } else if (breakpoint instanceof IJavaExceptionBreakpoint) {
                IJavaExceptionBreakpoint eBreakpoint = (IJavaExceptionBreakpoint)breakpoint;
                if (eBreakpoint.isCaught()) {
                    flags |= 0x80;
                }
                if (eBreakpoint.isUncaught()) {
                    flags |= 0x100;
                }
                if (eBreakpoint.getExclusionFilters().length > 0 || eBreakpoint.getInclusionFilters().length > 0) {
                    flags |= 0x200;
                }
            }
        }
        catch (CoreException coreException) {}
        return flags;
    }

    private ImageDescriptor computeBaseImageDescriptor(IAdaptable element) {
        IJavaVariable javaVariable;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaVariable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((javaVariable = (IJavaVariable)element.getAdapter((Class)clazz)) != null) {
            try {
                if (javaVariable.isLocal()) {
                    return JavaDebugImages.getImageDescriptor("IMG_OBJS_LOCAL_VARIABLE");
                }
                if (javaVariable.isPublic()) {
                    return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methpub_obj.gif");
                }
                if (javaVariable.isProtected()) {
                    return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methpro_obj.gif");
                }
                if (javaVariable.isPrivate()) {
                    return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methpri_obj.gif");
                }
            }
            catch (DebugException debugException) {}
        }
        return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methdef_obj.gif");
    }

    private int computeAdornmentFlags(IAdaptable element) {
        int flags = 0;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.debug.core.IJavaModifiers");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IJavaModifiers javaProperties = (IJavaModifiers)element.getAdapter((Class)clazz);
        try {
            if (javaProperties != null) {
                if (javaProperties.isFinal()) {
                    flags |= 2;
                }
                if (javaProperties.isStatic()) {
                    flags |= 8;
                }
            }
        }
        catch (DebugException debugException) {}
        return flags;
    }

    public IEditorInput getEditorInput(Object item) {
        try {
            if (item instanceof IMarker) {
                item = this.getBreakpoint((IMarker)item);
            }
            if (item instanceof IJavaBreakpoint) {
                IType type = BreakpointUtils.getType((IJavaBreakpoint)item);
                item = type == null ? ((IJavaBreakpoint)item).getMarker().getResource() : type;
            }
            if (item instanceof LocalFileStorage) {
                return new LocalFileStorageEditorInput((LocalFileStorage)item);
            }
            if (item instanceof ZipEntryStorage) {
                return new ZipEntryStorageEditorInput((ZipEntryStorage)item);
            }
            return EditorUtility.getEditorInput((Object)item);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
            return null;
        }
    }

    public String getEditorId(IEditorInput input, Object inputObject) {
        try {
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
            return descriptor.getId();
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public void setAttribute(String id, Object value) {
        if (value == null) {
            return;
        }
        this.fAttributes.put(id, value);
    }

    protected boolean isShowQualifiedNames() {
        Boolean showQualified = (Boolean)this.fAttributes.get(DISPLAY_QUALIFIED_NAMES);
        showQualified = showQualified == null ? Boolean.FALSE : showQualified;
        return showQualified;
    }

    protected boolean isShowVariableTypeNames() {
        Boolean show = (Boolean)this.fAttributes.get(DISPLAY_VARIABLE_TYPE_NAMES);
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    protected boolean isShowHexValues() {
        Boolean show = (Boolean)this.fAttributes.get(SHOW_HEX_VALUES);
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    protected boolean isShowCharValues() {
        Boolean show = (Boolean)this.fAttributes.get(SHOW_CHAR_VALUES);
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    protected boolean isShowUnsignedValues() {
        Boolean show = (Boolean)this.fAttributes.get(SHOW_UNSIGNED_VALUES);
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    protected String getVariableText(IJavaVariable var) {
        IJavaFieldVariable field;
        String varLabel = DebugUIMessages.JDIModelPresentation_unknown_name__1;
        try {
            varLabel = var.getName();
        }
        catch (DebugException debugException) {}
        IJavaValue javaValue = null;
        try {
            javaValue = (IJavaValue)var.getValue();
        }
        catch (DebugException debugException) {}
        boolean showTypes = this.isShowVariableTypeNames();
        int spaceIndex = varLabel.lastIndexOf(32);
        StringBuffer buff = new StringBuffer();
        String typeName = DebugUIMessages.JDIModelPresentation_unknown_type__2;
        try {
            typeName = var.getReferenceTypeName();
            if (showTypes && spaceIndex == -1) {
                typeName = this.getQualifiedName(typeName);
            }
        }
        catch (DebugException debugException) {}
        if (showTypes) {
            buff.append(typeName);
            buff.append(' ');
        }
        if (spaceIndex != -1 && !showTypes) {
            varLabel = varLabel.substring(spaceIndex + 1);
        }
        buff.append(varLabel);
        if (var instanceof IJavaFieldVariable && this.isDuplicateName(field = (IJavaFieldVariable)var)) {
            try {
                String decl = field.getDeclaringType().getName();
                buff.append(MessageFormat.format(" ({0})", this.getQualifiedName(decl)));
            }
            catch (DebugException debugException) {}
        }
        String valueString = DebugUIMessages.JDIModelPresentation_unknown_value__3;
        if (javaValue != null) {
            if (this.isShowLabelDetails(javaValue)) {
                valueString = this.getVariableDetail(var);
                if (valueString == null) {
                    valueString = DebugUIMessages.JDIModelPresentation_unknown_value__3;
                }
            } else {
                try {
                    valueString = this.getValueText(javaValue);
                }
                catch (DebugException debugException) {}
            }
        }
        if (valueString.length() != 0) {
            buff.append("= ");
            buff.append(valueString);
        }
        return buff.toString();
    }

    protected boolean isShowLabelDetails(IJavaValue value) {
        boolean showDetails = false;
        String details = JDIDebugUIPlugin.getDefault().getPreferenceStore().getString(IJDIPreferencesConstants.PREF_SHOW_DETAILS);
        if (details != null) {
            if (details.equals("INLINE_ALL")) {
                showDetails = true;
            } else if (details.equals("INLINE_FORMATTERS")) {
                try {
                    IJavaType javaType = value.getJavaType();
                    JavaDetailFormattersManager manager = JavaDetailFormattersManager.getDefault();
                    DetailFormatter formatter = manager.getAssociatedDetailFormatter(javaType);
                    showDetails = formatter != null && formatter.isEnabled();
                }
                catch (DebugException debugException) {}
            }
        }
        return showDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVariableDetail(IJavaVariable variable) {
        final String[] detail = new String[1];
        final Object lock = new Object();
        try {
            this.computeDetail(variable.getValue(), new IValueDetailListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void detailComputed(IValue value, String result) {
                    Object object = lock;
                    synchronized (object) {
                        detail[0] = result;
                        lock.notifyAll();
                    }
                }
            });
            Object object = lock;
            synchronized (object) {
                if (detail[0] == null) {
                    try {
                        lock.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (DebugException debugException) {}
        return detail[0];
    }

    protected String getExpressionText(IExpression expression) throws DebugException {
        String valueString;
        boolean showTypes = this.isShowVariableTypeNames();
        StringBuffer buff = new StringBuffer();
        IJavaValue javaValue = (IJavaValue)expression.getValue();
        if (javaValue != null) {
            String typeName = null;
            try {
                typeName = javaValue.getReferenceTypeName();
            }
            catch (DebugException exception) {
                if (exception.getStatus().getException() instanceof ObjectCollectedException) {
                    return DebugUIMessages.JDIModelPresentation__garbage_collected_object__6;
                }
                throw exception;
            }
            if (showTypes && (typeName = this.getQualifiedName(typeName)).length() > 0) {
                buff.append(typeName);
                buff.append(' ');
            }
        }
        buff.append(String.valueOf('\"') + expression.getExpressionText() + '\"');
        if (javaValue != null && (valueString = this.getValueText(javaValue)).length() > 0) {
            buff.append("= ");
            buff.append(valueString);
        }
        return buff.toString();
    }

    protected String getWatchExpressionText(IWatchExpression expression) throws DebugException {
        return String.valueOf(this.getExpressionText((IExpression)expression)) + (expression.isEnabled() ? "" : DebugUIMessages.JDIModelPresentation_116);
    }

    protected String adjustTypeNameForArrayIndex(String typeName, int arrayIndex) {
        int firstBracket = typeName.indexOf("[]");
        if (firstBracket < 0) {
            return typeName;
        }
        StringBuffer buffer = new StringBuffer(typeName);
        buffer.insert(firstBracket + 1, Integer.toString(arrayIndex));
        return buffer.toString();
    }

    protected String getValueUnsignedText(IJavaValue value) throws DebugException {
        String sig = this.getPrimitiveValueTypeSignature(value);
        if (sig == null) {
            return null;
        }
        switch (sig.charAt(0)) {
            case 'B': {
                int byteVal;
                try {
                    byteVal = Integer.parseInt(value.getValueString());
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                if (byteVal >= 0) break;
                return Integer.toString(byteVal &= 0xFF);
            }
        }
        return null;
    }

    protected String getValueHexText(IJavaValue value) throws DebugException {
        long longValue;
        String sig = this.getPrimitiveValueTypeSignature(value);
        if (sig == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        char sigValue = sig.charAt(0);
        try {
            longValue = sigValue == 'C' ? (long)value.getValueString().charAt(0) : Long.parseLong(value.getValueString());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        switch (sigValue) {
            case 'B': {
                buff.append("0x");
                buff.append(Long.toHexString(longValue &= 0xFFL));
                break;
            }
            case 'I': {
                buff.append("0x");
                buff.append(Long.toHexString(longValue &= 0xFFFFFFFFL));
                break;
            }
            case 'S': {
                buff.append("0x");
                buff.append(Long.toHexString(longValue &= 0xFFFFL));
                break;
            }
            case 'J': {
                buff.append("0x");
                buff.append(Long.toHexString(longValue));
                break;
            }
            case 'C': {
                buff.append("\\u");
                String hexString = Long.toHexString(longValue);
                int length = hexString.length();
                while (length < 4) {
                    buff.append('0');
                    ++length;
                }
                buff.append(hexString);
                break;
            }
            default: {
                return null;
            }
        }
        return buff.toString();
    }

    protected String getBreakpointText(IBreakpoint breakpoint) {
        try {
            if (breakpoint instanceof IJavaExceptionBreakpoint) {
                return this.getExceptionBreakpointText((IJavaExceptionBreakpoint)breakpoint);
            }
            if (breakpoint instanceof IJavaWatchpoint) {
                return this.getWatchpointText((IJavaWatchpoint)breakpoint);
            }
            if (breakpoint instanceof IJavaMethodBreakpoint) {
                return this.getMethodBreakpointText((IJavaMethodBreakpoint)breakpoint);
            }
            if (breakpoint instanceof IJavaPatternBreakpoint) {
                return this.getJavaPatternBreakpointText((IJavaPatternBreakpoint)breakpoint);
            }
            if (breakpoint instanceof IJavaTargetPatternBreakpoint) {
                return this.getJavaTargetPatternBreakpointText((IJavaTargetPatternBreakpoint)breakpoint);
            }
            if (breakpoint instanceof IJavaStratumLineBreakpoint) {
                return this.getJavaStratumLineBreakpointText((IJavaStratumLineBreakpoint)breakpoint);
            }
            if (breakpoint instanceof IJavaLineBreakpoint) {
                return this.getLineBreakpointText((IJavaLineBreakpoint)breakpoint);
            }
            if (breakpoint instanceof IJavaClassPrepareBreakpoint) {
                return this.getClassPrepareBreakpointText((IJavaClassPrepareBreakpoint)breakpoint);
            }
            return "";
        }
        catch (CoreException e) {
            IMarker marker = breakpoint.getMarker();
            if (marker == null || !marker.exists()) {
                return DebugUIMessages.JDIModelPresentation_6;
            }
            JDIDebugUIPlugin.log(e);
            return DebugUIMessages.JDIModelPresentation_4;
        }
    }

    private String getJavaStratumLineBreakpointText(IJavaStratumLineBreakpoint breakpoint) throws CoreException {
        IMember member = BreakpointUtils.getMember((IJavaLineBreakpoint)breakpoint);
        String sourceName = breakpoint.getSourceName();
        if (sourceName == null) {
            IResource resource;
            sourceName = "";
            IMarker marker = breakpoint.getMarker();
            if (marker != null && (resource = marker.getResource()).getType() == 1) {
                sourceName = resource.getName();
            }
        }
        StringBuffer label = new StringBuffer(sourceName);
        this.appendLineNumber((IJavaLineBreakpoint)breakpoint, label);
        this.appendHitCount((IJavaBreakpoint)breakpoint, label);
        this.appendSuspendPolicy((IJavaBreakpoint)breakpoint, label);
        this.appendThreadFilter((IJavaBreakpoint)breakpoint, label);
        if (member != null) {
            label.append(" - ");
            label.append(this.getJavaLabelProvider().getText((Object)member));
        }
        return label.toString();
    }

    protected String getExceptionBreakpointText(IJavaExceptionBreakpoint breakpoint) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        String typeName = breakpoint.getTypeName();
        buffer.append(this.getQualifiedName(typeName));
        this.appendHitCount((IJavaBreakpoint)breakpoint, buffer);
        this.appendSuspendPolicy((IJavaBreakpoint)breakpoint, buffer);
        this.appendThreadFilter((IJavaBreakpoint)breakpoint, buffer);
        if (breakpoint.getExclusionFilters().length > 0 || breakpoint.getInclusionFilters().length > 0) {
            buffer.append(DebugUIMessages.JDIModelPresentation___scoped__1);
        }
        this.appendInstanceFilter((IJavaBreakpoint)breakpoint, buffer);
        String state = null;
        boolean c = breakpoint.isCaught();
        boolean u = breakpoint.isUncaught();
        if (c && u) {
            state = DebugUIMessages.JDIModelPresentation_caught_and_uncaught_60;
        } else if (c) {
            state = DebugUIMessages.JDIModelPresentation_caught_61;
        } else if (u) {
            state = DebugUIMessages.JDIModelPresentation_uncaught_62;
        }
        String label = null;
        if (state == null) {
            label = buffer.toString();
        } else {
            String format = DebugUIMessages.JDIModelPresentation__1____0__63;
            label = MessageFormat.format(format, state, buffer);
        }
        return label;
    }

    protected String getLineBreakpointText(IJavaLineBreakpoint breakpoint) throws CoreException {
        String typeName = breakpoint.getTypeName();
        IMember member = BreakpointUtils.getMember(breakpoint);
        StringBuffer label = new StringBuffer();
        label.append(this.getQualifiedName(typeName));
        this.appendLineNumber(breakpoint, label);
        this.appendHitCount((IJavaBreakpoint)breakpoint, label);
        this.appendSuspendPolicy((IJavaBreakpoint)breakpoint, label);
        this.appendThreadFilter((IJavaBreakpoint)breakpoint, label);
        this.appendConditional(breakpoint, label);
        this.appendInstanceFilter((IJavaBreakpoint)breakpoint, label);
        if (member != null) {
            label.append(" - ");
            label.append(this.getJavaLabelProvider().getText((Object)member));
        }
        return label.toString();
    }

    protected String getClassPrepareBreakpointText(IJavaClassPrepareBreakpoint breakpoint) throws CoreException {
        String typeName = breakpoint.getTypeName();
        StringBuffer label = new StringBuffer();
        label.append(this.getQualifiedName(typeName));
        this.appendHitCount((IJavaBreakpoint)breakpoint, label);
        this.appendSuspendPolicy((IJavaBreakpoint)breakpoint, label);
        return label.toString();
    }

    protected StringBuffer appendLineNumber(IJavaLineBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int lineNumber = breakpoint.getLineNumber();
        if (lineNumber > 0) {
            label.append(" [");
            label.append(DebugUIMessages.JDIModelPresentation_line__65);
            label.append(' ');
            label.append(lineNumber);
            label.append(']');
        }
        return label;
    }

    protected StringBuffer appendHitCount(IJavaBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int hitCount = breakpoint.getHitCount();
        if (hitCount > 0) {
            label.append(" [");
            label.append(DebugUIMessages.JDIModelPresentation_hit_count__67);
            label.append(' ');
            label.append(hitCount);
            label.append(']');
        }
        return label;
    }

    protected String getJavaPatternBreakpointText(IJavaPatternBreakpoint breakpoint) throws CoreException {
        IResource resource = breakpoint.getMarker().getResource();
        IMember member = BreakpointUtils.getMember((IJavaLineBreakpoint)breakpoint);
        StringBuffer label = new StringBuffer(resource.getName());
        this.appendLineNumber((IJavaLineBreakpoint)breakpoint, label);
        this.appendHitCount((IJavaBreakpoint)breakpoint, label);
        this.appendSuspendPolicy((IJavaBreakpoint)breakpoint, label);
        this.appendThreadFilter((IJavaBreakpoint)breakpoint, label);
        if (member != null) {
            label.append(" - ");
            label.append(this.getJavaLabelProvider().getText((Object)member));
        }
        return label.toString();
    }

    protected String getJavaTargetPatternBreakpointText(IJavaTargetPatternBreakpoint breakpoint) throws CoreException {
        IMember member = BreakpointUtils.getMember((IJavaLineBreakpoint)breakpoint);
        StringBuffer label = new StringBuffer(breakpoint.getSourceName());
        this.appendLineNumber((IJavaLineBreakpoint)breakpoint, label);
        this.appendHitCount((IJavaBreakpoint)breakpoint, label);
        this.appendSuspendPolicy((IJavaBreakpoint)breakpoint, label);
        this.appendThreadFilter((IJavaBreakpoint)breakpoint, label);
        if (member != null) {
            label.append(" - ");
            label.append(this.getJavaLabelProvider().getText((Object)member));
        }
        return label.toString();
    }

    protected String getWatchpointText(IJavaWatchpoint watchpoint) throws CoreException {
        String typeName = watchpoint.getTypeName();
        IMember member = BreakpointUtils.getMember((IJavaLineBreakpoint)watchpoint);
        StringBuffer label = new StringBuffer();
        label.append(this.getQualifiedName(typeName));
        this.appendHitCount((IJavaBreakpoint)watchpoint, label);
        this.appendSuspendPolicy((IJavaBreakpoint)watchpoint, label);
        this.appendThreadFilter((IJavaBreakpoint)watchpoint, label);
        boolean access = watchpoint.isAccess();
        boolean modification = watchpoint.isModification();
        if (access && modification) {
            label.append(DebugUIMessages.JDIModelPresentation_access_and_modification_70);
        } else if (access) {
            label.append(DebugUIMessages.JDIModelPresentation_access_71);
        } else if (modification) {
            label.append(DebugUIMessages.JDIModelPresentation_modification_72);
        }
        label.append(" - ");
        if (member != null) {
            label.append(this.getJavaLabelProvider().getText((Object)member));
        } else {
            label.append(watchpoint.getFieldName());
        }
        return label.toString();
    }

    protected String getMethodBreakpointText(IJavaMethodBreakpoint methodBreakpoint) throws CoreException {
        String typeName = methodBreakpoint.getTypeName();
        IMember member = BreakpointUtils.getMember((IJavaLineBreakpoint)methodBreakpoint);
        StringBuffer label = new StringBuffer();
        label.append(this.getQualifiedName(typeName));
        this.appendHitCount((IJavaBreakpoint)methodBreakpoint, label);
        this.appendSuspendPolicy((IJavaBreakpoint)methodBreakpoint, label);
        this.appendThreadFilter((IJavaBreakpoint)methodBreakpoint, label);
        boolean entry = methodBreakpoint.isEntry();
        boolean exit = methodBreakpoint.isExit();
        if (entry && exit) {
            label.append(DebugUIMessages.JDIModelPresentation_entry_and_exit);
        } else if (entry) {
            label.append(DebugUIMessages.JDIModelPresentation_entry);
        } else if (exit) {
            label.append(DebugUIMessages.JDIModelPresentation_exit);
        }
        this.appendConditional((IJavaLineBreakpoint)methodBreakpoint, label);
        if (member != null) {
            label.append(" - ");
            label.append(this.getJavaLabelProvider().getText((Object)member));
        } else {
            String methodSig = methodBreakpoint.getMethodSignature();
            String methodName = methodBreakpoint.getMethodName();
            if (methodSig != null) {
                label.append(" - ");
                label.append(Signature.toString((String)methodSig, (String)methodName, null, (boolean)false, (boolean)false));
            } else if (methodName != null) {
                label.append(" - ");
                label.append(methodName);
            }
        }
        return label.toString();
    }

    protected String getStackFrameText(IStackFrame stackFrame) throws DebugException {
        IJavaStackFrame frame;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((frame = (IJavaStackFrame)stackFrame.getAdapter((Class)clazz)) != null) {
            StringBuffer label;
            block30: {
                label = new StringBuffer();
                String dec = DebugUIMessages.JDIModelPresentation_unknown_declaring_type__4;
                try {
                    dec = frame.getDeclaringTypeName();
                }
                catch (DebugException debugException) {}
                if (frame.isObsolete()) {
                    label.append(DebugUIMessages.JDIModelPresentation__obsolete_method_in__1);
                    label.append(dec);
                    label.append('>');
                    return label.toString();
                }
                boolean javaStratum = true;
                try {
                    javaStratum = frame.getReferenceType().getDefaultStratum().equals("Java");
                }
                catch (DebugException debugException) {}
                if (javaStratum) {
                    String rec = DebugUIMessages.JDIModelPresentation_unknown_receiving_type__5;
                    try {
                        rec = frame.getReceivingTypeName();
                    }
                    catch (DebugException debugException) {}
                    label.append(this.getQualifiedName(rec));
                    if (!dec.equals(rec)) {
                        label.append('(');
                        label.append(this.getQualifiedName(dec));
                        label.append(')');
                    }
                    label.append('.');
                    try {
                        label.append(frame.getMethodName());
                    }
                    catch (DebugException debugException) {
                        label.append(DebugUIMessages.JDIModelPresentation_unknown_method_name__6);
                    }
                    try {
                        List args = frame.getArgumentTypeNames();
                        if (args.isEmpty()) {
                            label.append("()");
                            break block30;
                        }
                        label.append('(');
                        Iterator iter = args.iterator();
                        while (iter.hasNext()) {
                            label.append(this.getQualifiedName((String)iter.next()));
                            if (iter.hasNext()) {
                                label.append(", ");
                                continue;
                            }
                            if (!frame.isVarArgs()) continue;
                            label.replace(label.length() - 2, label.length(), "...");
                        }
                        label.append(')');
                    }
                    catch (DebugException debugException) {
                        label.append(DebugUIMessages.JDIModelPresentation__unknown_arguements___7);
                    }
                } else if (this.isShowQualifiedNames()) {
                    label.append(frame.getSourcePath());
                } else {
                    label.append(frame.getSourceName());
                }
            }
            try {
                int lineNumber = frame.getLineNumber();
                label.append(' ');
                label.append(DebugUIMessages.JDIModelPresentation_line__76);
                label.append(' ');
                if (lineNumber >= 0) {
                    label.append(lineNumber);
                } else {
                    label.append(DebugUIMessages.JDIModelPresentation_not_available);
                    if (frame.isNative()) {
                        label.append(' ');
                        label.append(DebugUIMessages.JDIModelPresentation_native_method);
                    }
                }
            }
            catch (DebugException debugException) {
                label.append(DebugUIMessages.JDIModelPresentation__unknown_line_number__8);
            }
            if (!frame.wereLocalsAvailable()) {
                label.append(' ');
                label.append(DebugUIMessages.JDIModelPresentation_local_variables_unavailable);
            }
            return label.toString();
        }
        return null;
    }

    protected String getQualifiedName(String qualifiedName) {
        if (!this.isShowQualifiedNames()) {
            return this.removeQualifierFromGenericName(qualifiedName);
        }
        return qualifiedName;
    }

    private String removeQualifierFromGenericName(String qualifiedName) {
        if (qualifiedName.endsWith("...")) {
            return String.valueOf(this.removeQualifierFromGenericName(qualifiedName.substring(0, qualifiedName.length() - 3))) + "...";
        }
        if (qualifiedName.endsWith("[]")) {
            return String.valueOf(this.removeQualifierFromGenericName(qualifiedName.substring(0, qualifiedName.length() - 2))) + "[]";
        }
        int parameterStart = qualifiedName.indexOf(60);
        if (parameterStart == -1) {
            return this.getSimpleName(qualifiedName);
        }
        List parameters = this.getNameList(qualifiedName.substring(parameterStart + 1, qualifiedName.length() - 1));
        StringBuffer name = new StringBuffer(this.getSimpleName(qualifiedName.substring(0, parameterStart)));
        name.append('<');
        Iterator iterator = parameters.iterator();
        if (iterator.hasNext()) {
            name.append(this.removeQualifierFromGenericName((String)iterator.next()));
            while (iterator.hasNext()) {
                name.append(',').append(this.removeQualifierFromGenericName((String)iterator.next()));
            }
        }
        name.append('>');
        return name.toString();
    }

    private String getSimpleName(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(46);
        if (index >= 0) {
            return qualifiedName.substring(index + 1);
        }
        return qualifiedName;
    }

    private List getNameList(String listName) {
        ArrayList<String> names = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(listName, ",<>", true);
        int enclosingLevel = 0;
        int startPos = 0;
        int currentPos = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (token.charAt(0)) {
                case ',': {
                    if (enclosingLevel != 0) break;
                    names.add(listName.substring(startPos, currentPos));
                    startPos = currentPos + 1;
                    break;
                }
                case '<': {
                    ++enclosingLevel;
                    break;
                }
                case '>': {
                    --enclosingLevel;
                }
            }
            currentPos += token.length();
        }
        names.add(listName.substring(startPos));
        return names;
    }

    public static String getFormattedString(String key, String arg) {
        return JDIModelPresentation.getFormattedString(key, new String[]{arg});
    }

    public static String getFormattedString(String string, String[] args) {
        return MessageFormat.format(string, args);
    }

    protected void appendSuspendPolicy(IJavaBreakpoint breakpoint, StringBuffer buffer) throws CoreException {
        if (breakpoint.getSuspendPolicy() == 1) {
            buffer.append(' ');
            buffer.append(DebugUIMessages.JDIModelPresentation_Suspend_VM);
        }
    }

    protected void appendThreadFilter(IJavaBreakpoint breakpoint, StringBuffer buffer) throws CoreException {
        if (breakpoint.getThreadFilters().length != 0) {
            buffer.append(' ');
            buffer.append(DebugUIMessages.JDIModelPresentation_thread_filtered);
        }
    }

    protected void appendConditional(IJavaLineBreakpoint breakpoint, StringBuffer buffer) throws CoreException {
        if (breakpoint.isConditionEnabled() && breakpoint.getCondition() != null) {
            buffer.append(' ');
            buffer.append(DebugUIMessages.JDIModelPresentation__conditional__2);
        }
    }

    protected void appendInstanceFilter(IJavaBreakpoint breakpoint, StringBuffer buffer) throws CoreException {
        IJavaObject[] instances = breakpoint.getInstanceFilters();
        int i = 0;
        while (i < instances.length) {
            String instanceText = instances[i].getValueString();
            if (instanceText != null) {
                buffer.append(' ');
                buffer.append(MessageFormat.format(DebugUIMessages.JDIModelPresentation_instance_1, instanceText));
            }
            ++i;
        }
    }

    protected org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry getJavaElementImageRegistry() {
        if (this.fJavaElementImageRegistry == null) {
            this.fJavaElementImageRegistry = JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fJavaElementImageRegistry;
    }

    protected ImageDescriptorRegistry getDebugImageRegistry() {
        if (this.fDebugImageRegistry == null) {
            this.fDebugImageRegistry = JDIDebugUIPlugin.getImageDescriptorRegistry();
        }
        return this.fDebugImageRegistry;
    }

    protected JavaElementLabelProvider getJavaLabelProvider() {
        if (this.fJavaLabelProvider == null) {
            this.fJavaLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        }
        return this.fJavaLabelProvider;
    }

    protected boolean isDuplicateName(IJavaFieldVariable variable) {
        IJavaReferenceType javaType = variable.getReceivingType();
        try {
            String[] names = javaType.getAllFieldNames();
            boolean found = false;
            int i = 0;
            while (i < names.length) {
                if (variable.getName().equals(names[i])) {
                    if (found) {
                        return true;
                    }
                    found = true;
                }
                ++i;
            }
            return false;
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public Color getForeground(Object element) {
        if (element instanceof JavaContendedMonitor && ((JavaContendedMonitor)((Object)element)).getMonitor().isInDeadlock()) {
            return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("org.eclipse.jdt.debug.ui.InDeadlockColor");
        }
        if (element instanceof JavaOwnedMonitor && ((JavaOwnedMonitor)((Object)element)).getMonitor().isInDeadlock()) {
            return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("org.eclipse.jdt.debug.ui.InDeadlockColor");
        }
        if (element instanceof JavaWaitingThread && ((JavaWaitingThread)element).getThread().isInDeadlock()) {
            return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("org.eclipse.jdt.debug.ui.InDeadlockColor");
        }
        if (element instanceof JavaOwningThread && ((JavaOwningThread)((Object)element)).getThread().isInDeadlock()) {
            return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("org.eclipse.jdt.debug.ui.InDeadlockColor");
        }
        if (element instanceof IJavaThread && ThreadMonitorManager.getDefault().isInDeadlock((IThread)((IJavaThread)element))) {
            return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("org.eclipse.jdt.debug.ui.InDeadlockColor");
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    private ImageDescriptor getImageDescriptor(String key) {
        return JavaDebugImages.getImageDescriptor(key);
    }

    static interface IValueDetailProvider {
        public void computeDetail(IValue var1, IJavaThread var2, IValueDetailListener var3) throws DebugException;
    }
}

