/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class UntitledTextFileWizard
extends Wizard
implements INewWizard {
    private IWorkbenchWindow fWindow;

    public void dispose() {
        this.fWindow = null;
    }

    private File queryFile() {
        IPath stateLocation = EditorsPlugin.getDefault().getStateLocation();
        IPath path = stateLocation.append("/_" + new Object().hashCode());
        return new File(path.toOSString());
    }

    private String getEditorId(File file) {
        IWorkbench workbench = this.fWindow.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    private IEditorInput createEditorInput(File file) {
        return new NonExistingFileEditorInput(file, TextEditorMessages.NewTextEditorAction_namePrefix);
    }

    public boolean performFinish() {
        File file = this.queryFile();
        IEditorInput input = this.createEditorInput(file);
        String editorId = this.getEditorId(file);
        IWorkbenchPage page = this.fWindow.getActivePage();
        try {
            page.openEditor(input, editorId);
        }
        catch (PartInitException e) {
            EditorsPlugin.log(e);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWindow = workbench.getActiveWorkbenchWindow();
    }
}

