/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameCompilationUnitProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameEnumConstProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameJavaProjectProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameLocalVariableProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameNonVirtualMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenamePackageProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameSourceFolderProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeParameterProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameVirtualMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameUserInterfaceManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.swt.widgets.Shell;

public class RenameSupport {
    private RenameRefactoring fRefactoring;
    private RefactoringStatus fPreCheckStatus;
    public static final int NONE = 0;
    public static final int UPDATE_REFERENCES = 1;
    public static final int UPDATE_JAVADOC_COMMENTS = 2;
    public static final int UPDATE_REGULAR_COMMENTS = 4;
    public static final int UPDATE_STRING_LITERALS = 8;
    public static final int UPDATE_TEXTUAL_MATCHES = 64;
    public static final int UPDATE_GETTER_METHOD = 16;
    public static final int UPDATE_SETTER_METHOD = 32;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public IStatus preCheck() throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            return RenameSupport.asStatus(this.fPreCheckStatus.getEntryMatchingSeverity(4));
        }
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    public void openDialog(Shell parent) throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            this.showInformation(parent, this.fPreCheckStatus);
            return;
        }
        UserInterfaceStarter starter = RenameUserInterfaceManager.getDefault().getStarter((Refactoring)this.fRefactoring);
        starter.activate((Refactoring)this.fRefactoring, parent, this.getJavaRenameProcessor().needsSavedEditors());
    }

    public void perform(Shell parent, IRunnableContext context) throws InterruptedException, InvocationTargetException {
        try {
            this.ensureChecked();
            if (this.fPreCheckStatus.hasFatalError()) {
                this.showInformation(parent, this.fPreCheckStatus);
                return;
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        RefactoringExecutionHelper helper = new RefactoringExecutionHelper((Refactoring)this.fRefactoring, RefactoringCore.getConditionCheckingFailedSeverity(), this.getJavaRenameProcessor().needsSavedEditors(), parent, context);
        helper.perform();
    }

    private RenameSupport(JavaRenameProcessor processor, String newName, int flags) throws CoreException {
        this.fRefactoring = new RenameRefactoring((RenameProcessor)processor);
        RenameSupport.initialize(this.fRefactoring, newName, flags);
    }

    private JavaRenameProcessor getJavaRenameProcessor() {
        return (JavaRenameProcessor)this.fRefactoring.getProcessor();
    }

    public static RenameSupport create(IJavaProject project, String newName, int flags) throws CoreException {
        RenameJavaProjectProcessor processor = new RenameJavaProjectProcessor(project);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(IPackageFragmentRoot root, String newName) throws CoreException {
        RenameSourceFolderProcessor processor = new RenameSourceFolderProcessor(root);
        return new RenameSupport(processor, newName, 0);
    }

    public static RenameSupport create(IPackageFragment fragment, String newName, int flags) throws CoreException {
        RenamePackageProcessor processor = new RenamePackageProcessor(fragment);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(ICompilationUnit unit, String newName, int flags) throws CoreException {
        RenameCompilationUnitProcessor processor = new RenameCompilationUnitProcessor(unit);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(IType type, String newName, int flags) throws CoreException {
        RenameTypeProcessor processor = new RenameTypeProcessor(type);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(IMethod method, String newName, int flags) throws CoreException {
        RenameMethodProcessor processor = MethodChecks.isVirtual(method) ? new RenameVirtualMethodProcessor(method) : new RenameNonVirtualMethodProcessor(method);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(IField field, String newName, int flags) throws CoreException {
        if (JdtFlags.isEnum((IMember)field)) {
            return new RenameSupport(new RenameEnumConstProcessor(field), newName, flags);
        }
        RenameFieldProcessor processor = new RenameFieldProcessor(field);
        processor.setRenameGetter(RenameSupport.updateGetterMethod(flags));
        processor.setRenameSetter(RenameSupport.updateSetterMethod(flags));
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(ITypeParameter parameter, String newName, int flags) throws CoreException {
        RenameTypeParameterProcessor processor = new RenameTypeParameterProcessor(parameter);
        processor.setUpdateReferences(RenameSupport.updateReferences(flags));
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(ILocalVariable variable, String newName, int flags) throws CoreException {
        RenameLocalVariableProcessor processor = new RenameLocalVariableProcessor(variable);
        processor.setUpdateReferences(RenameSupport.updateReferences(flags));
        return new RenameSupport(processor, newName, flags);
    }

    private static void initialize(RenameRefactoring refactoring, String newName, int flags) {
        ITextUpdating text;
        Class<?> clazz;
        IReferenceUpdating reference;
        if (refactoring.getProcessor() == null) {
            return;
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RenameSupport.setNewName((INameUpdating)refactoring.getAdapter((Class)clazz2), newName);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reference = (IReferenceUpdating)refactoring.getAdapter((Class)clazz3)) != null) {
            reference.setUpdateReferences(RenameSupport.updateReferences(flags));
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((text = (ITextUpdating)refactoring.getAdapter((Class)clazz)) != null) {
            text.setUpdateTextualMatches(RenameSupport.updateTextualMatches(flags));
        }
    }

    private static void setNewName(INameUpdating refactoring, String newName) {
        if (newName != null) {
            refactoring.setNewElementName(newName);
        }
    }

    private static boolean updateReferences(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean updateTextualMatches(int flags) {
        int TEXT_UPDATES = 76;
        return (flags & TEXT_UPDATES) != 0;
    }

    private static boolean updateGetterMethod(int flags) {
        return (flags & 0x10) != 0;
    }

    private static boolean updateSetterMethod(int flags) {
        return (flags & 0x20) != 0;
    }

    private void ensureChecked() throws CoreException {
        if (this.fPreCheckStatus == null) {
            this.fPreCheckStatus = !this.fRefactoring.isApplicable() ? RefactoringStatus.createFatalErrorStatus((String)JavaUIMessages.RenameSupport_not_available) : new RefactoringStatus();
        }
    }

    private void showInformation(Shell parent, RefactoringStatus status) {
        String message = status.getMessageMatchingSeverity(4);
        MessageDialog.openInformation((Shell)parent, (String)JavaUIMessages.RenameSupport_dialog_title, (String)message);
    }

    private static IStatus asStatus(RefactoringStatusEntry entry) {
        int statusSeverity = 4;
        switch (entry.getSeverity()) {
            case 0: {
                statusSeverity = 0;
                break;
            }
            case 1: {
                statusSeverity = 1;
                break;
            }
            case 2: 
            case 3: {
                statusSeverity = 2;
            }
        }
        String pluginId = entry.getPluginId();
        int code = entry.getCode();
        if (pluginId == null) {
            pluginId = JavaPlugin.getPluginId();
            code = 4;
        }
        return new Status(statusSeverity, pluginId, code, entry.getMessage(), null);
    }
}

