/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.internal.ui.callhierarchy.OpenCallHierarchyAction;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.actions.OpenExternalJavadocAction;
import org.eclipse.jdt.ui.actions.OpenSuperImplementationAction;
import org.eclipse.jdt.ui.actions.OpenTypeHierarchyAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.Page;

public class OpenViewActionGroup
extends ActionGroup {
    private boolean fEditorIsOwner;
    private boolean fIsTypeHiararchyViewerOwner;
    private boolean fIsCallHiararchyViewerOwner;
    private IWorkbenchSite fSite;
    private OpenSuperImplementationAction fOpenSuperImplementation;
    private OpenExternalJavadocAction fOpenExternalJavadoc;
    private OpenTypeHierarchyAction fOpenTypeHierarchy;
    private OpenCallHierarchyAction fOpenCallHierarchy;
    private PropertyDialogAction fOpenPropertiesDialog;

    public OpenViewActionGroup(Page page) {
        this.createSiteActions((IWorkbenchSite)page.getSite());
    }

    public OpenViewActionGroup(IViewPart part) {
        this.createSiteActions((IWorkbenchSite)part.getSite());
    }

    public OpenViewActionGroup(JavaEditor part) {
        this.fEditorIsOwner = true;
        this.fOpenSuperImplementation = new OpenSuperImplementationAction(part);
        this.fOpenSuperImplementation.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.super.implementation");
        part.setAction("OpenSuperImplementation", (IAction)this.fOpenSuperImplementation);
        this.fOpenExternalJavadoc = new OpenExternalJavadocAction(part);
        this.fOpenExternalJavadoc.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.external.javadoc");
        part.setAction("OpenExternalJavadoc", (IAction)this.fOpenExternalJavadoc);
        this.fOpenTypeHierarchy = new OpenTypeHierarchyAction(part);
        this.fOpenTypeHierarchy.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.type.hierarchy");
        part.setAction("OpenTypeHierarchy", (IAction)this.fOpenTypeHierarchy);
        this.fOpenCallHierarchy = new OpenCallHierarchyAction(part);
        this.fOpenCallHierarchy.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.call.hierarchy");
        part.setAction("OpenCallHierarchy", (IAction)this.fOpenCallHierarchy);
        this.initialize((IWorkbenchSite)part.getEditorSite());
    }

    private void createSiteActions(IWorkbenchSite site) {
        this.fOpenSuperImplementation = new OpenSuperImplementationAction(site);
        this.fOpenSuperImplementation.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.super.implementation");
        this.fOpenExternalJavadoc = new OpenExternalJavadocAction(site);
        this.fOpenExternalJavadoc.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.external.javadoc");
        this.fOpenTypeHierarchy = new OpenTypeHierarchyAction(site);
        this.fOpenTypeHierarchy.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.type.hierarchy");
        this.fOpenCallHierarchy = new OpenCallHierarchyAction(site);
        this.fOpenCallHierarchy.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.call.hierarchy");
        this.fOpenPropertiesDialog = new PropertyDialogAction((IShellProvider)site, site.getSelectionProvider());
        this.fOpenPropertiesDialog.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.initialize(site);
    }

    private void initialize(IWorkbenchSite site) {
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fOpenSuperImplementation.update(selection);
        this.fOpenExternalJavadoc.update(selection);
        this.fOpenTypeHierarchy.update(selection);
        this.fOpenCallHierarchy.update(selection);
        if (!this.fEditorIsOwner) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                this.fOpenPropertiesDialog.selectionChanged(ss);
            } else {
                this.fOpenPropertiesDialog.selectionChanged(selection);
            }
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenSuperImplementation);
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenExternalJavadoc);
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenTypeHierarchy);
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenCallHierarchy);
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (!this.fIsTypeHiararchyViewerOwner) {
            this.appendToGroup(menu, (IAction)this.fOpenTypeHierarchy);
        }
        if (!this.fIsCallHiararchyViewerOwner) {
            this.appendToGroup(menu, (IAction)this.fOpenCallHierarchy);
        }
        this.appendToGroup(menu, (IAction)this.fOpenSuperImplementation);
        IStructuredSelection selection = this.getStructuredSelection();
        if (this.fOpenPropertiesDialog != null && this.fOpenPropertiesDialog.isEnabled() && selection != null && this.fOpenPropertiesDialog.isApplicableForSelection(selection)) {
            menu.appendToGroup("group.properties", (IAction)this.fOpenPropertiesDialog);
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenSuperImplementation);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenExternalJavadoc);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenTypeHierarchy);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenCallHierarchy);
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.OpenSuperImplementation", (IAction)this.fOpenSuperImplementation);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.OpenExternalJavaDoc", (IAction)this.fOpenExternalJavadoc);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.OpenTypeHierarchy", (IAction)this.fOpenTypeHierarchy);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.OpenCallHierarchy", (IAction)this.fOpenCallHierarchy);
        if (!this.fEditorIsOwner) {
            actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fOpenPropertiesDialog);
        }
    }

    private void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.open", action);
        }
    }

    private IStructuredSelection getStructuredSelection() {
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }
}

