/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.DeclarationsSearchGroup;
import org.eclipse.jdt.ui.actions.ImplementorsSearchGroup;
import org.eclipse.jdt.ui.actions.OccurrencesSearchGroup;
import org.eclipse.jdt.ui.actions.ReadReferencesSearchGroup;
import org.eclipse.jdt.ui.actions.ReferencesSearchGroup;
import org.eclipse.jdt.ui.actions.WriteReferencesSearchGroup;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class JavaSearchActionGroup
extends ActionGroup {
    private JavaEditor fEditor;
    private ReferencesSearchGroup fReferencesGroup;
    private ReadReferencesSearchGroup fReadAccessGroup;
    private WriteReferencesSearchGroup fWriteAccessGroup;
    private DeclarationsSearchGroup fDeclarationsGroup;
    private ImplementorsSearchGroup fImplementorsGroup;
    private OccurrencesSearchGroup fOccurrencesGroup;

    public JavaSearchActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getViewSite());
    }

    public JavaSearchActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public JavaSearchActionGroup(JavaEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fReferencesGroup = new ReferencesSearchGroup(this.fEditor);
        this.fReadAccessGroup = new ReadReferencesSearchGroup(this.fEditor);
        this.fWriteAccessGroup = new WriteReferencesSearchGroup(this.fEditor);
        this.fDeclarationsGroup = new DeclarationsSearchGroup(this.fEditor);
        this.fImplementorsGroup = new ImplementorsSearchGroup(this.fEditor);
        this.fOccurrencesGroup = new OccurrencesSearchGroup(this.fEditor);
    }

    private JavaSearchActionGroup(IWorkbenchSite site) {
        this.fReferencesGroup = new ReferencesSearchGroup(site);
        this.fReadAccessGroup = new ReadReferencesSearchGroup(site);
        this.fWriteAccessGroup = new WriteReferencesSearchGroup(site);
        this.fDeclarationsGroup = new DeclarationsSearchGroup(site);
        this.fImplementorsGroup = new ImplementorsSearchGroup(site);
        this.fOccurrencesGroup = new OccurrencesSearchGroup(site);
    }

    public void setContext(ActionContext context) {
        this.fReferencesGroup.setContext(context);
        this.fDeclarationsGroup.setContext(context);
        this.fImplementorsGroup.setContext(context);
        this.fReadAccessGroup.setContext(context);
        this.fWriteAccessGroup.setContext(context);
        this.fOccurrencesGroup.setContext(context);
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.fReferencesGroup.fillActionBars(actionBar);
        this.fDeclarationsGroup.fillActionBars(actionBar);
        this.fImplementorsGroup.fillActionBars(actionBar);
        this.fReadAccessGroup.fillActionBars(actionBar);
        this.fWriteAccessGroup.fillActionBars(actionBar);
        this.fOccurrencesGroup.fillActionBars(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (PreferenceConstants.getPreferenceStore().getBoolean("Search.usereducemenu")) {
            this.fReferencesGroup.fillContextMenu(menu);
            this.fDeclarationsGroup.fillContextMenu(menu);
            if (this.fEditor == null) {
                this.fImplementorsGroup.fillContextMenu(menu);
                this.fReadAccessGroup.fillContextMenu(menu);
                this.fWriteAccessGroup.fillContextMenu(menu);
            }
            this.fOccurrencesGroup.fillContextMenu(menu);
        } else {
            IMenuManager target = menu;
            MenuManager searchSubMenu = null;
            if (this.fEditor != null) {
                String groupName = SearchMessages.group_search;
                searchSubMenu = new MenuManager(groupName, "group.find");
                searchSubMenu.add((IContributionItem)new GroupMarker("group.find"));
                target = searchSubMenu;
            }
            this.fReferencesGroup.fillContextMenu(target);
            this.fDeclarationsGroup.fillContextMenu(target);
            this.fImplementorsGroup.fillContextMenu(target);
            this.fReadAccessGroup.fillContextMenu(target);
            this.fWriteAccessGroup.fillContextMenu(target);
            this.fOccurrencesGroup.fillContextMenu(target);
            if (searchSubMenu != null) {
                searchSubMenu.add((IContributionItem)new Separator());
            }
            if (searchSubMenu != null && searchSubMenu.getItems().length > 2) {
                menu.appendToGroup("group.find", (IContributionItem)searchSubMenu);
            }
        }
    }

    public void dispose() {
        this.fReferencesGroup.dispose();
        this.fDeclarationsGroup.dispose();
        this.fImplementorsGroup.dispose();
        this.fReadAccessGroup.dispose();
        this.fWriteAccessGroup.dispose();
        this.fOccurrencesGroup.dispose();
        super.dispose();
    }
}

