/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ExclusionInclusionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.MultipleFolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.NewSourceFolderDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.OutputLocationDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SourceContainerWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fClassPathList;
    private IJavaProject fCurrJProject;
    private IPath fProjPath;
    private Control fSWTControl;
    private IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private TreeListDialogField fFoldersList;
    private StringDialogField fOutputLocationField;
    private SelectionButtonDialogField fUseFolderOutputs;
    private final int IDX_ADD = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SourceContainerWorkbookPage(ListDialogField classPathList, StringDialogField outputLocationField) {
        this.fClassPathList = classPathList;
        this.fOutputLocationField = outputLocationField;
        this.fSWTControl = null;
        SourceContainerAdapter adapter = new SourceContainerAdapter();
        String[] stringArray = new String[4];
        stringArray[0] = NewWizardMessages.SourceContainerWorkbookPage_folders_add_button;
        stringArray[2] = NewWizardMessages.SourceContainerWorkbookPage_folders_edit_button;
        stringArray[3] = NewWizardMessages.SourceContainerWorkbookPage_folders_remove_button;
        String[] buttonLabels = stringArray;
        this.fFoldersList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fFoldersList.setDialogFieldListener(adapter);
        this.fFoldersList.setLabelText(NewWizardMessages.SourceContainerWorkbookPage_folders_label);
        this.fFoldersList.setViewerSorter(new CPListElementSorter());
        this.fFoldersList.enableButton(2, false);
        this.fUseFolderOutputs = new SelectionButtonDialogField(32);
        this.fUseFolderOutputs.setSelection(false);
        this.fUseFolderOutputs.setLabelText(NewWizardMessages.SourceContainerWorkbookPage_folders_check);
        this.fUseFolderOutputs.setDialogFieldListener(adapter);
    }

    public void init(IJavaProject jproject) {
        this.fCurrJProject = jproject;
        this.fProjPath = this.fCurrJProject.getProject().getFullPath();
        this.updateFoldersList();
    }

    private void updateFoldersList() {
        CPListElement cpe;
        ArrayList<CPListElement> folders = new ArrayList<CPListElement>();
        boolean useFolderOutputs = false;
        List cpelements = this.fClassPathList.getElements();
        int i = 0;
        while (i < cpelements.size()) {
            cpe = (CPListElement)cpelements.get(i);
            if (cpe.getEntryKind() == 3) {
                boolean hasOutputFolder;
                folders.add(cpe);
                boolean bl = hasOutputFolder = cpe.getAttribute("output") != null;
                if (hasOutputFolder) {
                    useFolderOutputs = true;
                }
            }
            ++i;
        }
        this.fFoldersList.setElements(folders);
        this.fUseFolderOutputs.setSelection(useFolderOutputs);
        i = 0;
        while (i < folders.size()) {
            boolean hasOutputFolder;
            cpe = (CPListElement)folders.get(i);
            IPath[] patterns = (IPath[])cpe.getAttribute("exclusion");
            boolean bl = hasOutputFolder = cpe.getAttribute("output") != null;
            if (patterns.length > 0 || hasOutputFolder) {
                this.fFoldersList.expandElement(cpe, 3);
            }
            ++i;
        }
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fFoldersList, this.fUseFolderOutputs}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fFoldersList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fFoldersList.setButtonsMinWidth(buttonBarWidth);
        this.fSWTControl = composite;
        List elements = this.fFoldersList.getElements();
        int i = 0;
        while (i < elements.size()) {
            CPListElement elem = (CPListElement)elements.get(i);
            IPath[] exclusionPatterns = (IPath[])elem.getAttribute("exclusion");
            IPath[] inclusionPatterns = (IPath[])elem.getAttribute("inclusion");
            IPath output = (IPath)elem.getAttribute("output");
            if (exclusionPatterns.length > 0 || inclusionPatterns.length > 0 || output != null) {
                this.fFoldersList.expandElement(elem, 3);
            }
            ++i;
        }
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    protected void sourcePageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fFoldersList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected void sourcePageDoubleClicked(TreeListDialogField field) {
        List selection;
        if (field == this.fFoldersList && this.canEdit(selection = field.getSelectedElements())) {
            this.editEntry();
        }
    }

    private boolean hasFolders(IContainer container) {
        try {
            IResource[] members = container.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IContainer) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void sourcePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fFoldersList) {
            if (index == 0) {
                CPListElement entry;
                ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(10);
                IProject project = this.fCurrJProject.getProject();
                if (project.exists()) {
                    if (this.hasFolders((IContainer)project)) {
                        CPListElement[] srcentries = this.openSourceContainerDialog(null);
                        if (srcentries != null) {
                            int i = 0;
                            while (i < srcentries.length) {
                                elementsToAdd.add(srcentries[i]);
                                ++i;
                            }
                        }
                    } else {
                        entry = this.openNewSourceContainerDialog(null, true);
                        if (entry != null) {
                            elementsToAdd.add(entry);
                        }
                    }
                } else {
                    entry = this.openNewSourceContainerDialog(null, false);
                    if (entry != null) {
                        elementsToAdd.add(entry);
                    }
                }
                if (!elementsToAdd.isEmpty()) {
                    CPListElement existing;
                    if (this.fFoldersList.getSize() == 1 && (existing = (CPListElement)this.fFoldersList.getElement(0)).getResource() instanceof IProject) {
                        this.askForChangingBuildPathDialog(existing);
                    }
                    HashSet modifiedElements = new HashSet();
                    this.askForAddingExclusionPatternsDialog(elementsToAdd, modifiedElements);
                    this.fFoldersList.addElements(elementsToAdd);
                    this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(elementsToAdd));
                    if (!modifiedElements.isEmpty()) {
                        Iterator iter = modifiedElements.iterator();
                        while (iter.hasNext()) {
                            Object elem = iter.next();
                            this.fFoldersList.refresh(elem);
                            this.fFoldersList.expandElement(elem, 3);
                        }
                    }
                }
            } else if (index == 2) {
                this.editEntry();
            } else if (index == 3) {
                this.removeEntry();
            }
        }
    }

    private void editEntry() {
        List selElements = this.fFoldersList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fFoldersList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPListElement)elem);
        } else if (elem instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)elem);
        }
    }

    private void editElementEntry(CPListElement elem) {
        CPListElement res = null;
        res = this.openNewSourceContainerDialog(elem, true);
        if (res != null) {
            this.fFoldersList.replaceElement(elem, res);
        }
    }

    private void editAttributeEntry(CPListElementAttribute elem) {
        String key = elem.getKey();
        if (key.equals("output")) {
            CPListElement selElement = elem.getParent();
            OutputLocationDialog dialog = new OutputLocationDialog(this.getShell(), selElement, this.fClassPathList.getElements());
            if (dialog.open() == 0) {
                selElement.setAttribute("output", dialog.getOutputLocation());
                this.fFoldersList.refresh();
                this.fClassPathList.dialogFieldChanged();
            }
        } else if (key.equals("exclusion")) {
            this.showExclusionInclusionDialog(elem.getParent(), true);
        } else if (key.equals("inclusion")) {
            this.showExclusionInclusionDialog(elem.getParent(), false);
        }
    }

    private void showExclusionInclusionDialog(CPListElement selElement, boolean focusOnExclusion) {
        ExclusionInclusionDialog dialog = new ExclusionInclusionDialog(this.getShell(), selElement, focusOnExclusion);
        if (dialog.open() == 0) {
            selElement.setAttribute("inclusion", dialog.getInclusionPattern());
            selElement.setAttribute("exclusion", dialog.getExclusionPattern());
            this.fFoldersList.refresh();
            this.fClassPathList.dialogFieldChanged();
        }
    }

    protected void sourcePageSelectionChanged(DialogField field) {
        List selected = this.fFoldersList.getSelectedElements();
        this.fFoldersList.enableButton(2, this.canEdit(selected));
        this.fFoldersList.enableButton(3, this.canRemove(selected));
        boolean noAttributes = this.containsOnlyTopLevelEntries(selected);
        this.fFoldersList.enableButton(0, noAttributes);
    }

    private void removeEntry() {
        List selElements = this.fFoldersList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                String key = attrib.getKey();
                Path[] value = null;
                if (key.equals("exclusion") || key.equals("inclusion")) {
                    value = new Path[]{};
                }
                attrib.getParent().setAttribute(key, value);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fFoldersList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            this.fFoldersList.removeElements(selElements);
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            CPListElement curr;
            CPListElementAttribute attrib;
            String key;
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute ? ("inclusion".equals(key = (attrib = (CPListElementAttribute)elem).getKey()) ? ((IPath[])attrib.getValue()).length == 0 : ("exclusion".equals(key) ? ((IPath[])attrib.getValue()).length == 0 : attrib.getValue() == null)) : elem instanceof CPListElement && (curr = (CPListElement)elem).getParentContainer() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPListElement) {
            return false;
        }
        return elem instanceof CPListElementAttribute;
    }

    private void sourcePageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject == null) {
            return;
        }
        if (field == this.fUseFolderOutputs) {
            if (!this.fUseFolderOutputs.isSelected()) {
                int nFolders = this.fFoldersList.getSize();
                int i = 0;
                while (i < nFolders) {
                    CPListElement cpe = (CPListElement)this.fFoldersList.getElement(i);
                    cpe.setAttribute("output", null);
                    ++i;
                }
            }
            this.fFoldersList.refresh();
        } else if (field == this.fFoldersList) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        int nEntries;
        List srcelements = this.fFoldersList.getElements();
        List cpelements = this.fClassPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int afterLastSourcePos = 0;
        int i = nEntries - 1;
        while (i >= 0) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind)) {
                if (!srcelements.remove(cpe)) {
                    cpelements.remove(i);
                    lastRemovePos = i;
                } else if (lastRemovePos == nEntries) {
                    afterLastSourcePos = i + 1;
                }
            }
            --i;
        }
        if (!srcelements.isEmpty()) {
            int insertPos = Math.min(afterLastSourcePos, lastRemovePos);
            cpelements.addAll(insertPos, srcelements);
        }
        if (lastRemovePos != nEntries || !srcelements.isEmpty()) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    private CPListElement openNewSourceContainerDialog(CPListElement existing, boolean includeLinked) {
        if (includeLinked) {
            NewFolderDialog dialog = new NewFolderDialog(this.getShell(), (IContainer)this.fCurrJProject.getProject());
            dialog.setTitle(NewWizardMessages.SourceContainerWorkbookPage_NewSourceFolderDialog_new_title);
            if (dialog.open() == 0) {
                IResource createdFolder = (IResource)dialog.getResult()[0];
                return this.newCPSourceElement(createdFolder);
            }
            return null;
        }
        String title = existing == null ? NewWizardMessages.SourceContainerWorkbookPage_NewSourceFolderDialog_new_title : NewWizardMessages.SourceContainerWorkbookPage_NewSourceFolderDialog_edit_title;
        IProject proj = this.fCurrJProject.getProject();
        NewSourceFolderDialog dialog = new NewSourceFolderDialog(this.getShell(), title, proj, this.getExistingContainers(existing), existing);
        dialog.setMessage(Messages.format(NewWizardMessages.SourceContainerWorkbookPage_NewSourceFolderDialog_description, this.fProjPath.toString()));
        if (dialog.open() == 0) {
            IContainer folder = dialog.getSourceFolder();
            return this.newCPSourceElement((IResource)folder);
        }
        return null;
    }

    private void askForChangingBuildPathDialog(CPListElement existing) {
        String message;
        Path outputFolder = new Path(this.fOutputLocationField.getText());
        IPath newOutputFolder = null;
        if (outputFolder.segmentCount() == 1) {
            String outputFolderName = PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
            newOutputFolder = outputFolder.append(outputFolderName);
            message = Messages.format(NewWizardMessages.SourceContainerWorkbookPage_ChangeOutputLocationDialog_project_and_output_message, newOutputFolder);
        } else {
            message = NewWizardMessages.SourceContainerWorkbookPage_ChangeOutputLocationDialog_project_message;
        }
        String title = NewWizardMessages.SourceContainerWorkbookPage_ChangeOutputLocationDialog_title;
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message)) {
            this.fFoldersList.removeElement(existing);
            if (newOutputFolder != null) {
                this.fOutputLocationField.setText(newOutputFolder.toString());
            }
        }
    }

    private void askForAddingExclusionPatternsDialog(List newEntries, Set modifiedEntries) {
        SourceContainerWorkbookPage.fixNestingConflicts(newEntries, this.fFoldersList.getElements(), modifiedEntries);
        if (!modifiedEntries.isEmpty()) {
            String title = NewWizardMessages.SourceContainerWorkbookPage_exclusion_added_title;
            String message = NewWizardMessages.SourceContainerWorkbookPage_exclusion_added_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private CPListElement[] openSourceContainerDialog(CPListElement existing) {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] acceptedClasses = classArray;
        List existingContainers = this.getExistingContainers(null);
        IProject[] allProjects = this.fWorkspaceRoot.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject currProject = this.fCurrJProject.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)currProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        BaseWorkbenchContentProvider cp = new BaseWorkbenchContentProvider();
        String title = existing == null ? NewWizardMessages.SourceContainerWorkbookPage_ExistingSourceFolderDialog_new_title : NewWizardMessages.SourceContainerWorkbookPage_ExistingSourceFolderDialog_edit_title;
        String message = existing == null ? NewWizardMessages.SourceContainerWorkbookPage_ExistingSourceFolderDialog_new_description : NewWizardMessages.SourceContainerWorkbookPage_ExistingSourceFolderDialog_edit_description;
        MultipleFolderSelectionDialog dialog = new MultipleFolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setExisting(existingContainers.toArray());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter(filter);
        dialog.setInput(this.fCurrJProject.getProject().getParent());
        if (existing == null) {
            dialog.setInitialFocus(this.fCurrJProject.getProject());
        } else {
            dialog.setInitialFocus(existing.getResource());
        }
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            CPListElement[] res = new CPListElement[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = this.newCPSourceElement(elem);
                ++i2;
            }
            return res;
        }
        return null;
    }

    private List getExistingContainers(CPListElement existing) {
        ArrayList<IResource> res = new ArrayList<IResource>();
        List cplist = this.fFoldersList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem != existing && (resource = elem.getResource()) instanceof IContainer) {
                res.add(resource);
            }
            ++i;
        }
        return res;
    }

    private CPListElement newCPSourceElement(IResource res) {
        Assert.isNotNull((Object)res);
        return new CPListElement(this.fCurrJProject, 3, res.getFullPath(), res);
    }

    public List getSelection() {
        return this.fFoldersList.getSelectedElements();
    }

    public void setSelection(List selElements, boolean expand) {
        this.fFoldersList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fFoldersList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    public boolean isEntryKind(int kind) {
        return kind == 3;
    }

    private class SourceContainerAdapter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] EMPTY_ARR = new Object[0];

        SourceContainerAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            SourceContainerWorkbookPage.this.sourcePageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            SourceContainerWorkbookPage.this.sourcePageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            SourceContainerWorkbookPage.this.sourcePageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            SourceContainerWorkbookPage.this.sourcePageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren(!SourceContainerWorkbookPage.this.fUseFolderOutputs.isSelected());
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return element instanceof CPListElement;
        }

        public void dialogFieldChanged(DialogField field) {
            SourceContainerWorkbookPage.this.sourcePageDialogFieldChanged(field);
        }
    }
}

