/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;

public class CPListElementAttribute {
    private CPListElement fParent;
    private String fKey;
    private Object fValue;
    private final boolean fBuiltIn;

    public CPListElementAttribute(CPListElement parent, String key, Object value, boolean builtIn) {
        this.fKey = key;
        this.fValue = value;
        this.fParent = parent;
        this.fBuiltIn = builtIn;
        if (!builtIn) {
            Assert.isTrue(value instanceof String || value == null);
        }
    }

    public IClasspathAttribute newClasspathAttribute() {
        Assert.isTrue(!this.fBuiltIn);
        if (this.fValue != null) {
            return JavaCore.newClasspathAttribute((String)this.fKey, (String)((String)this.fValue));
        }
        return null;
    }

    public CPListElement getParent() {
        return this.fParent;
    }

    public boolean isBuiltIn() {
        return this.fBuiltIn;
    }

    public boolean isInNonModifiableContainer() {
        return this.fParent.isInNonModifiableContainer();
    }

    public String getKey() {
        return this.fKey;
    }

    public Object getValue() {
        return this.fValue;
    }

    public void setValue(Object value) {
        this.fValue = value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CPListElementAttribute)) {
            return false;
        }
        CPListElementAttribute attrib = (CPListElementAttribute)obj;
        return attrib.fKey == this.fKey && attrib.getParent().getPath().equals((Object)this.fParent.getPath());
    }
}

