/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;

public class JavaTypeCompletionProposal
extends JavaCompletionProposal {
    protected final ICompilationUnit fCompilationUnit;
    private final String fUnqualifiedTypeName;
    private final String fFullyQualifiedTypeName;

    public JavaTypeCompletionProposal(String replacementString, ICompilationUnit cu, int replacementOffset, int replacementLength, Image image, String displayString, int relevance) {
        this(replacementString, cu, replacementOffset, replacementLength, image, displayString, relevance, null);
    }

    public JavaTypeCompletionProposal(String replacementString, ICompilationUnit cu, int replacementOffset, int replacementLength, Image image, String displayString, int relevance, String fullyQualifiedTypeName) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance);
        this.fCompilationUnit = cu;
        this.fFullyQualifiedTypeName = fullyQualifiedTypeName;
        this.fUnqualifiedTypeName = fullyQualifiedTypeName != null ? Signature.getSimpleName((String)fullyQualifiedTypeName) : null;
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportsStructure impStructure) throws CoreException, BadLocationException {
        if (impStructure != null && this.fFullyQualifiedTypeName != null) {
            IType[] types;
            String replacementString = this.getReplacementString();
            String qualifiedType = this.fFullyQualifiedTypeName;
            if (qualifiedType.indexOf(46) != -1 && replacementString.startsWith(qualifiedType) && !replacementString.endsWith(String.valueOf(';')) && (types = impStructure.getCompilationUnit().getTypes()).length > 0 && types[0].getSourceRange().getOffset() <= offset) {
                this.setReplacementString(impStructure.addImport(this.getReplacementString()));
                return true;
            }
        }
        return false;
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            boolean importAdded;
            ImportsStructure impStructure = null;
            if (this.fCompilationUnit != null && this.allowAddingImports()) {
                IJavaProject project = this.fCompilationUnit.getJavaProject();
                String[] prefOrder = JavaPreferencesSettings.getImportOrderPreference(project);
                int threshold = JavaPreferencesSettings.getImportNumberThreshold(project);
                impStructure = new ImportsStructure(this.fCompilationUnit, prefOrder, threshold, true);
            }
            if (importAdded = this.updateReplacementString(document, trigger, offset, impStructure)) {
                this.setCursorPosition(this.getReplacementString().length());
            }
            super.apply(document, trigger, offset);
            if (importAdded && impStructure != null) {
                int oldLen = document.getLength();
                impStructure.getResultingEdits(document, (IProgressMonitor)new NullProgressMonitor()).apply(document, 2);
                this.setReplacementOffset(this.getReplacementOffset() + document.getLength() - oldLen);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    private boolean allowAddingImports() {
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("content_assist_add_import");
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        boolean isValid = super.validate(document, offset, event);
        if (isValid) {
            return true;
        }
        return this.fUnqualifiedTypeName != null && this.startsWith(document, offset, this.fUnqualifiedTypeName) || this.fFullyQualifiedTypeName != null && this.startsWith(document, offset, this.fFullyQualifiedTypeName);
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.fUnqualifiedTypeName;
    }
}

