/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MethodProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.ProposalContextInformation;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class JavaMethodCompletionProposal
extends LazyJavaCompletionProposal {
    protected static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '\t', '[', ' '};
    protected static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '-', ' '};
    protected final ICompilationUnit fCompilationUnit;
    private boolean fHasParameters;
    private boolean fHasParametersComputed = false;
    private int fContextInformationPosition;

    public JavaMethodCompletionProposal(CompletionProposal proposal, ICompilationUnit cu) {
        super(proposal);
        this.fCompilationUnit = cu;
    }

    public void apply(IDocument document, char trigger, int offset) {
        super.apply(document, trigger, offset);
        try {
            this.setUpLinkedMode(document, this.getReplacementString());
        }
        catch (BadLocationException badLocationException) {}
    }

    private void setUpLinkedMode(IDocument document, String string) throws BadLocationException {
        IPreferenceStore preferenceStore;
        int index;
        if (this.getTextViewer() != null && string != null && (index = string.indexOf("()")) != -1 && index + 1 == this.getCursorPosition() && (preferenceStore = JavaPlugin.getDefault().getPreferenceStore()).getBoolean("closeBrackets")) {
            int newOffset = this.getReplacementOffset() + this.getCursorPosition();
            LinkedPositionGroup group = new LinkedPositionGroup();
            group.addPosition(new LinkedPosition(document, newOffset, 0, -1));
            LinkedModeModel model = new LinkedModeModel();
            model.addGroup(group);
            model.forceInstall();
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
            ui.setSimpleMode(true);
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(')', document));
            ui.setExitPosition(this.getTextViewer(), newOffset + 1, 0, Integer.MAX_VALUE);
            ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
            ui.enter();
        }
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        String string = this.getReplacementString();
        int pos = string.indexOf(40);
        if (pos > 0) {
            return string.subSequence(0, pos);
        }
        return string;
    }

    protected IContextInformation computeContextInformation() {
        if (this.fProposal.getKind() == 6 && this.hasParameters() && (this.getReplacementString().endsWith(")") || this.getReplacementString().length() == 0)) {
            ProposalContextInformation contextInformation = new ProposalContextInformation(this.fProposal);
            if (this.fContextInformationPosition != 0 && this.fProposal.getCompletion().length == 0) {
                contextInformation.setContextInformationPosition(this.fContextInformationPosition);
            }
            return contextInformation;
        }
        return super.computeContextInformation();
    }

    protected char[] computeTriggerCharacters() {
        if (this.hasParameters()) {
            return METHOD_WITH_ARGUMENTS_TRIGGERS;
        }
        return METHOD_TRIGGERS;
    }

    protected final boolean hasParameters() {
        if (!this.fHasParametersComputed) {
            this.fHasParametersComputed = true;
            this.fHasParameters = this.computeHasParameters();
        }
        return this.fHasParameters;
    }

    private boolean computeHasParameters() throws IllegalArgumentException {
        return Signature.getParameterCount((char[])this.fProposal.getSignature()) > 0;
    }

    protected int computeCursorPosition() {
        if (this.hasParameters() && this.getReplacementString().endsWith(")")) {
            return this.getReplacementString().indexOf("(") + 1;
        }
        return super.computeCursorPosition();
    }

    protected ProposalInfo computeProposalInfo() {
        IJavaProject project;
        if (this.fCompilationUnit != null && (project = this.fCompilationUnit.getJavaProject()) != null) {
            return new MethodProposalInfo(project, this.fProposal);
        }
        return super.computeProposalInfo();
    }

    public void setContextInformationPosition(int contextInformationPosition) {
        this.fContextInformationPosition = contextInformationPosition;
    }

    protected static class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        private final IDocument fDocument;

        public ExitPolicy(char exitCharacter, IDocument document) {
            this.fExitCharacter = exitCharacter;
            this.fDocument = document;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public LinkedModeUI.ExitFlags doExit(LinkedModeModel environment, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter) {
                if (!environment.anyPositionContains(offset)) return new LinkedModeUI.ExitFlags(2, true);
                return new LinkedModeUI.ExitFlags(2, false);
            }
            switch (event.character) {
                case ';': {
                    return new LinkedModeUI.ExitFlags(0, true);
                }
                case '\r': {
                    if (offset <= 0) return null;
                    try {
                        if (this.fDocument.getChar(offset - 1) != '{') return null;
                        return new LinkedModeUI.ExitFlags(1, true);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return null;
        }
    }
}

