/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.text.folding.IJavaFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class DefaultJavaFoldingStructureProvider
implements IProjectionListener,
IJavaFoldingStructureProvider {
    private IDocument fCachedDocument;
    private ProjectionAnnotationModel fCachedModel;
    private ITextEditor fEditor;
    private ProjectionViewer fViewer;
    private IJavaElement fInput;
    private IElementChangedListener fElementListener;
    private boolean fAllowCollapsing = false;
    private boolean fCollapseJavadoc = false;
    private boolean fCollapseImportContainer = true;
    private boolean fCollapseInnerTypes = true;
    private boolean fCollapseMethods = false;
    private boolean fCollapseHeaderComments = true;
    private IType fFirstType;
    private boolean fHasHeaderComment;
    static /* synthetic */ Class class$0;

    public void install(ITextEditor editor, ProjectionViewer viewer) {
        if (editor instanceof JavaEditor) {
            this.fEditor = editor;
            this.fViewer = viewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer = null;
            this.fEditor = null;
        }
    }

    protected boolean isInstalled() {
        return this.fEditor != null;
    }

    public void projectionEnabled() {
        this.projectionDisabled();
        if (this.fEditor instanceof JavaEditor) {
            this.initialize();
            this.fElementListener = new ElementChangedListener();
            JavaCore.addElementChangedListener((IElementChangedListener)this.fElementListener);
        }
    }

    public void projectionDisabled() {
        this.fCachedDocument = null;
        if (this.fElementListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fElementListener);
            this.fElementListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        this.initializePreferences();
        try {
            IDocumentProvider provider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = provider.getDocument((Object)this.fEditor.getEditorInput());
            this.fAllowCollapsing = true;
            this.fFirstType = null;
            this.fHasHeaderComment = false;
            if (this.fEditor instanceof CompilationUnitEditor) {
                IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
                this.fInput = manager.getWorkingCopy(this.fEditor.getEditorInput());
            } else if (this.fEditor instanceof ClassFileEditor) {
                IClassFileEditorInput editorInput = (IClassFileEditorInput)this.fEditor.getEditorInput();
                this.fInput = editorInput.getClassFile();
            }
            if (this.fInput != null) {
                ProjectionAnnotationModel model;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((model = (ProjectionAnnotationModel)this.fEditor.getAdapter((Class)clazz)) != null) {
                    this.fCachedModel = model;
                    if (this.fInput instanceof ICompilationUnit) {
                        ICompilationUnit unit;
                        ICompilationUnit iCompilationUnit = unit = (ICompilationUnit)this.fInput;
                        synchronized (iCompilationUnit) {
                            try {
                                unit.reconcile(0, false, null, null);
                            }
                            catch (JavaModelException javaModelException) {}
                        }
                    }
                    Map additions = this.computeAdditions((IParent)this.fInput);
                    LinkedList removals = new LinkedList();
                    Iterator existing = model.getAnnotationIterator();
                    while (existing.hasNext()) {
                        removals.add(existing.next());
                    }
                    model.replaceAnnotations(removals.toArray(new Annotation[removals.size()]), additions);
                }
            }
            Object var6_8 = null;
            this.fCachedDocument = null;
            this.fCachedModel = null;
            this.fAllowCollapsing = false;
            this.fFirstType = null;
            this.fHasHeaderComment = false;
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fCachedDocument = null;
            this.fCachedModel = null;
            this.fAllowCollapsing = false;
            this.fFirstType = null;
            this.fHasHeaderComment = false;
            throw throwable;
        }
    }

    private void initializePreferences() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        this.fCollapseInnerTypes = store.getBoolean("editor_folding_default_innertypes");
        this.fCollapseImportContainer = store.getBoolean("editor_folding_default_imports");
        this.fCollapseJavadoc = store.getBoolean("editor_folding_default_javadoc");
        this.fCollapseMethods = store.getBoolean("editor_folding_default_methods");
        this.fCollapseHeaderComments = store.getBoolean("editor_folding_default_headers");
    }

    private Map computeAdditions(IParent parent) {
        LinkedHashMap map = new LinkedHashMap();
        try {
            this.computeAdditions(parent.getChildren(), map);
        }
        catch (JavaModelException javaModelException) {}
        return map;
    }

    private void computeAdditions(IJavaElement[] elements, Map map) throws JavaModelException {
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            this.computeAdditions(element, map);
            if (element instanceof IParent) {
                IParent parent = (IParent)element;
                this.computeAdditions(parent.getChildren(), map);
            }
            ++i;
        }
    }

    private void computeAdditions(IJavaElement element, Map map) {
        IRegion[] regions;
        boolean createProjection = false;
        boolean collapse = false;
        switch (element.getElementType()) {
            case 12: {
                collapse = this.fAllowCollapsing && this.fCollapseImportContainer;
                createProjection = true;
                break;
            }
            case 7: {
                collapse = this.fAllowCollapsing && this.fCollapseInnerTypes && this.isInnerType((IType)element);
                createProjection = true;
                break;
            }
            case 9: {
                collapse = this.fAllowCollapsing && this.fCollapseMethods;
                createProjection = true;
            }
        }
        if (createProjection && (regions = this.computeProjectionRanges(element)) != null) {
            int i = 0;
            while (i < regions.length - 1) {
                Position position = this.createProjectionPosition(regions[i], null);
                if (position != null) {
                    boolean commentCollapse = i == 0 && (regions.length > 2 || this.fHasHeaderComment) && element == this.fFirstType ? this.fAllowCollapsing && this.fCollapseHeaderComments : this.fAllowCollapsing && this.fCollapseJavadoc;
                    map.put(new JavaProjectionAnnotation(element, commentCollapse, true), position);
                }
                ++i;
            }
            Position position = this.createProjectionPosition(regions[regions.length - 1], element);
            if (position != null) {
                map.put(new JavaProjectionAnnotation(element, collapse, false), position);
            }
        }
    }

    private boolean isInnerType(IType type) {
        try {
            return type.isMember();
        }
        catch (JavaModelException javaModelException) {
            IJavaElement parent = type.getParent();
            if (parent != null) {
                int parentType = parent.getElementType();
                return parentType != 5 && parentType != 6;
            }
            return false;
        }
    }

    private IRegion[] computeProjectionRanges(IJavaElement element) {
        try {
            if (element instanceof ISourceReference) {
                int shift;
                ISourceReference reference = (ISourceReference)element;
                ISourceRange range = reference.getSourceRange();
                String contents = reference.getSource();
                if (contents == null) {
                    return null;
                }
                ArrayList<Object> regions = new ArrayList<Object>();
                if (this.fFirstType == null && element instanceof IType) {
                    this.fFirstType = (IType)element;
                    IRegion headerComment = this.computeHeaderComment(this.fFirstType);
                    if (headerComment != null) {
                        regions.add(headerComment);
                        this.fHasHeaderComment = true;
                    }
                }
                IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
                scanner.setSource(contents.toCharArray());
                int start = shift = range.getOffset();
                block7: while (true) {
                    int token = scanner.getNextToken();
                    start = shift + scanner.getCurrentTokenStartPosition();
                    switch (token) {
                        case 1002: 
                        case 1003: {
                            int end = shift + scanner.getCurrentTokenEndPosition() + 1;
                            regions.add(new Region(start, end - start));
                        }
                        case 1001: {
                            continue block7;
                        }
                    }
                    break;
                }
                regions.add(new Region(start, shift + range.getLength() - start));
                if (regions.size() > 0) {
                    IRegion[] result = new IRegion[regions.size()];
                    regions.toArray(result);
                    return result;
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (InvalidInputException invalidInputException) {}
        return null;
    }

    private IRegion computeHeaderComment(IType type) throws JavaModelException {
        if (this.fCachedDocument == null) {
            return null;
        }
        ISourceRange range = type.getSourceRange();
        if (range == null) {
            return null;
        }
        int start = 0;
        int end = range.getOffset();
        if (this.fInput instanceof ISourceReference) {
            String content;
            try {
                content = this.fCachedDocument.get(start, end - start);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
            IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(content.toCharArray());
            int headerStart = -1;
            int headerEnd = -1;
            try {
                boolean foundComment = false;
                int terminal = scanner.getNextToken();
                while (terminal != 158 && terminal != 165 && terminal != 180 && terminal != 400 && (!foundComment || terminal != 191 && terminal != 214)) {
                    if (terminal == 1003 || terminal == 1002 || terminal == 1001) {
                        if (!foundComment) {
                            headerStart = scanner.getCurrentTokenStartPosition();
                        }
                        headerEnd = scanner.getCurrentTokenEndPosition();
                        foundComment = true;
                    }
                    terminal = scanner.getNextToken();
                }
            }
            catch (InvalidInputException invalidInputException) {
                return null;
            }
            if (headerEnd != -1) {
                return new Region(headerStart, headerEnd - headerStart);
            }
        }
        return null;
    }

    private Position createProjectionPosition(IRegion region, IJavaElement element) {
        if (this.fCachedDocument == null) {
            return null;
        }
        try {
            int start = this.fCachedDocument.getLineOfOffset(region.getOffset());
            int end = this.fCachedDocument.getLineOfOffset(region.getOffset() + region.getLength());
            if (start != end) {
                int endOffset;
                int offset = this.fCachedDocument.getLineOffset(start);
                if (this.fCachedDocument.getNumberOfLines() > end + 1) {
                    endOffset = this.fCachedDocument.getLineOffset(end + 1);
                } else if (end > start) {
                    endOffset = this.fCachedDocument.getLineOffset(end) + this.fCachedDocument.getLineLength(end);
                } else {
                    return null;
                }
                if (element instanceof IMember) {
                    return new JavaElementPosition(offset, endOffset - offset, (IMember)element);
                }
                return new CommentPosition(offset, endOffset - offset);
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processDelta(IJavaElementDelta delta) {
        ProjectionAnnotationModel model;
        if (!this.isInstalled()) {
            return;
        }
        if ((delta.getFlags() & 9) == 0) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        if ((model = (ProjectionAnnotationModel)this.fEditor.getAdapter((Class)clazz)) == null) {
            return;
        }
        try {
            IDocumentProvider provider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = provider.getDocument((Object)this.fEditor.getEditorInput());
            this.fCachedModel = model;
            this.fAllowCollapsing = false;
            this.fFirstType = null;
            this.fHasHeaderComment = false;
            HashMap<JavaProjectionAnnotation, Position> additions = new HashMap<JavaProjectionAnnotation, Position>();
            ArrayList<JavaProjectionAnnotation> deletions = new ArrayList<JavaProjectionAnnotation>();
            ArrayList<JavaProjectionAnnotation> updates = new ArrayList<JavaProjectionAnnotation>();
            Map updated = this.computeAdditions((IParent)this.fInput);
            Map previous = this.createAnnotationMap((IAnnotationModel)model);
            Iterator<Object> e = updated.keySet().iterator();
            while (true) {
                if (!e.hasNext()) break;
                JavaProjectionAnnotation newAnnotation = (JavaProjectionAnnotation)((Object)e.next());
                IJavaElement element = newAnnotation.getElement();
                Position newPosition = (Position)updated.get((Object)newAnnotation);
                List annotations = (List)previous.get(element);
                if (annotations == null) {
                    additions.put(newAnnotation, newPosition);
                    continue;
                }
                Iterator x = annotations.iterator();
                boolean matched = false;
                while (x.hasNext()) {
                    Tuple tuple = (Tuple)x.next();
                    JavaProjectionAnnotation existingAnnotation = tuple.annotation;
                    Position existingPosition = tuple.position;
                    if (newAnnotation.isComment() != existingAnnotation.isComment()) continue;
                    if (existingPosition != null && !newPosition.equals((Object)existingPosition)) {
                        existingPosition.setOffset(newPosition.getOffset());
                        existingPosition.setLength(newPosition.getLength());
                        updates.add(existingAnnotation);
                    }
                    matched = true;
                    x.remove();
                    break;
                }
                if (!matched) {
                    additions.put(newAnnotation, newPosition);
                }
                if (!annotations.isEmpty()) continue;
                previous.remove(element);
            }
            e = previous.values().iterator();
            block7: while (true) {
                block16: {
                    if (e.hasNext()) break block16;
                    this.match(deletions, additions, updates);
                    Annotation[] removals = new Annotation[deletions.size()];
                    deletions.toArray(removals);
                    Annotation[] changes = new Annotation[updates.size()];
                    updates.toArray(changes);
                    model.modifyAnnotations(removals, additions, changes);
                    break;
                }
                List list = (List)e.next();
                int size = list.size();
                int i = 0;
                while (true) {
                    if (i >= size) continue block7;
                    deletions.add(((Tuple)list.get((int)i)).annotation);
                    ++i;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            this.fCachedDocument = null;
            this.fAllowCollapsing = true;
            this.fCachedModel = null;
            this.fFirstType = null;
            this.fHasHeaderComment = false;
            throw throwable;
        }
        {
            Object var19_23 = null;
            this.fCachedDocument = null;
            this.fAllowCollapsing = true;
            this.fCachedModel = null;
            this.fFirstType = null;
            this.fHasHeaderComment = false;
            return;
        }
    }

    private void match(List deletions, Map additions, List changes) {
        if (deletions.isEmpty() || additions.isEmpty() && changes.isEmpty()) {
            return;
        }
        ArrayList<JavaProjectionAnnotation> newDeletions = new ArrayList<JavaProjectionAnnotation>();
        ArrayList<JavaProjectionAnnotation> newChanges = new ArrayList<JavaProjectionAnnotation>();
        Iterator deletionIterator = deletions.iterator();
        while (deletionIterator.hasNext()) {
            JavaProjectionAnnotation deleted = (JavaProjectionAnnotation)((Object)deletionIterator.next());
            Position deletedPosition = this.fCachedModel.getPosition((Annotation)deleted);
            if (deletedPosition == null) continue;
            Tuple deletedTuple = new Tuple(deleted, deletedPosition);
            Tuple match = this.findMatch(deletedTuple, changes, null);
            boolean addToDeletions = true;
            if (match == null) {
                match = this.findMatch(deletedTuple, additions.keySet(), additions);
                addToDeletions = false;
            }
            if (match == null) continue;
            IJavaElement element = match.annotation.getElement();
            deleted.setElement(element);
            deletedPosition.setLength(match.position.getLength());
            if (deletedPosition instanceof JavaElementPosition && element instanceof IMember) {
                JavaElementPosition jep = (JavaElementPosition)deletedPosition;
                jep.setMember((IMember)element);
            }
            deletionIterator.remove();
            newChanges.add(deleted);
            if (!addToDeletions) continue;
            newDeletions.add(match.annotation);
        }
        deletions.addAll(newDeletions);
        changes.addAll(newChanges);
    }

    private Tuple findMatch(Tuple tuple, Collection annotations, Map positionMap) {
        Iterator it = annotations.iterator();
        while (it.hasNext()) {
            Position position;
            JavaProjectionAnnotation annotation = (JavaProjectionAnnotation)((Object)it.next());
            if (tuple.annotation.isComment() != annotation.isComment()) continue;
            Position position2 = position = positionMap == null ? this.fCachedModel.getPosition((Annotation)annotation) : (Position)positionMap.get((Object)annotation);
            if (position == null || tuple.position.getOffset() != position.getOffset()) continue;
            it.remove();
            return new Tuple(annotation, position);
        }
        return null;
    }

    private Map createAnnotationMap(IAnnotationModel model) {
        HashMap<IJavaElement, ArrayList<Tuple>> map = new HashMap<IJavaElement, ArrayList<Tuple>>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object annotation = e.next();
            if (!(annotation instanceof JavaProjectionAnnotation)) continue;
            JavaProjectionAnnotation java = (JavaProjectionAnnotation)((Object)annotation);
            Position position = model.getPosition((Annotation)java);
            Assert.isNotNull((Object)position);
            ArrayList<Tuple> list = (ArrayList<Tuple>)map.get(java.getElement());
            if (list == null) {
                list = new ArrayList<Tuple>(2);
                map.put(java.getElement(), list);
            }
            list.add(new Tuple(java, position));
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Tuple)o1).position.getOffset() - ((Tuple)o2).position.getOffset();
            }
        };
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            Collections.sort(list, comparator);
        }
        return map;
    }

    private static final class JavaProjectionAnnotation
    extends ProjectionAnnotation {
        private IJavaElement fJavaElement;
        private boolean fIsComment;

        public JavaProjectionAnnotation(IJavaElement element, boolean isCollapsed, boolean isComment) {
            super(isCollapsed);
            this.fJavaElement = element;
            this.fIsComment = isComment;
        }

        public IJavaElement getElement() {
            return this.fJavaElement;
        }

        public void setElement(IJavaElement element) {
            this.fJavaElement = element;
        }

        public boolean isComment() {
            return this.fIsComment;
        }

        public void setIsComment(boolean isComment) {
            this.fIsComment = isComment;
        }

        public String toString() {
            return "JavaProjectionAnnotation:\n\telement: \t" + this.fJavaElement.toString() + "\n" + "\tcollapsed: \t" + this.isCollapsed() + "\n" + "\tcomment: \t" + this.fIsComment + "\n";
        }
    }

    private static final class Tuple {
        JavaProjectionAnnotation annotation;
        Position position;

        Tuple(JavaProjectionAnnotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            IJavaElementDelta delta = this.findElement(DefaultJavaFoldingStructureProvider.this.fInput, e.getDelta());
            if (delta != null) {
                DefaultJavaFoldingStructureProvider.this.processDelta(delta);
            }
        }

        private IJavaElementDelta findElement(IJavaElement target, IJavaElementDelta delta) {
            if (delta == null || target == null) {
                return null;
            }
            IJavaElement element = delta.getElement();
            if (element.getElementType() > 6) {
                return null;
            }
            if (target.equals(element)) {
                return delta;
            }
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IJavaElementDelta d = this.findElement(target, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }
    }

    private static final class CommentPosition
    extends Position
    implements IProjectionPosition {
        CommentPosition(int offset, int length) {
            super(offset, length);
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            int prefixEnd = 0;
            int contentStart = this.findFirstContent(sequence, prefixEnd);
            int firstLine = document.getLineOfOffset(this.offset + prefixEnd);
            int captionLine = document.getLineOfOffset(this.offset + contentStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            Assert.isTrue((firstLine <= captionLine ? 1 : 0) != 0, (String)"first folded line is greater than the caption line");
            Assert.isTrue((captionLine <= lastLine ? 1 : 0) != 0, (String)"caption line is greater than the last folded line");
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        private int findFirstContent(CharSequence content, int prefixEnd) {
            int lenght = content.length();
            int i = prefixEnd;
            while (i < lenght) {
                if (Character.isUnicodeIdentifierPart(content.charAt(i))) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public int computeCaptionOffset(IDocument document) {
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            return this.findFirstContent(sequence, 0);
        }
    }

    private static final class JavaElementPosition
    extends Position
    implements IProjectionPosition {
        private IMember fMember;

        public JavaElementPosition(int offset, int length, IMember member) {
            super(offset, length);
            Assert.isNotNull((Object)member);
            this.fMember = member;
        }

        public void setMember(IMember member) {
            Assert.isNotNull((Object)member);
            this.fMember = member;
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            int nameStart = this.offset;
            try {
                ISourceRange nameRange = this.fMember.getNameRange();
                if (nameRange != null) {
                    nameStart = nameRange.getOffset();
                }
            }
            catch (JavaModelException javaModelException) {}
            int firstLine = document.getLineOfOffset(this.offset);
            int captionLine = document.getLineOfOffset(nameStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            if (captionLine < firstLine) {
                captionLine = firstLine;
            }
            if (captionLine > lastLine) {
                captionLine = lastLine;
            }
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        public int computeCaptionOffset(IDocument document) throws BadLocationException {
            int nameStart = this.offset;
            try {
                ISourceRange nameRange = this.fMember.getNameRange();
                if (nameRange != null) {
                    nameStart = nameRange.getOffset();
                }
            }
            catch (JavaModelException javaModelException) {}
            return nameStart - this.offset;
        }
    }
}

