/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CastCompletionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ChangeMethodSignatureProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ImplementInterfaceProposal;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.TypeChangeCompletionProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.swt.graphics.Image;

public class TypeMismatchSubProcessor {
    private TypeMismatchSubProcessor() {
    }

    public static void addTypeMismatchProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        BodyDeclaration decl;
        ITypeBinding currBinding;
        boolean nullOrVoid;
        String[] args = problem.getProblemArguments();
        if (args.length != 2) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        String castTypeName = args[1];
        CompilationUnit astRoot = context.getASTRoot();
        AST ast = astRoot.getAST();
        ASTNode selectedNode = problem.getCoveredNode(astRoot);
        if (!(selectedNode instanceof Expression)) {
            return;
        }
        Expression nodeToCast = (Expression)selectedNode;
        Name receiverNode = null;
        ITypeBinding castTypeBinding = null;
        int parentNodeType = selectedNode.getParent().getNodeType();
        if (parentNodeType == 7) {
            Assignment assign = (Assignment)selectedNode.getParent();
            Expression leftHandSide = assign.getLeftHandSide();
            if (selectedNode.equals((Object)leftHandSide)) {
                nodeToCast = assign.getRightHandSide();
            }
            castTypeBinding = assign.getLeftHandSide().resolveTypeBinding();
            if (leftHandSide instanceof Name) {
                receiverNode = (Name)leftHandSide;
            } else if (leftHandSide instanceof FieldAccess) {
                receiverNode = ((FieldAccess)leftHandSide).getName();
            }
        } else if (parentNodeType == 59) {
            VariableDeclarationFragment frag = (VariableDeclarationFragment)selectedNode.getParent();
            if (selectedNode.equals((Object)frag.getName())) {
                nodeToCast = frag.getInitializer();
                IVariableBinding varBinding = frag.resolveBinding();
                if (varBinding != null) {
                    castTypeBinding = varBinding.getType();
                }
                receiverNode = frag.getName();
            }
        } else {
            ITypeBinding guessedCastTypeBinding = ASTResolving.guessBindingForReference((ASTNode)nodeToCast);
            if (guessedCastTypeBinding != null && castTypeName.equals(guessedCastTypeBinding.getQualifiedName())) {
                castTypeBinding = guessedCastTypeBinding;
            }
        }
        ITypeBinding binding = nodeToCast.resolveTypeBinding();
        if (binding == null || TypeMismatchSubProcessor.canCast(castTypeName, castTypeBinding, binding)) {
            proposals.add(TypeMismatchSubProcessor.createCastProposal(context, castTypeName, castTypeBinding, nodeToCast, 7));
        }
        boolean bl = nullOrVoid = (currBinding = nodeToCast.resolveTypeBinding()) == null || "void".equals(currBinding.getName());
        if (!nullOrVoid && parentNodeType == 41 && (decl = ASTResolving.findParentBodyDeclaration(selectedNode)) instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)decl;
            if ((currBinding = Bindings.normalizeTypeBinding(currBinding)) == null) {
                currBinding = ast.resolveWellKnownType("java.lang.Object");
            }
            if (currBinding.isWildcardType()) {
                currBinding = ASTResolving.normalizeWildcardType(currBinding, true, ast);
            }
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ImportRewrite imports = new ImportRewrite(cu);
            Type newReturnType = imports.addImport(currBinding, ast);
            rewrite.replace((ASTNode)methodDeclaration.getReturnType2(), (ASTNode)newReturnType, null);
            String label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturntype_description, currBinding.getName());
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, 6, image);
            proposal.setImportRewrite(imports);
            String returnKey = "return";
            proposal.addLinkedPosition(rewrite.track((ASTNode)newReturnType), true, returnKey);
            ITypeBinding[] typeSuggestions = ASTResolving.getRelaxingTypes(ast, currBinding);
            int i = 0;
            while (i < typeSuggestions.length) {
                proposal.addLinkedPositionProposal(returnKey, typeSuggestions[i]);
                ++i;
            }
            proposals.add(proposal);
        }
        if (!nullOrVoid && receiverNode != null) {
            if ((currBinding = Bindings.normalizeTypeBinding(currBinding)) == null) {
                currBinding = ast.resolveWellKnownType("java.lang.Object");
            }
            if (currBinding.isWildcardType()) {
                currBinding = ASTResolving.normalizeWildcardType(currBinding, true, ast);
            }
            TypeMismatchSubProcessor.addChangeSenderTypeProposals(context, (Expression)receiverNode, currBinding, true, 6, proposals);
        }
        if (castTypeBinding != null) {
            TypeMismatchSubProcessor.addChangeSenderTypeProposals(context, nodeToCast, castTypeBinding, false, 5, proposals);
        }
    }

    public static void addChangeSenderTypeProposals(IInvocationContext context, Expression nodeToCast, ITypeBinding castTypeBinding, boolean isAssignedNode, int relevance, Collection proposals) throws JavaModelException {
        IMethodBinding methodBinding;
        IMethodBinding callerBinding = null;
        switch (nodeToCast.getNodeType()) {
            case 32: {
                callerBinding = ((MethodInvocation)nodeToCast).resolveMethodBinding();
                break;
            }
            case 48: {
                callerBinding = ((SuperMethodInvocation)nodeToCast).resolveMethodBinding();
                break;
            }
            case 22: {
                callerBinding = ((FieldAccess)nodeToCast).resolveFieldBinding();
                break;
            }
            case 47: {
                callerBinding = ((SuperFieldAccess)nodeToCast).resolveFieldBinding();
                break;
            }
            case 40: 
            case 42: {
                callerBinding = ((Name)nodeToCast).resolveBinding();
            }
        }
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ICompilationUnit targetCu = null;
        ITypeBinding declaringType = null;
        IMethodBinding callerBindingDecl = callerBinding;
        if (callerBinding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)callerBinding;
            if (!variableBinding.isField()) {
                targetCu = cu;
            } else {
                callerBindingDecl = Bindings.getVariableDeclaration(variableBinding);
                declaringType = variableBinding.getDeclaringClass().getTypeDeclaration();
            }
        } else if (callerBinding instanceof IMethodBinding && !(methodBinding = callerBinding).isConstructor()) {
            declaringType = methodBinding.getDeclaringClass().getTypeDeclaration();
            callerBindingDecl = methodBinding.getMethodDeclaration();
        }
        if (declaringType != null && declaringType.isFromSource()) {
            targetCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringType);
        }
        if (targetCu != null && ASTResolving.isUseableTypeInContext(castTypeBinding, (IBinding)callerBindingDecl, false)) {
            proposals.add(new TypeChangeCompletionProposal(targetCu, (IBinding)callerBindingDecl, astRoot, castTypeBinding, isAssignedNode, relevance));
        }
        if (!isAssignedNode) {
            ITypeBinding typeDecl;
            ICompilationUnit nodeCu;
            ITypeBinding nodeType = nodeToCast.resolveTypeBinding();
            if (castTypeBinding.isInterface() && nodeType != null && nodeType.isClass() && !nodeType.isAnonymous() && nodeType.isFromSource() && (nodeCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, typeDecl = nodeType.getTypeDeclaration())) != null && ASTResolving.isUseableTypeInContext(castTypeBinding, (IBinding)typeDecl, true)) {
                proposals.add(new ImplementInterfaceProposal(nodeCu, typeDecl, astRoot, castTypeBinding, relevance - 1));
            }
        }
    }

    private static boolean canCast(String castTarget, ITypeBinding castTypeBinding, ITypeBinding bindingToCast) {
        if (castTypeBinding != null) {
            return bindingToCast.isCastCompatible(castTypeBinding);
        }
        if ((bindingToCast = Bindings.normalizeTypeBinding(bindingToCast)) == null) {
            return false;
        }
        int arrStart = castTarget.indexOf(91);
        if (arrStart != -1) {
            if (!bindingToCast.isArray()) {
                return "java.lang.Object".equals(bindingToCast.getQualifiedName());
            }
            castTarget = castTarget.substring(0, arrStart);
            if ((bindingToCast = bindingToCast.getElementType()).isPrimitive() && !castTarget.equals(bindingToCast.getName())) {
                return false;
            }
        }
        PrimitiveType.Code targetCode = PrimitiveType.toCode((String)castTarget);
        if (bindingToCast.isPrimitive()) {
            PrimitiveType.Code castCode = PrimitiveType.toCode((String)bindingToCast.getName());
            if (castCode == targetCode) {
                return true;
            }
            return targetCode != null && targetCode != PrimitiveType.BOOLEAN && castCode != PrimitiveType.BOOLEAN;
        }
        return targetCode == null;
    }

    public static ASTRewriteCorrectionProposal createCastProposal(IInvocationContext context, String castType, ITypeBinding castTypeBinding, Expression nodeToCast, int relevance) {
        ICompilationUnit cu = context.getCompilationUnit();
        String label = nodeToCast.getNodeType() == 11 ? Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changecast_description, castType) : Messages.format(CorrectionMessages.TypeMismatchSubProcessor_addcast_description, castType);
        if (castTypeBinding != null) {
            return new CastCompletionProposal(label, cu, nodeToCast, castTypeBinding, relevance);
        }
        return new CastCompletionProposal(label, cu, nodeToCast, castType, relevance);
    }

    public static void addIncompatibleReturnTypeProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws JavaModelException {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration decl = (MethodDeclaration)selectedNode;
        IMethodBinding methodDeclBinding = decl.resolveBinding();
        if (methodDeclBinding == null) {
            return;
        }
        IMethodBinding overridden = Bindings.findMethodDefininition(methodDeclBinding, false);
        if (overridden == null || overridden.getReturnType() == methodDeclBinding.getReturnType()) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        IMethodBinding methodDecl = methodDeclBinding.getMethodDeclaration();
        proposals.add(new TypeChangeCompletionProposal(cu, (IBinding)methodDecl, astRoot, overridden.getReturnType(), false, 8));
        ICompilationUnit targetCu = cu;
        IMethodBinding overriddenDecl = overridden.getMethodDeclaration();
        ITypeBinding overridenDeclType = overriddenDecl.getDeclaringClass();
        ITypeBinding returnType = methodDeclBinding.getReturnType();
        if (overridenDeclType.isFromSource()) {
            targetCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, overridenDeclType);
        }
        if (targetCu != null && ASTResolving.isUseableTypeInContext(returnType, (IBinding)overriddenDecl, false)) {
            TypeChangeCompletionProposal proposal = new TypeChangeCompletionProposal(targetCu, (IBinding)overriddenDecl, astRoot, returnType, false, 7);
            if (overridenDeclType.isInterface()) {
                proposal.setDisplayName(Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturnofimplemented_description, overriddenDecl.getName()));
            } else {
                proposal.setDisplayName(Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturnofoverridden_description, overriddenDecl.getName()));
            }
            proposals.add(proposal);
        }
    }

    public static void addIncompatibleThrowsProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws JavaModelException {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration decl = (MethodDeclaration)selectedNode;
        IMethodBinding methodDeclBinding = decl.resolveBinding();
        if (methodDeclBinding == null) {
            return;
        }
        IMethodBinding overridden = Bindings.findMethodDefininition(methodDeclBinding, false);
        if (overridden == null) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ITypeBinding[] methodExceptions = methodDeclBinding.getExceptionTypes();
        ITypeBinding[] definedExceptions = overridden.getExceptionTypes();
        ArrayList<ITypeBinding> undeclaredExceptions = new ArrayList<ITypeBinding>();
        ChangeMethodSignatureProposal.ChangeDescription[] changes = new ChangeMethodSignatureProposal.ChangeDescription[methodExceptions.length];
        int i = 0;
        while (i < methodExceptions.length) {
            if (!TypeMismatchSubProcessor.isDeclaredException(methodExceptions[i], definedExceptions)) {
                changes[i] = new ChangeMethodSignatureProposal.RemoveDescription();
                undeclaredExceptions.add(methodExceptions[i]);
            }
            ++i;
        }
        String label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_removeexceptions_description, methodDeclBinding.getName());
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.remove_correction.gif");
        proposals.add(new ChangeMethodSignatureProposal(label, cu, (ASTNode)astRoot, methodDeclBinding, null, changes, 8, image));
        ITypeBinding declaringType = overridden.getDeclaringClass();
        ICompilationUnit targetCu = cu;
        if (declaringType != null && declaringType.isFromSource()) {
            targetCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringType);
        }
        if (targetCu != null) {
            ChangeMethodSignatureProposal.ChangeDescription[] changes2 = new ChangeMethodSignatureProposal.ChangeDescription[definedExceptions.length + undeclaredExceptions.size()];
            int i2 = 0;
            while (i2 < undeclaredExceptions.size()) {
                changes2[i2 + definedExceptions.length] = new ChangeMethodSignatureProposal.InsertDescription((ITypeBinding)undeclaredExceptions.get(i2), "");
                ++i2;
            }
            IMethodBinding overriddenDecl = overridden.getMethodDeclaration();
            Object[] args = new String[]{declaringType.getName(), overridden.getName()};
            String label2 = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_addexceptions_description, args);
            Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif");
            proposals.add(new ChangeMethodSignatureProposal(label2, targetCu, (ASTNode)astRoot, overriddenDecl, null, changes2, 7, image2));
        }
    }

    private static boolean isDeclaredException(ITypeBinding curr, ITypeBinding[] declared) {
        int i = 0;
        while (i < declared.length) {
            if (Bindings.isSuperType(declared[i], curr)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

