/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.MarkerResolutionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.text.correction.PropertiesFileCorrectionAssistant;
import org.eclipse.jdt.internal.ui.text.spelling.WordQuickFixProcessor;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class PropertiesFileCorrectionProcessor
implements IContentAssistProcessor {
    private static String fgErrorMessage;
    private static WordQuickFixProcessor fgWordQuickFixProcessor;
    private PropertiesFileCorrectionAssistant fAssistant;

    static {
        fgWordQuickFixProcessor = new WordQuickFixProcessor();
    }

    public static boolean isQuickFixableType(Annotation annotation) {
        return (annotation instanceof IJavaAnnotation || annotation instanceof SimpleMarkerAnnotation) && !annotation.isMarkedDeleted();
    }

    public static boolean hasCorrections(Annotation annotation) {
        IJavaAnnotation javaAnnotation;
        int problemId;
        if (annotation instanceof IJavaAnnotation && (problemId = (javaAnnotation = (IJavaAnnotation)annotation).getId()) != -1) {
            return fgWordQuickFixProcessor.hasCorrections(null, problemId);
        }
        if (annotation instanceof SimpleMarkerAnnotation) {
            return PropertiesFileCorrectionProcessor.hasCorrections(((SimpleMarkerAnnotation)annotation).getMarker());
        }
        return false;
    }

    private static boolean hasCorrections(IMarker marker) {
        if (marker == null || !marker.exists()) {
            return false;
        }
        IMarkerHelpRegistry registry = IDE.getMarkerHelpRegistry();
        return registry != null && registry.hasResolutions(marker);
    }

    public static boolean hasAssists(IInvocationContext context) {
        return false;
    }

    public PropertiesFileCorrectionProcessor(PropertiesFileCorrectionAssistant assistant) {
        this.fAssistant = assistant;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ICompletionProposal[] iCompletionProposalArray;
        IEditorPart part = this.fAssistant.getEditor();
        int length = viewer != null ? viewer.getSelectedRange().y : 0;
        AssistContext context = new AssistContext(null, documentOffset, length);
        fgErrorMessage = null;
        ArrayList<ChangeCorrectionProposal> proposals = new ArrayList<ChangeCorrectionProposal>();
        IAnnotationModel model = null;
        IEditorInput input = part.getEditorInput();
        if (!(input instanceof IStorageEditorInput)) {
            return null;
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = null;
        try {
            path = ((IStorageEditorInput)input).getStorage().getFullPath();
            if (path == null) {
                return null;
            }
            manager.connect(path, null);
        }
        catch (CoreException e) {
            JavaPlugin.log(e.getStatus());
            return null;
        }
        try {
            model = manager.getTextFileBuffer(path).getAnnotationModel();
            if (model != null) {
                this.processAnnotations(context, model, proposals);
            }
            if (proposals.isEmpty()) {
                proposals.add(new ChangeCorrectionProposal(CorrectionMessages.NoCorrectionProposal_description, null, 0, null));
            }
            ICompletionProposal[] res = proposals.toArray(new ICompletionProposal[proposals.size()]);
            Arrays.sort(res, new CompletionProposalComparator());
            iCompletionProposalArray = res;
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            try {
                manager.disconnect(path, null);
            }
            catch (CoreException e) {
                JavaPlugin.log(e.getStatus());
            }
            throw throwable;
        }
        try {
            manager.disconnect(path, null);
        }
        catch (CoreException e) {
            JavaPlugin.log(e.getStatus());
        }
        return iCompletionProposalArray;
    }

    private boolean isAtPosition(int offset, Position pos) {
        return pos != null && offset >= pos.getOffset() && offset <= pos.getOffset() + pos.getLength();
    }

    private void processAnnotations(IInvocationContext context, IAnnotationModel model, ArrayList proposals) {
        int offset = context.getSelectionOffset();
        ArrayList problems = new ArrayList();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position pos;
            Annotation annotation = (Annotation)iter.next();
            if (!PropertiesFileCorrectionProcessor.isQuickFixableType(annotation) || !this.isAtPosition(offset, pos = model.getPosition(annotation))) continue;
            this.processAnnotation(annotation, pos, problems, proposals);
        }
        IProblemLocation[] problemLocations = problems.toArray(new IProblemLocation[problems.size()]);
        PropertiesFileCorrectionProcessor.collectCorrections(context, problemLocations, proposals);
    }

    private void processAnnotation(Annotation curr, Position pos, List problems, List proposals) {
        IJavaAnnotation javaAnnotation;
        int problemId;
        if (curr instanceof IJavaAnnotation && (problemId = (javaAnnotation = (IJavaAnnotation)curr).getId()) != -1) {
            problems.add(new ProblemLocation(pos.getOffset(), pos.getLength(), javaAnnotation));
            return;
        }
        if (curr instanceof SimpleMarkerAnnotation) {
            IMarker marker = ((SimpleMarkerAnnotation)curr).getMarker();
            IMarkerResolution[] res = IDE.getMarkerHelpRegistry().getResolutions(marker);
            if (res.length > 0) {
                int i = 0;
                while (i < res.length) {
                    proposals.add(new MarkerResolutionProposal(res[i], marker));
                    ++i;
                }
            }
        }
    }

    public static void collectCorrections(IInvocationContext context, IProblemLocation[] locations, ArrayList proposals) {
        try {
            IJavaCompletionProposal[] res = fgWordQuickFixProcessor.getCorrections(context, locations);
            if (res != null) {
                int k = 0;
                while (k < res.length) {
                    proposals.add(res[k]);
                    ++k;
                }
            }
        }
        catch (Exception e) {
            fgErrorMessage = CorrectionMessages.JavaCorrectionProcessor_error_quickfix_message;
            JavaPlugin.log(e);
        }
    }

    public static void collectAssists(IInvocationContext context, IProblemLocation[] locations, ArrayList proposals) {
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return fgErrorMessage;
    }
}

