/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.correction.PropertiesFileCorrectionProcessor;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class PropertiesFileCorrectionAssistant
extends ContentAssistant {
    private ITextViewer fViewer;
    private ITextEditor fEditor;
    private Position fPosition;

    public PropertiesFileCorrectionAssistant(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        PropertiesFileCorrectionProcessor processor = new PropertiesFileCorrectionProcessor(this);
        this.setContentAssistProcessor(processor, "__pf_roperty_value");
        this.setContentAssistProcessor(processor, "__pf_comment");
        this.enableAutoActivation(false);
        this.enableAutoInsert(false);
        this.setContextInformationPopupOrientation(20);
        this.setInformationControlCreator(this.getInformationControlCreator());
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        IColorManager manager = textTools.getColorManager();
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        Color c = PropertiesFileCorrectionAssistant.getColor(store, "content_assist_proposals_foreground", manager);
        this.setProposalSelectorForeground(c);
        c = PropertiesFileCorrectionAssistant.getColor(store, "content_assist_proposals_background", manager);
        this.setProposalSelectorBackground(c);
    }

    public IEditorPart getEditor() {
        return this.fEditor;
    }

    private IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter());
            }
        };
    }

    private static Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.fViewer = textViewer;
    }

    public void uninstall() {
        this.fViewer = null;
    }

    public String showPossibleCompletions() {
        int invocationOffset;
        if (this.fViewer == null || this.fViewer.getDocument() == null) {
            return super.showPossibleCompletions();
        }
        Point selectedRange = this.fViewer.getSelectedRange();
        this.fPosition = null;
        if (selectedRange.y == 0 && (invocationOffset = this.computeOffsetWithCorrection(selectedRange.x)) != -1) {
            this.storePosition();
            this.fViewer.setSelectedRange(invocationOffset, 0);
            this.fViewer.revealRange(invocationOffset, 0);
        }
        return super.showPossibleCompletions();
    }

    private int computeOffsetWithCorrection(int initalOffset) {
        IRegion lineInfo = null;
        try {
            lineInfo = this.fViewer.getDocument().getLineInformationOfOffset(initalOffset);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        int startOffset = lineInfo.getOffset();
        int endOffset = startOffset + lineInfo.getLength();
        int result = this.computeOffsetWithCorrection(startOffset, endOffset, initalOffset);
        if (result > 0 && result != initalOffset) {
            return result;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int computeOffsetWithCorrection(int startOffset, int endOffset, int initialOffset) {
        block16: {
            block14: {
                block15: {
                    model = null;
                    input = this.fEditor.getEditorInput();
                    if (!(input instanceof IStorageEditorInput)) {
                        return -1;
                    }
                    manager = FileBuffers.getTextFileBufferManager();
                    path = null;
                    try {
                        path = ((IStorageEditorInput)input).getStorage().getFullPath();
                        if (path == null) {
                            return -1;
                        }
                        manager.connect(path, null);
                    }
                    catch (CoreException e) {
                        JavaPlugin.log(e.getStatus());
                        return -1;
                    }
                    try {
                        block13: {
                            model = manager.getTextFileBuffer(path).getAnnotationModel();
                            invocationOffset = -1;
                            offsetOfFirstProblem = 0x7FFFFFFF;
                            iter = model.getAnnotationIterator();
                            while (true) {
                                if (!iter.hasNext()) {
                                    if (initialOffset >= offsetOfFirstProblem || offsetOfFirstProblem == 0x7FFFFFFF) break block13;
                                    var15_15 = offsetOfFirstProblem;
                                    break block14;
                                }
                                annot = (Annotation)iter.next();
                                if (!JavaCorrectionProcessor.isQuickFixableType(annot) || !this.isIncluded(pos = model.getPosition(annot), startOffset, endOffset) || !PropertiesFileCorrectionProcessor.hasCorrections(annot)) continue;
                                offsetOfFirstProblem = Math.min(offsetOfFirstProblem, pos.getOffset());
                                if (initialOffset == (invocationOffset = this.computeBestOffset(invocationOffset, pos, initialOffset))) break;
                            }
                            var15_14 = initialOffset;
                            var13_17 = null;
                            break block15;
                        }
                        var15_16 = invocationOffset;
                        break block16;
                    }
                    catch (Throwable var14_25) {
                        var13_20 = null;
                        try {
                            manager.disconnect(path, null);
                            throw var14_25;
                        }
                        catch (CoreException e) {
                            JavaPlugin.log(e.getStatus());
                            throw var14_25;
                        }
                    }
                }
                ** try [egrp 2[TRYBLOCK] [4 : 257->270)] { 
lbl51:
                // 1 sources

                manager.disconnect(path, null);
                return var15_14;
lbl53:
                // 1 sources

                catch (CoreException e) {
                    JavaPlugin.log(e.getStatus());
                }
                return var15_14;
            }
            var13_18 = null;
            ** try [egrp 2[TRYBLOCK] [4 : 257->270)] { 
lbl59:
            // 1 sources

            manager.disconnect(path, null);
            return var15_15;
lbl61:
            // 1 sources

            catch (CoreException e) {
                JavaPlugin.log(e.getStatus());
            }
            return var15_15;
        }
        var13_19 = null;
        ** try [egrp 2[TRYBLOCK] [4 : 257->270)] { 
lbl67:
        // 1 sources

        manager.disconnect(path, null);
        return var15_16;
lbl69:
        // 1 sources

        catch (CoreException e) {
            JavaPlugin.log(e.getStatus());
        }
        return var15_16;
    }

    private boolean isIncluded(Position pos, int lineStart, int lineEnd) {
        return pos != null && pos.getOffset() >= lineStart && pos.getOffset() + pos.getLength() <= lineEnd;
    }

    private int computeBestOffset(int invocationOffset, Position pos, int initalOffset) {
        int newOffset = pos.offset;
        if (newOffset <= initalOffset && initalOffset <= newOffset + pos.length) {
            return initalOffset;
        }
        if (invocationOffset < 0) {
            return newOffset;
        }
        if (newOffset <= initalOffset && invocationOffset >= initalOffset) {
            return newOffset;
        }
        if (newOffset <= initalOffset && invocationOffset < initalOffset) {
            return Math.max(invocationOffset, newOffset);
        }
        if (invocationOffset <= initalOffset) {
            return invocationOffset;
        }
        return Math.max(invocationOffset, newOffset);
    }

    protected void possibleCompletionsClosed() {
        super.possibleCompletionsClosed();
        this.restorePosition();
    }

    private void storePosition() {
        int initalOffset = this.fViewer.getSelectedRange().x;
        int length = this.fViewer.getSelectedRange().y;
        this.fPosition = new Position(initalOffset, length);
    }

    private void restorePosition() {
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fViewer.getDocument() != null) {
            this.fViewer.setSelectedRange(this.fPosition.offset, this.fPosition.length);
            this.fViewer.revealRange(this.fPosition.offset, this.fPosition.length);
        }
        this.fPosition = null;
    }

    public boolean isUpdatedOffset() {
        return this.fPosition != null;
    }
}

