/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class ImplementInterfaceProposal
extends LinkedCorrectionProposal {
    private IBinding fBinding;
    private CompilationUnit fAstRoot;
    private ITypeBinding fNewInterface;

    public ImplementInterfaceProposal(ICompilationUnit targetCU, ITypeBinding binding, CompilationUnit astRoot, ITypeBinding newInterface, int relevance) {
        super("", targetCU, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        Assert.isTrue(binding != null && Bindings.isDeclarationBinding((IBinding)binding));
        this.fBinding = binding;
        this.fAstRoot = astRoot;
        this.fNewInterface = newInterface;
        Object[] args = new String[]{binding.getName(), Bindings.getRawName(newInterface)};
        this.setDisplayName(Messages.format(CorrectionMessages.ImplementInterfaceProposal_name, args));
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ASTNode boundNode = this.fAstRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            ASTParser astParser = ASTParser.newParser((int)3);
            astParser.setSource(this.getCompilationUnit());
            astParser.setResolveBindings(true);
            CompilationUnit newRoot = (CompilationUnit)astParser.createAST(null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        if (declNode instanceof TypeDeclaration) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            Type newInterface = this.getImportRewrite().addImport(this.fNewInterface, ast);
            ListRewrite listRewrite = rewrite.getListRewrite(declNode, TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY);
            listRewrite.insertLast((ASTNode)newInterface, null);
            this.addLinkedPosition(rewrite.track((ASTNode)newInterface), true, "type");
            return rewrite;
        }
        return null;
    }
}

