/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.swt.graphics.Image;

public class ChangeMethodSignatureProposal
extends LinkedCorrectionProposal {
    private ASTNode fInvocationNode;
    private IMethodBinding fSenderBinding;
    private ChangeDescription[] fParameterChanges;
    private ChangeDescription[] fExceptionChanges;

    public ChangeMethodSignatureProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, IMethodBinding binding, ChangeDescription[] paramChanges, ChangeDescription[] exceptionChanges, int relevance, Image image) {
        super(label, targetCU, (ASTRewrite)null, relevance, image);
        Assert.isTrue(binding != null && Bindings.isDeclarationBinding((IBinding)binding));
        this.fInvocationNode = invocationNode;
        this.fSenderBinding = binding;
        this.fParameterChanges = paramChanges;
        this.fExceptionChanges = exceptionChanges;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        boolean isInDifferentCU;
        CompilationUnit astRoot = (CompilationUnit)this.fInvocationNode.getRoot();
        ASTNode methodDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        ASTNode newMethodDecl = null;
        if (methodDecl != null) {
            isInDifferentCU = false;
            newMethodDecl = methodDecl;
        } else {
            isInDifferentCU = true;
            ASTParser astParser = ASTParser.newParser((int)3);
            astParser.setSource(this.getCompilationUnit());
            astParser.setResolveBindings(true);
            astRoot = (CompilationUnit)astParser.createAST(null);
            newMethodDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        if (newMethodDecl instanceof MethodDeclaration) {
            MethodDeclaration decl = (MethodDeclaration)newMethodDecl;
            ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
            if (this.fParameterChanges != null) {
                this.modifyParameters(rewrite, decl, isInDifferentCU);
            }
            if (this.fExceptionChanges != null) {
                this.modifyExceptions(rewrite, decl);
            }
            return rewrite;
        }
        return null;
    }

    private void modifyParameters(ASTRewrite rewrite, MethodDeclaration methodDecl, boolean isInDifferentCU) throws CoreException {
        AST ast = methodDecl.getAST();
        ArrayList<String> usedNames = new ArrayList<String>();
        boolean hasCreatedVariables = false;
        IVariableBinding[] declaredFields = this.fSenderBinding.getDeclaringClass().getDeclaredFields();
        int i = 0;
        while (i < declaredFields.length) {
            usedNames.add(declaredFields[i].getName());
            ++i;
        }
        ImportRewrite imports = this.getImportRewrite();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)methodDecl, MethodDeclaration.PARAMETERS_PROPERTY);
        List parameters = methodDecl.parameters();
        int k = 0;
        int i2 = 0;
        while (i2 < this.fParameterChanges.length) {
            ModifyDescription desc;
            ChangeDescription curr = this.fParameterChanges[i2];
            if (curr == null) {
                SingleVariableDeclaration oldParam = (SingleVariableDeclaration)parameters.get(k);
                usedNames.add(oldParam.getName().getIdentifier());
                ++k;
            } else if (curr instanceof InsertDescription) {
                desc = (InsertDescription)curr;
                SingleVariableDeclaration newNode = ast.newSingleVariableDeclaration();
                newNode.setType(imports.addImport(desc.type, ast));
                desc.resultingNode = newNode;
                hasCreatedVariables = true;
                listRewrite.insertAt((ASTNode)newNode, i2, null);
                Javadoc javadoc = methodDecl.getJavadoc();
                if (javadoc != null) {
                    TagElement newTagElement = ast.newTagElement();
                    newTagElement.setTagName("@param");
                    SimpleName arg = ast.newSimpleName("x");
                    newTagElement.fragments().add(arg);
                    this.insertTabStop(rewrite, newTagElement.fragments(), "param_tagcomment" + i2);
                    this.insertParamTag(rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), parameters, k, newTagElement);
                    desc.resultingTagArg = arg;
                } else {
                    desc.resultingTagArg = null;
                }
            } else if (curr instanceof RemoveDescription) {
                SingleVariableDeclaration decl = (SingleVariableDeclaration)parameters.get(k);
                listRewrite.remove((ASTNode)decl, null);
                ++k;
                TagElement tagNode = this.findParamTag(methodDecl, decl);
                if (tagNode != null) {
                    rewrite.remove((ASTNode)tagNode, null);
                }
            } else if (curr instanceof EditDescription) {
                List fragments;
                desc = (EditDescription)curr;
                SingleVariableDeclaration decl = (SingleVariableDeclaration)parameters.get(k);
                SingleVariableDeclaration newNode = ast.newSingleVariableDeclaration();
                newNode.setType(imports.addImport(((EditDescription)desc).type, ast));
                ((EditDescription)desc).resultingNode = newNode;
                hasCreatedVariables = true;
                rewrite.replace((ASTNode)decl, (ASTNode)newNode, null);
                ++k;
                TagElement tagNode = this.findParamTag(methodDecl, decl);
                if (tagNode != null && !(fragments = tagNode.fragments()).isEmpty()) {
                    SimpleName arg = ast.newSimpleName("x");
                    rewrite.replace((ASTNode)fragments.get(0), (ASTNode)arg, null);
                    ((EditDescription)desc).resultingTagArg = arg;
                }
            } else if (curr instanceof SwapDescription) {
                SingleVariableDeclaration decl1 = (SingleVariableDeclaration)parameters.get(k);
                SingleVariableDeclaration decl2 = (SingleVariableDeclaration)parameters.get(((SwapDescription)curr).index);
                rewrite.replace((ASTNode)decl1, rewrite.createCopyTarget((ASTNode)decl2), null);
                rewrite.replace((ASTNode)decl2, rewrite.createCopyTarget((ASTNode)decl1), null);
                usedNames.add(decl1.getName().getIdentifier());
                ++k;
                TagElement tagNode1 = this.findParamTag(methodDecl, decl1);
                TagElement tagNode2 = this.findParamTag(methodDecl, decl2);
                if (tagNode1 != null && tagNode2 != null) {
                    rewrite.replace((ASTNode)tagNode1, rewrite.createCopyTarget((ASTNode)tagNode2), null);
                    rewrite.replace((ASTNode)tagNode2, rewrite.createCopyTarget((ASTNode)tagNode1), null);
                }
            }
            ++i2;
        }
        if (!hasCreatedVariables) {
            return;
        }
        if (methodDecl.getBody() != null) {
            CompilationUnit root = (CompilationUnit)methodDecl.getRoot();
            IBinding[] bindings = new ScopeAnalyzer(root).getDeclarationsAfter(methodDecl.getBody().getStartPosition(), 2);
            int i3 = 0;
            while (i3 < bindings.length) {
                usedNames.add(bindings[i3].getName());
                ++i3;
            }
        }
        this.fixupNames(rewrite, usedNames, methodDecl, isInDifferentCU);
    }

    private void fixupNames(ASTRewrite rewrite, ArrayList usedNames, MethodDeclaration methodDecl, boolean isInDifferentCU) {
        AST ast = rewrite.getAST();
        int i = 0;
        while (i < this.fParameterChanges.length) {
            ChangeDescription curr = this.fParameterChanges[i];
            if (curr instanceof ModifyDescription) {
                ModifyDescription desc = (ModifyDescription)curr;
                SingleVariableDeclaration var = desc.resultingNode;
                String suggestedName = desc.name;
                String typeKey = this.getParamTypeGroupId(i);
                String nameKey = this.getParamNameGroupId(i);
                String favourite = null;
                String[] excludedNames = usedNames.toArray(new String[usedNames.size()]);
                if (suggestedName != null) {
                    favourite = StubUtility.suggestArgumentName(this.getCompilationUnit().getJavaProject(), suggestedName, excludedNames);
                    this.addLinkedPositionProposal(nameKey, favourite, null);
                }
                Type type = var.getType();
                int dim = 0;
                if (type.isArrayType()) {
                    dim = ((ArrayType)type).getDimensions();
                    type = ((ArrayType)type).getElementType();
                }
                String[] suggestedNames = NamingConventions.suggestArgumentNames((IJavaProject)this.getCompilationUnit().getJavaProject(), (String)"", (String)ASTNodes.asString((ASTNode)type), (int)dim, (String[])excludedNames);
                int k = 0;
                while (k < suggestedNames.length) {
                    this.addLinkedPositionProposal(nameKey, suggestedNames[k], null);
                    ++k;
                }
                if (favourite == null) {
                    favourite = suggestedNames[0];
                }
                var.setName(ast.newSimpleName(favourite));
                usedNames.add(favourite);
                ITypeBinding[] bindings = ASTResolving.getRelaxingTypes(ast, desc.type);
                int k2 = 0;
                while (k2 < bindings.length) {
                    this.addLinkedPositionProposal(typeKey, bindings[k2]);
                    ++k2;
                }
                this.addLinkedPosition(rewrite.track((ASTNode)var.getType()), false, typeKey);
                this.addLinkedPosition(rewrite.track((ASTNode)var.getName()), false, nameKey);
                SimpleName tagArg = desc.resultingTagArg;
                if (tagArg != null) {
                    tagArg.setIdentifier(favourite);
                    this.addLinkedPosition(rewrite.track((ASTNode)tagArg), false, nameKey);
                }
            }
            ++i;
        }
    }

    private TagElement findParamTag(MethodDeclaration decl, SingleVariableDeclaration param) {
        Javadoc javadoc = decl.getJavadoc();
        if (javadoc != null) {
            return JavadocTagsSubProcessor.findParamTag(javadoc, param.getName().getIdentifier());
        }
        return null;
    }

    private TagElement insertParamTag(ListRewrite tagRewriter, List parameters, int currentIndex, TagElement newTagElement) {
        HashSet<String> previousNames = new HashSet<String>();
        int n = 0;
        while (n < currentIndex) {
            SingleVariableDeclaration var = (SingleVariableDeclaration)parameters.get(n);
            previousNames.add(var.getName().getIdentifier());
            ++n;
        }
        JavadocTagsSubProcessor.insertTag(tagRewriter, newTagElement, previousNames);
        return newTagElement;
    }

    private void modifyExceptions(ASTRewrite rewrite, MethodDeclaration methodDecl) throws CoreException {
        AST ast = methodDecl.getAST();
        ImportRewrite imports = this.getImportRewrite();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)methodDecl, MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY);
        List exceptions = methodDecl.thrownExceptions();
        int k = 0;
        int i = 0;
        while (i < this.fExceptionChanges.length) {
            Name newRef;
            ModifyDescription desc;
            ChangeDescription curr = this.fExceptionChanges[i];
            if (curr == null) {
                ++k;
            } else if (curr instanceof InsertDescription) {
                desc = (InsertDescription)curr;
                String type = imports.addImport(desc.type);
                Name newNode = ASTNodeFactory.newName(ast, type);
                listRewrite.insertAt((ASTNode)newNode, i, null);
                String key = this.getExceptionTypeGroupId(i);
                this.addLinkedPosition(rewrite.track((ASTNode)newNode), false, key);
                Javadoc javadoc = methodDecl.getJavadoc();
                if (javadoc != null) {
                    TagElement newTagElement = ast.newTagElement();
                    newTagElement.setTagName("@throws");
                    newRef = ASTNodeFactory.newName(ast, type);
                    newTagElement.fragments().add(newRef);
                    this.insertTabStop(rewrite, newTagElement.fragments(), "throws_tagcomment" + i);
                    this.insertThrowsTag(rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), exceptions, k, newTagElement);
                    this.addLinkedPosition(rewrite.track((ASTNode)newRef), false, key);
                }
            } else if (curr instanceof RemoveDescription) {
                Name node = (Name)exceptions.get(k);
                listRewrite.remove((ASTNode)node, null);
                ++k;
                TagElement tagNode = this.findThrowsTag(methodDecl, node);
                if (tagNode != null) {
                    rewrite.remove((ASTNode)tagNode, null);
                }
            } else if (curr instanceof EditDescription) {
                desc = (EditDescription)curr;
                Name oldNode = (Name)exceptions.get(k);
                String type = imports.addImport(((EditDescription)desc).type);
                Name newNode = ASTNodeFactory.newName(ast, type);
                listRewrite.replace((ASTNode)oldNode, (ASTNode)newNode, null);
                String key = this.getExceptionTypeGroupId(i);
                this.addLinkedPosition(rewrite.track((ASTNode)newNode), false, key);
                ++k;
                TagElement tagNode = this.findThrowsTag(methodDecl, oldNode);
                if (tagNode != null) {
                    newRef = ASTNodeFactory.newName(ast, type);
                    rewrite.replace((ASTNode)tagNode.fragments().get(0), (ASTNode)newRef, null);
                    this.addLinkedPosition(rewrite.track((ASTNode)newRef), false, key);
                }
            } else if (curr instanceof SwapDescription) {
                Name decl1 = (Name)exceptions.get(k);
                Name decl2 = (Name)exceptions.get(((SwapDescription)curr).index);
                rewrite.replace((ASTNode)decl1, rewrite.createCopyTarget((ASTNode)decl2), null);
                rewrite.replace((ASTNode)decl2, rewrite.createCopyTarget((ASTNode)decl1), null);
                ++k;
                TagElement tagNode1 = this.findThrowsTag(methodDecl, decl1);
                TagElement tagNode2 = this.findThrowsTag(methodDecl, decl2);
                if (tagNode1 != null && tagNode2 != null) {
                    rewrite.replace((ASTNode)tagNode1, rewrite.createCopyTarget((ASTNode)tagNode2), null);
                    rewrite.replace((ASTNode)tagNode2, rewrite.createCopyTarget((ASTNode)tagNode1), null);
                }
            }
            ++i;
        }
    }

    private void insertTabStop(ASTRewrite rewriter, List fragments, String linkedName) {
        TextElement textElement = rewriter.getAST().newTextElement();
        textElement.setText("");
        fragments.add(textElement);
        this.addLinkedPosition(rewriter.track((ASTNode)textElement), false, linkedName);
    }

    private TagElement findThrowsTag(MethodDeclaration decl, Name exception) {
        Javadoc javadoc = decl.getJavadoc();
        if (javadoc != null) {
            String name = ASTNodes.getSimpleNameIdentifier(exception);
            return JavadocTagsSubProcessor.findThrowsTag(javadoc, name);
        }
        return null;
    }

    private TagElement insertThrowsTag(ListRewrite tagRewriter, List exceptions, int currentIndex, TagElement newTagElement) {
        HashSet<String> previousNames = new HashSet<String>();
        int n = 0;
        while (n < currentIndex) {
            Name curr = (Name)exceptions.get(n);
            previousNames.add(ASTNodes.getSimpleNameIdentifier(curr));
            ++n;
        }
        JavadocTagsSubProcessor.insertTag(tagRewriter, newTagElement, previousNames);
        return newTagElement;
    }

    public String getParamNameGroupId(int idx) {
        return "param_name_" + idx;
    }

    public String getParamTypeGroupId(int idx) {
        return "param_type_" + idx;
    }

    public String getExceptionTypeGroupId(int idx) {
        return "exc_type_" + idx;
    }

    public static interface ChangeDescription {
    }

    public static class SwapDescription
    implements ChangeDescription {
        final int index;

        public SwapDescription(int index) {
            this.index = index;
        }
    }

    public static class RemoveDescription
    implements ChangeDescription {
    }

    static class ModifyDescription
    implements ChangeDescription {
        public final String name;
        public final ITypeBinding type;
        SingleVariableDeclaration resultingNode;
        SimpleName resultingTagArg;

        private ModifyDescription(ITypeBinding type, String name) {
            this.type = type;
            this.name = name;
        }
    }

    public static class EditDescription
    extends ModifyDescription {
        public EditDescription(ITypeBinding type, String name) {
            super(type, name);
        }
    }

    public static class InsertDescription
    extends ModifyDescription {
        public InsertDescription(ITypeBinding type, String name) {
            super(type, name);
        }
    }
}

