/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchMessages;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchResult;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchResultRequestor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class NLSSearchQuery
implements ISearchQuery {
    private NLSSearchResult fResult;
    private IJavaElement fWrapperClass;
    private IFile fPropertiesFile;
    private IJavaSearchScope fScope;
    private String fScopeDescription;

    public NLSSearchQuery(IJavaElement wrapperClass, IFile propertiesFile, IJavaSearchScope scope, String scopeDescription) {
        this.fWrapperClass = wrapperClass;
        this.fPropertiesFile = propertiesFile;
        this.fScope = scope;
        this.fScopeDescription = scopeDescription;
    }

    IFile getPropertiesFile() {
        return this.fPropertiesFile;
    }

    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("", 5);
        if (!this.fWrapperClass.exists()) {
            return JavaUIStatus.createError(0, Messages.format(NLSSearchMessages.NLSSearchQuery_wrapperNotExists, this.fWrapperClass.getElementName()), null);
        }
        if (!this.fPropertiesFile.exists()) {
            return JavaUIStatus.createError(0, Messages.format(NLSSearchMessages.NLSSearchQuery_propertiesNotExists, this.fPropertiesFile.getName()), null);
        }
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.fWrapperClass, (int)2, (int)24);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        NLSSearchResultRequestor requestor = new NLSSearchResultRequestor(this.fPropertiesFile, this.fResult);
        try {
            SearchEngine engine = new SearchEngine();
            engine.search(pattern, participants, this.fScope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            requestor.reportUnusedPropertyNames((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return NLSSearchMessages.NLSSearchQuery_label;
    }

    public String getResultLabel(int nMatches) {
        if (nMatches == 1) {
            Object[] args = new String[]{this.fWrapperClass.getElementName(), this.fScopeDescription};
            return Messages.format(NLSSearchMessages.SearchOperation_singularLabelPostfix, args);
        }
        Object[] args = new String[]{this.fWrapperClass.getElementName(), String.valueOf(nMatches), this.fScopeDescription};
        return Messages.format(NLSSearchMessages.SearchOperation_pluralLabelPatternPostfix, args);
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new NLSSearchResult(this);
        }
        return this.fResult;
    }
}

