/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.IntroduceParameterRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.jdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class IntroduceParameterWizard
extends RefactoringWizard {
    public IntroduceParameterWizard(IntroduceParameterRefactoring ref) {
        super((Refactoring)ref, 36);
        this.setDefaultPageTitle(RefactoringMessages.IntroduceParameterWizard_defaultPageTitle);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new IntroduceParameterInputPage(this.getIntroduceParameterRefactoring().guessParameterNames()));
    }

    private IntroduceParameterRefactoring getIntroduceParameterRefactoring() {
        return (IntroduceParameterRefactoring)this.getRefactoring();
    }

    private static class IntroduceParameterInputPage
    extends UserInputWizardPage {
        private static final String DESCRIPTION = RefactoringMessages.IntroduceParameterInputPage_description;
        public static final String PAGE_NAME = "IntroduceParameterInputPage";
        private String[] fParamNameProposals;
        private JavaSourceViewer fSignaturePreview;
        private Document fSignaturePreviewDocument;

        public IntroduceParameterInputPage(String[] tempNameProposals) {
            super(PAGE_NAME);
            this.setDescription(DESCRIPTION);
            Assert.isNotNull((Object)tempNameProposals);
            this.fParamNameProposals = tempNameProposals;
            this.fSignaturePreviewDocument = new Document();
        }

        private IntroduceParameterRefactoring getIntroduceParameterRefactoring() {
            return (IntroduceParameterRefactoring)this.getRefactoring();
        }

        public void createControl(Composite parent) {
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            GridLayout layout = new GridLayout();
            result.setLayout((Layout)layout);
            this.createParameterTableControl(result);
            this.createSignaturePreview(result);
            this.update(false);
            Dialog.applyDialogFont((Control)result);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.introduce_parameter_page_context");
        }

        private ChangeParametersControl createParameterTableControl(Composite composite) {
            String labelText = RefactoringMessages.IntroduceParameterWizard_parameters;
            ChangeParametersControl cp = new ChangeParametersControl(composite, 0, labelText, new IParameterListChangeListener(this){
                final /* synthetic */ IntroduceParameterInputPage this$1;
                {
                    this.this$1 = introduceParameterInputPage;
                }

                public void parameterChanged(ParameterInfo parameter) {
                    IntroduceParameterInputPage.access$0(this.this$1, true);
                }

                public void parameterListChanged() {
                    IntroduceParameterInputPage.access$0(this.this$1, true);
                }

                public void parameterAdded(ParameterInfo parameter) {
                    IntroduceParameterInputPage.access$0(this.this$1, true);
                }
            }, ChangeParametersControl.Mode.INTRODUCE_PARAMETER, this.fParamNameProposals);
            cp.setLayoutData(new GridData(1808));
            cp.setInput(this.getIntroduceParameterRefactoring().getParameterInfos());
            cp.editParameter(this.getIntroduceParameterRefactoring().getAddedParameterInfo());
            return cp;
        }

        private void createSignaturePreview(Composite composite) {
            Label previewLabel = new Label(composite, 0);
            previewLabel.setText(RefactoringMessages.ChangeSignatureInputPage_method_Signature_Preview);
            IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
            this.fSignaturePreview = new JavaSourceViewer(composite, null, null, false, 584, store);
            this.fSignaturePreview.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), store, null, null));
            this.fSignaturePreview.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
            this.fSignaturePreview.getTextWidget().setBackground(composite.getBackground());
            this.fSignaturePreview.setDocument((IDocument)this.fSignaturePreviewDocument);
            this.fSignaturePreview.setEditable(false);
            Control signaturePreviewControl = this.fSignaturePreview.getControl();
            PixelConverter pixelConverter = new PixelConverter(signaturePreviewControl);
            GridData gdata = new GridData(1808);
            gdata.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
            gdata.heightHint = pixelConverter.convertHeightInCharsToPixels(2);
            signaturePreviewControl.setLayoutData((Object)gdata);
        }

        private void update(boolean displayErrorMessage) {
            this.updateStatus(displayErrorMessage);
            this.updateSignaturePreview();
        }

        private void updateStatus(boolean displayErrorMessage) {
            RefactoringStatus nameCheck = this.getIntroduceParameterRefactoring().validateInput();
            if (displayErrorMessage) {
                this.setPageComplete(nameCheck);
            } else {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        }

        private void updateSignaturePreview() {
            try {
                int top = this.fSignaturePreview.getTextWidget().getTopPixel();
                this.fSignaturePreviewDocument.set(this.getIntroduceParameterRefactoring().getMethodSignaturePreview());
                this.fSignaturePreview.getTextWidget().setTopPixel(top);
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.ChangeSignatureRefactoring_modify_Parameters, RefactoringMessages.ChangeSignatureInputPage_exception);
            }
        }

        static /* synthetic */ void access$0(IntroduceParameterInputPage introduceParameterInputPage, boolean bl) {
            introduceParameterInputPage.update(bl);
        }
    }
}

