/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.ui.refactoring.PseudoJavaChangeElement;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.IChangeElementChildrenCreator;
import org.eclipse.ltk.internal.ui.refactoring.TextEditChangeElement;
import org.eclipse.text.edits.TextEdit;

public class CompilationUnitChangeChildrenCreator
implements IChangeElementChildrenCreator {
    public void createChildren(DefaultChangeElement changeElement) {
        CompilationUnitChange change = (CompilationUnitChange)changeElement.getChange();
        ICompilationUnit cunit = change.getCompilationUnit();
        ArrayList<TextEditChangeElement> children = new ArrayList<TextEditChangeElement>(5);
        HashMap map = new HashMap(20);
        TextEditChangeGroup[] changes = this.getSortedTextEditChanges((TextChange)change);
        int i = 0;
        while (i < changes.length) {
            TextEditChangeGroup tec = changes[i];
            try {
                IJavaElement element = this.getModifiedJavaElement(tec, cunit);
                if (element.equals(cunit)) {
                    children.add(new TextEditChangeElement((ChangeElement)changeElement, tec));
                } else {
                    PseudoJavaChangeElement pjce = this.getChangeElement(map, element, children, (ChangeElement)changeElement);
                    pjce.addChild(new TextEditChangeElement((ChangeElement)pjce, tec));
                }
            }
            catch (JavaModelException javaModelException) {
                children.add(new TextEditChangeElement((ChangeElement)changeElement, tec));
            }
            ++i;
        }
        changeElement.setChildren(children.toArray(new ChangeElement[children.size()]));
    }

    private TextEditChangeGroup[] getSortedTextEditChanges(TextChange change) {
        TextEditChangeGroup[] edits = change.getTextEditChangeGroups();
        ArrayList<TextEditChangeGroup> result = new ArrayList<TextEditChangeGroup>(edits.length);
        int i = 0;
        while (i < edits.length) {
            if (!edits[i].getTextEditGroup().isEmpty()) {
                result.add(edits[i]);
            }
            ++i;
        }
        OffsetComparator comparator = new OffsetComparator();
        Collections.sort(result, comparator);
        return result.toArray(new TextEditChangeGroup[result.size()]);
    }

    private IJavaElement getModifiedJavaElement(TextEditChangeGroup edit, ICompilationUnit cunit) throws JavaModelException {
        IRegion range = edit.getRegion();
        if (range.getOffset() == 0 && range.getLength() == 0) {
            return cunit;
        }
        IJavaElement result = cunit.getElementAt(range.getOffset());
        if (result == null) {
            return cunit;
        }
        try {
            while (true) {
                ISourceReference ref = (ISourceReference)result;
                Region sRange = new Region(ref.getSourceRange().getOffset(), ref.getSourceRange().getLength());
                if (result.getElementType() != 5 && result.getParent() != null && !this.coveredBy(edit, (IRegion)sRange)) {
                    result = result.getParent();
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (ClassCastException classCastException) {}
        return result;
    }

    private PseudoJavaChangeElement getChangeElement(Map map, IJavaElement element, List children, ChangeElement cunitChange) {
        PseudoJavaChangeElement result = (PseudoJavaChangeElement)((Object)map.get(element));
        if (result != null) {
            return result;
        }
        IJavaElement parent = element.getParent();
        if (parent instanceof ICompilationUnit) {
            result = new PseudoJavaChangeElement(cunitChange, element);
            children.add(result);
            map.put(element, result);
        } else {
            PseudoJavaChangeElement parentChange = this.getChangeElement(map, parent, children, cunitChange);
            result = new PseudoJavaChangeElement((ChangeElement)parentChange, element);
            parentChange.addChild(result);
            map.put(element, result);
        }
        return result;
    }

    private boolean coveredBy(TextEditChangeGroup group, IRegion sourceRegion) {
        int sLength = sourceRegion.getLength();
        if (sLength == 0) {
            return false;
        }
        int sOffset = sourceRegion.getOffset();
        int sEnd = sOffset + sLength - 1;
        TextEdit[] edits = group.getTextEdits();
        int i = 0;
        while (i < edits.length) {
            TextEdit edit = edits[i];
            if (edit.isDeleted()) {
                return false;
            }
            int rOffset = edit.getOffset();
            int rLength = edit.getLength();
            int rEnd = rOffset + rLength - 1;
            if (rLength == 0 ? sOffset >= rOffset || rOffset > sEnd : sOffset > rOffset || rEnd > sEnd) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class OffsetComparator
    implements Comparator {
        OffsetComparator() {
        }

        public int compare(Object o1, Object o2) {
            int p2;
            TextEditChangeGroup c1 = (TextEditChangeGroup)o1;
            TextEditChangeGroup c2 = (TextEditChangeGroup)o2;
            int p1 = this.getOffset(c1);
            if (p1 < (p2 = this.getOffset(c2))) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return 0;
        }

        private int getOffset(TextEditChangeGroup edit) {
            return edit.getRegion().getOffset();
        }
    }
}

