/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ComplianceConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_LOCAL_VARIABLE_ATTR = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.debug.localVariable");
    private static final OptionsConfigurationBlock.Key PREF_LINE_NUMBER_ATTR = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.debug.lineNumber");
    private static final OptionsConfigurationBlock.Key PREF_SOURCE_FILE_ATTR = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.debug.sourceFile");
    private static final OptionsConfigurationBlock.Key PREF_CODEGEN_UNUSED_LOCAL = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.codegen.unusedLocal");
    private static final OptionsConfigurationBlock.Key PREF_CODEGEN_TARGET_PLATFORM = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
    private static final OptionsConfigurationBlock.Key PREF_CODEGEN_INLINE_JSR_BYTECODE = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode");
    private static final OptionsConfigurationBlock.Key PREF_SOURCE_COMPATIBILITY = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.source");
    private static final OptionsConfigurationBlock.Key PREF_COMPLIANCE = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.compliance");
    private static final OptionsConfigurationBlock.Key PREF_PB_ASSERT_AS_IDENTIFIER = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.assertIdentifier");
    private static final OptionsConfigurationBlock.Key PREF_PB_ENUM_AS_IDENTIFIER = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.enumIdentifier");
    private static final OptionsConfigurationBlock.Key INTR_DEFAULT_COMPLIANCE = ComplianceConfigurationBlock.getJDTUIKey("internal.default.compliance");
    private static final String GENERATE = "generate";
    private static final String DO_NOT_GENERATE = "do not generate";
    private static final String PRESERVE = "preserve";
    private static final String OPTIMIZE_OUT = "optimize out";
    private static final String VERSION_1_1 = "1.1";
    private static final String VERSION_1_2 = "1.2";
    private static final String VERSION_1_3 = "1.3";
    private static final String VERSION_1_4 = "1.4";
    private static final String VERSION_1_5 = "1.5";
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final String DEFAULT_CONF = "default";
    private static final String USER_CONF = "user";
    private ArrayList fComplianceControls = new ArrayList();
    private PixelConverter fPixelConverter;
    private String[] fRememberedUserCompliance;
    private static final int IDX_ASSERT_AS_IDENTIFIER = 0;
    private static final int IDX_ENUM_AS_IDENTIFIER = 1;
    private static final int IDX_SOURCE_COMPATIBILITY = 2;
    private static final int IDX_CODEGEN_TARGET_PLATFORM = 3;
    private static final int IDX_COMPLIANCE = 4;
    private static final int IDX_INLINE_JSR_BYTECODE = 5;
    private IStatus fComplianceStatus = new StatusInfo();
    private Link fJRE50InfoText;
    private Composite fControlsComposite;
    private ControlEnableState fBlockEnableState = null;

    public ComplianceConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, ComplianceConfigurationBlock.getKeys(), container);
        this.fRememberedUserCompliance = new String[]{this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER), this.getValue(PREF_PB_ENUM_AS_IDENTIFIER), this.getValue(PREF_SOURCE_COMPATIBILITY), this.getValue(PREF_CODEGEN_TARGET_PLATFORM), this.getValue(PREF_COMPLIANCE), this.getValue(PREF_CODEGEN_INLINE_JSR_BYTECODE)};
    }

    private static OptionsConfigurationBlock.Key[] getKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_LOCAL_VARIABLE_ATTR, PREF_LINE_NUMBER_ATTR, PREF_SOURCE_FILE_ATTR, PREF_CODEGEN_UNUSED_LOCAL, PREF_CODEGEN_INLINE_JSR_BYTECODE, PREF_COMPLIANCE, PREF_SOURCE_COMPATIBILITY, PREF_CODEGEN_TARGET_PLATFORM, PREF_PB_ASSERT_AS_IDENTIFIER, PREF_PB_ENUM_AS_IDENTIFIER};
    }

    protected void settingsUpdated() {
        this.setValue(INTR_DEFAULT_COMPLIANCE, this.getCurrentCompliance());
        super.settingsUpdated();
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite complianceComposite = this.createComplianceTabContent(parent);
        this.validateSettings(null, null, null);
        return complianceComposite;
    }

    public void enablePreferenceContent(boolean enable) {
        if (this.fControlsComposite != null && !this.fControlsComposite.isDisposed()) {
            if (enable) {
                if (this.fBlockEnableState != null) {
                    this.fBlockEnableState.restore();
                    this.fBlockEnableState = null;
                }
            } else if (this.fBlockEnableState == null) {
                this.fBlockEnableState = ControlEnableState.disable((Control)this.fControlsComposite);
            }
        }
    }

    private Composite createComplianceTabContent(Composite folder) {
        String[] values345 = new String[]{VERSION_1_3, VERSION_1_4, VERSION_1_5};
        String[] values345Labels = new String[]{PreferencesMessages.ComplianceConfigurationBlock_version13, PreferencesMessages.ComplianceConfigurationBlock_version14, PreferencesMessages.ComplianceConfigurationBlock_version15};
        ScrolledPageContent sc1 = new ScrolledPageContent(folder);
        Composite composite = sc1.getBody();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.fControlsComposite = new Composite(composite, 0);
        this.fControlsComposite.setFont(composite.getFont());
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        this.fControlsComposite.setLayout((Layout)layout);
        int nColumns = 3;
        layout = new GridLayout();
        layout.numColumns = nColumns;
        Group group = new Group(this.fControlsComposite, 0);
        group.setFont(this.fControlsComposite.getFont());
        group.setText(PreferencesMessages.ComplianceConfigurationBlock_compliance_group_label);
        group.setLayoutData((Object)new GridData(4, 4, false, false));
        group.setLayout((Layout)layout);
        String label = PreferencesMessages.ComplianceConfigurationBlock_compiler_compliance_label;
        this.addComboBox((Composite)group, label, PREF_COMPLIANCE, values345, values345Labels, 0);
        label = PreferencesMessages.ComplianceConfigurationBlock_default_settings_label;
        this.addCheckBox((Composite)group, label, INTR_DEFAULT_COMPLIANCE, new String[]{DEFAULT_CONF, USER_CONF}, 0);
        int indent = this.fPixelConverter.convertWidthInCharsToPixels(2);
        Control[] otherChildren = group.getChildren();
        String[] versions = new String[]{VERSION_1_1, VERSION_1_2, VERSION_1_3, VERSION_1_4, VERSION_1_5};
        String[] versionsLabels = new String[]{PreferencesMessages.ComplianceConfigurationBlock_version11, PreferencesMessages.ComplianceConfigurationBlock_version12, PreferencesMessages.ComplianceConfigurationBlock_version13, PreferencesMessages.ComplianceConfigurationBlock_version14, PreferencesMessages.ComplianceConfigurationBlock_version15};
        label = PreferencesMessages.ComplianceConfigurationBlock_codegen_targetplatform_label;
        this.addComboBox((Composite)group, label, PREF_CODEGEN_TARGET_PLATFORM, versions, versionsLabels, indent);
        label = PreferencesMessages.ComplianceConfigurationBlock_source_compatibility_label;
        this.addComboBox((Composite)group, label, PREF_SOURCE_COMPATIBILITY, values345, values345Labels, indent);
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.ComplianceConfigurationBlock_error, PreferencesMessages.ComplianceConfigurationBlock_warning, PreferencesMessages.ComplianceConfigurationBlock_ignore};
        label = PreferencesMessages.ComplianceConfigurationBlock_pb_assert_as_identifier_label;
        this.addComboBox((Composite)group, label, PREF_PB_ASSERT_AS_IDENTIFIER, errorWarningIgnore, errorWarningIgnoreLabels, indent);
        label = PreferencesMessages.ComplianceConfigurationBlock_pb_enum_as_identifier_label;
        this.addComboBox((Composite)group, label, PREF_PB_ENUM_AS_IDENTIFIER, errorWarningIgnore, errorWarningIgnoreLabels, indent);
        Control[] allChildren = group.getChildren();
        this.fComplianceControls.addAll(Arrays.asList(allChildren));
        this.fComplianceControls.removeAll(Arrays.asList(otherChildren));
        layout = new GridLayout();
        layout.numColumns = nColumns;
        group = new Group(this.fControlsComposite, 0);
        group.setFont(this.fControlsComposite.getFont());
        group.setText(PreferencesMessages.ComplianceConfigurationBlock_classfiles_group_label);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)layout);
        String[] generateValues = new String[]{GENERATE, DO_NOT_GENERATE};
        String[] enableDisableValues = new String[]{ENABLED, DISABLED};
        label = PreferencesMessages.ComplianceConfigurationBlock_variable_attr_label;
        this.addCheckBox((Composite)group, label, PREF_LOCAL_VARIABLE_ATTR, generateValues, 0);
        label = PreferencesMessages.ComplianceConfigurationBlock_line_number_attr_label;
        this.addCheckBox((Composite)group, label, PREF_LINE_NUMBER_ATTR, generateValues, 0);
        label = PreferencesMessages.ComplianceConfigurationBlock_source_file_attr_label;
        this.addCheckBox((Composite)group, label, PREF_SOURCE_FILE_ATTR, generateValues, 0);
        label = PreferencesMessages.ComplianceConfigurationBlock_codegen_unused_local_label;
        this.addCheckBox((Composite)group, label, PREF_CODEGEN_UNUSED_LOCAL, new String[]{PRESERVE, OPTIMIZE_OUT}, 0);
        label = PreferencesMessages.ComplianceConfigurationBlock_codegen_inline_jsr_bytecode_label;
        this.addCheckBox((Composite)group, label, PREF_CODEGEN_INLINE_JSR_BYTECODE, enableDisableValues, 0);
        this.fJRE50InfoText = new Link(composite, 64);
        this.fJRE50InfoText.setText(PreferencesMessages.ComplianceConfigurationBlock_jrecompliance_info);
        this.fJRE50InfoText.setFont(composite.getFont());
        this.fJRE50InfoText.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ComplianceConfigurationBlock.this.openJREInstallPreferencePage();
            }

            public void widgetSelected(SelectionEvent e) {
                ComplianceConfigurationBlock.this.openJREInstallPreferencePage();
            }
        });
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(50);
        this.fJRE50InfoText.setLayoutData((Object)gd);
        this.validateJRE50Status();
        return sc1;
    }

    protected final void openJREInstallPreferencePage() {
        String jreID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
        if (this.fProject == null && this.getPreferenceContainer() != null) {
            this.getPreferenceContainer().openPage(jreID, null);
        } else {
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)jreID, (String[])new String[]{jreID}, null).open();
        }
        this.validateJRE50Status();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        if (changedKey != null) {
            if (INTR_DEFAULT_COMPLIANCE.equals(changedKey)) {
                this.updateComplianceEnableState();
                this.updateComplianceDefaultSettings(true, null);
                this.fComplianceStatus = this.validateCompliance();
            } else if (PREF_COMPLIANCE.equals(changedKey)) {
                String oldDefault = this.setValue(INTR_DEFAULT_COMPLIANCE, DEFAULT_CONF);
                this.updateComplianceEnableState();
                this.updateComplianceDefaultSettings(USER_CONF.equals(oldDefault), oldValue);
                this.fComplianceStatus = this.validateCompliance();
                this.validateJRE50Status();
            } else if (PREF_SOURCE_COMPATIBILITY.equals(changedKey)) {
                this.updateAssertEnumAsIdentifierEnableState();
                this.fComplianceStatus = this.validateCompliance();
            } else if (PREF_CODEGEN_TARGET_PLATFORM.equals(changedKey)) {
                this.updateInlineJSREnableState();
                this.fComplianceStatus = this.validateCompliance();
            } else {
                if (!PREF_PB_ENUM_AS_IDENTIFIER.equals(changedKey) && !PREF_PB_ASSERT_AS_IDENTIFIER.equals(changedKey)) return;
                this.fComplianceStatus = this.validateCompliance();
            }
        } else {
            this.updateComplianceEnableState();
            this.updateAssertEnumAsIdentifierEnableState();
            this.updateInlineJSREnableState();
            this.fComplianceStatus = this.validateCompliance();
            this.validateJRE50Status();
        }
        this.fContext.statusChanged(this.fComplianceStatus);
    }

    private void validateJRE50Status() {
        if (this.fJRE50InfoText != null && !this.fJRE50InfoText.isDisposed()) {
            boolean isVisible = false;
            String compliance = this.getStoredValue(PREF_COMPLIANCE);
            if (VERSION_1_5.equals(compliance)) {
                if (this.fProject != null) {
                    try {
                        IVMInstall install = JavaRuntime.getVMInstall((IJavaProject)JavaCore.create((IProject)this.fProject));
                        isVisible = install == null || !BuildPathSupport.hasMatchingCompliance(install, VERSION_1_5);
                    }
                    catch (CoreException e) {
                        JavaPlugin.log(e);
                    }
                } else {
                    IVMInstall defaultVMInstall = JavaRuntime.getDefaultVMInstall();
                    isVisible = defaultVMInstall == null || !BuildPathSupport.hasMatchingCompliance(defaultVMInstall, VERSION_1_5);
                }
            }
            this.fJRE50InfoText.setVisible(isVisible);
        }
    }

    private IStatus validateCompliance() {
        StatusInfo status = new StatusInfo();
        String compliance = this.getValue(PREF_COMPLIANCE);
        String source = this.getValue(PREF_SOURCE_COMPATIBILITY);
        String target = this.getValue(PREF_CODEGEN_TARGET_PLATFORM);
        if (VERSION_1_3.equals(compliance)) {
            if (VERSION_1_4.equals(source) || VERSION_1_5.equals(source)) {
                status.setError(PreferencesMessages.ComplianceConfigurationBlock_cpl13src145_error);
                return status;
            }
            if (VERSION_1_4.equals(target) || VERSION_1_5.equals(target)) {
                status.setError(PreferencesMessages.ComplianceConfigurationBlock_cpl13trg145_error);
                return status;
            }
        } else if (VERSION_1_4.equals(compliance)) {
            if (VERSION_1_5.equals(source)) {
                status.setError(PreferencesMessages.ComplianceConfigurationBlock_cpl14src15_error);
                return status;
            }
            if (VERSION_1_5.equals(target)) {
                status.setError(PreferencesMessages.ComplianceConfigurationBlock_cpl14trg15_error);
                return status;
            }
        }
        if (VERSION_1_4.equals(source)) {
            if (VERSION_1_1.equals(target) || VERSION_1_2.equals(target) || VERSION_1_3.equals(target)) {
                status.setError(PreferencesMessages.ComplianceConfigurationBlock_src14tgt14_error);
                return status;
            }
        } else if (VERSION_1_5.equals(source) && !VERSION_1_5.equals(target)) {
            status.setError(PreferencesMessages.ComplianceConfigurationBlock_src15tgt15_error);
            return status;
        }
        return status;
    }

    public void useProjectSpecificSettings(boolean enable) {
        super.useProjectSpecificSettings(enable);
        this.validateJRE50Status();
    }

    private void updateComplianceEnableState() {
        boolean enabled = this.checkValue(INTR_DEFAULT_COMPLIANCE, USER_CONF);
        int i = this.fComplianceControls.size() - 1;
        while (i >= 0) {
            Control curr = (Control)this.fComplianceControls.get(i);
            curr.setEnabled(enabled);
            --i;
        }
    }

    private void updateAssertEnumAsIdentifierEnableState() {
        if (this.checkValue(INTR_DEFAULT_COMPLIANCE, USER_CONF)) {
            String compatibility = this.getValue(PREF_SOURCE_COMPATIBILITY);
            boolean isLessThan14 = VERSION_1_3.equals(compatibility);
            this.updateRememberedComplianceOption(PREF_PB_ASSERT_AS_IDENTIFIER, 0, isLessThan14);
            boolean isLessThan15 = isLessThan14 || VERSION_1_4.equals(compatibility);
            this.updateRememberedComplianceOption(PREF_PB_ENUM_AS_IDENTIFIER, 1, isLessThan15);
        }
    }

    private void updateRememberedComplianceOption(OptionsConfigurationBlock.Key prefKey, int idx, boolean enabled) {
        Combo combo = this.getComboBox(prefKey);
        combo.setEnabled(enabled);
        if (!enabled) {
            String val = this.getValue(prefKey);
            if (!ERROR.equals(val)) {
                this.setValue(prefKey, ERROR);
                this.updateCombo(combo);
                this.fRememberedUserCompliance[idx] = val;
            }
        } else {
            String val = this.fRememberedUserCompliance[idx];
            if (!ERROR.equals(val)) {
                this.setValue(prefKey, val);
                this.updateCombo(combo);
            }
        }
    }

    private void updateInlineJSREnableState() {
        boolean enabled = !this.checkValue(PREF_CODEGEN_TARGET_PLATFORM, VERSION_1_5);
        Button checkBox = this.getCheckBox(PREF_CODEGEN_INLINE_JSR_BYTECODE);
        checkBox.setEnabled(enabled);
        if (!enabled) {
            String val;
            this.fRememberedUserCompliance[5] = val = this.getValue(PREF_CODEGEN_INLINE_JSR_BYTECODE);
            if (!ENABLED.equals(val)) {
                this.setValue(PREF_CODEGEN_INLINE_JSR_BYTECODE, ENABLED);
                this.updateCheckBox(checkBox);
            }
        } else {
            String val = this.fRememberedUserCompliance[5];
            if (!ENABLED.equals(val)) {
                this.setValue(PREF_CODEGEN_INLINE_JSR_BYTECODE, val);
                this.updateCheckBox(checkBox);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateComplianceDefaultSettings(boolean rememberOld, String oldComplianceLevel) {
        void var6_8;
        void var5_7;
        void var4_6;
        void var3_5;
        String target;
        String source;
        String enumAsId;
        String assertAsId;
        boolean isDefault = this.checkValue(INTR_DEFAULT_COMPLIANCE, DEFAULT_CONF);
        String complianceLevel = this.getValue(PREF_COMPLIANCE);
        if (isDefault) {
            if (rememberOld) {
                if (oldComplianceLevel == null) {
                    oldComplianceLevel = complianceLevel;
                }
                this.fRememberedUserCompliance[0] = this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER);
                this.fRememberedUserCompliance[1] = this.getValue(PREF_PB_ENUM_AS_IDENTIFIER);
                this.fRememberedUserCompliance[2] = this.getValue(PREF_SOURCE_COMPATIBILITY);
                this.fRememberedUserCompliance[3] = this.getValue(PREF_CODEGEN_TARGET_PLATFORM);
                this.fRememberedUserCompliance[4] = oldComplianceLevel;
            }
            if (VERSION_1_4.equals(complianceLevel)) {
                assertAsId = WARNING;
                enumAsId = WARNING;
                source = VERSION_1_3;
                target = VERSION_1_2;
            } else if (VERSION_1_5.equals(complianceLevel)) {
                assertAsId = ERROR;
                enumAsId = ERROR;
                source = VERSION_1_5;
                target = VERSION_1_5;
            } else {
                assertAsId = IGNORE;
                enumAsId = IGNORE;
                source = VERSION_1_3;
                target = VERSION_1_1;
            }
        } else if (rememberOld && complianceLevel.equals(this.fRememberedUserCompliance[4])) {
            assertAsId = this.fRememberedUserCompliance[0];
            enumAsId = this.fRememberedUserCompliance[1];
            source = this.fRememberedUserCompliance[2];
            target = this.fRememberedUserCompliance[3];
        } else {
            this.updateInlineJSREnableState();
            this.updateAssertEnumAsIdentifierEnableState();
            return;
        }
        this.setValue(PREF_PB_ASSERT_AS_IDENTIFIER, (String)var3_5);
        this.setValue(PREF_PB_ENUM_AS_IDENTIFIER, (String)var4_6);
        this.setValue(PREF_SOURCE_COMPATIBILITY, (String)var5_7);
        this.setValue(PREF_CODEGEN_TARGET_PLATFORM, (String)var6_8);
        this.updateControls();
        this.updateInlineJSREnableState();
        this.updateAssertEnumAsIdentifierEnableState();
    }

    private String getCurrentCompliance() {
        String complianceLevel = this.getValue(PREF_COMPLIANCE);
        if (VERSION_1_3.equals(complianceLevel) && IGNORE.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && IGNORE.equals(this.getValue(PREF_PB_ENUM_AS_IDENTIFIER)) && VERSION_1_3.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_1.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM)) || VERSION_1_4.equals(complianceLevel) && WARNING.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && WARNING.equals(this.getValue(PREF_PB_ENUM_AS_IDENTIFIER)) && VERSION_1_3.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_2.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM)) || VERSION_1_5.equals(complianceLevel) && ERROR.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && ERROR.equals(this.getValue(PREF_PB_ENUM_AS_IDENTIFIER)) && VERSION_1_5.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_5.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM))) {
            return DEFAULT_CONF;
        }
        return USER_CONF;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.ComplianceConfigurationBlock_needsbuild_title;
        String message = workspaceSettings ? PreferencesMessages.ComplianceConfigurationBlock_needsfullbuild_message : PreferencesMessages.ComplianceConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }
}

