/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class OpenCallHierarchyAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public OpenCallHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(CallHierarchyMessages.OpenCallHierarchyAction_label);
        this.setToolTipText(CallHierarchyMessages.OpenCallHierarchyAction_tooltip);
        this.setDescription(CallHierarchyMessages.OpenCallHierarchyAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.call_hierarchy_open_action_context");
    }

    public OpenCallHierarchyAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof IJavaElement)) {
            return false;
        }
        switch (((IJavaElement)input).getElementType()) {
            case 9: {
                return true;
            }
        }
        return false;
    }

    public void run(ITextSelection selection) {
        IJavaElement enclosingMethod;
        IJavaElement input = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        IJavaElement[] elements = SelectionConverter.codeResolveOrInputHandled(this.fEditor, this.getShell(), OpenCallHierarchyAction.getErrorDialogTitle());
        if (elements == null) {
            return;
        }
        ArrayList<IJavaElement> candidates = new ArrayList<IJavaElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IJavaElement[] resolvedElements = CallHierarchyUI.getCandidates(elements[i]);
            if (resolvedElements != null) {
                candidates.addAll(Arrays.asList(resolvedElements));
            }
            ++i;
        }
        if (candidates.isEmpty() && (enclosingMethod = this.getEnclosingMethod(input, selection)) != null) {
            candidates.add(enclosingMethod);
        }
        this.run(candidates.toArray(new IJavaElement[candidates.size()]));
    }

    private IJavaElement getEnclosingMethod(IJavaElement input, ITextSelection selection) {
        IJavaElement enclosingElement = null;
        try {
            switch (input.getElementType()) {
                case 6: {
                    IClassFile classFile = (IClassFile)input.getAncestor(6);
                    if (classFile == null) break;
                    enclosingElement = classFile.getElementAt(selection.getOffset());
                    break;
                }
                case 5: {
                    ICompilationUnit cu = (ICompilationUnit)input.getAncestor(5);
                    if (cu == null) break;
                    enclosingElement = cu.getElementAt(selection.getOffset());
                }
            }
            if (enclosingElement != null && enclosingElement.getElementType() == 9) {
                return enclosingElement;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof IJavaElement)) {
            IStatus status = OpenCallHierarchyAction.createStatus(CallHierarchyMessages.OpenCallHierarchyAction_messages_no_java_element);
            this.openErrorDialog(status);
            return;
        }
        IJavaElement element = (IJavaElement)input;
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        ArrayList result = new ArrayList(1);
        IStatus status = OpenCallHierarchyAction.compileCandidates(result, element);
        if (status.isOK()) {
            this.run(result.toArray(new IJavaElement[result.size()]));
        } else {
            this.openErrorDialog(status);
        }
    }

    private int openErrorDialog(IStatus status) {
        String message = CallHierarchyMessages.OpenCallHierarchyAction_messages_title;
        String dialogTitle = OpenCallHierarchyAction.getErrorDialogTitle();
        return ErrorDialog.openError((Shell)this.getShell(), (String)dialogTitle, (String)message, (IStatus)status);
    }

    private static String getErrorDialogTitle() {
        return CallHierarchyMessages.OpenCallHierarchyAction_dialog_title;
    }

    public void run(IJavaElement[] elements) {
        if (elements.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        CallHierarchyUI.open(elements, this.getSite().getWorkbenchWindow());
    }

    private static IStatus compileCandidates(List result, IJavaElement elem) {
        Status ok = new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        switch (elem.getElementType()) {
            case 9: {
                result.add(elem);
                return ok;
            }
        }
        return OpenCallHierarchyAction.createStatus(CallHierarchyMessages.OpenCallHierarchyAction_messages_no_valid_java_element);
    }

    private static IStatus createStatus(String message) {
        return new Status(1, JavaPlugin.getPluginId(), 10001, message, null);
    }
}

