/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.util.StringMatcher;

public class TypeInfoFilter {
    private String fText;
    private IJavaSearchScope fSearchScope;
    private boolean fIsWorkspaceScope;
    private int fElementKind;
    private StringMatcher fPackageMatcher;
    private String fPackagePattern;
    String fNamePattern;
    private StringMatcher fNameMatcher;
    private String fCamelCasePattern;
    private StringMatcher fCamelCaseTailMatcher;
    private StringMatcher fExactNameMatcher;
    private static final char END_SYMBOL = '<';
    private static final char ANY_STRING = '*';
    private static final char BLANK = ' ';
    private static final int TYPE_MODIFIERS = 25088;

    public TypeInfoFilter(String text, IJavaSearchScope scope, int elementKind) {
        this.fText = text;
        this.fSearchScope = scope;
        this.fIsWorkspaceScope = this.fSearchScope.equals(SearchEngine.createWorkspaceScope());
        this.fElementKind = elementKind;
        int index = text.lastIndexOf(".");
        if (index == -1) {
            this.createNamePattern(text);
        } else {
            this.fPackagePattern = text.substring(0, index);
            this.fPackageMatcher = new StringMatcher(this.fPackagePattern, true, false);
            this.createNamePattern(text.substring(index + 1));
        }
        this.fNameMatcher = new StringMatcher(this.fNamePattern, true, false);
        if (this.fCamelCasePattern != null) {
            this.fExactNameMatcher = new StringMatcher(TypeInfoFilter.createTextPatternFromText(this.fText), true, false);
        }
    }

    public String getText() {
        return this.fText;
    }

    public boolean isSubFilter(String text) {
        return this.fText.startsWith(text);
    }

    public boolean isCamcelCasePattern() {
        return this.fCamelCasePattern != null;
    }

    public String getPackagePattern() {
        return this.fPackagePattern;
    }

    public String getNamePattern() {
        return this.fNamePattern;
    }

    public int getSearchFlags() {
        int result = 0;
        if (this.fCamelCasePattern != null) {
            result |= 8;
        }
        if (this.fNamePattern.indexOf("*") != -1) {
            result |= 2;
        }
        return result;
    }

    public boolean matchesNameExact(TypeInfo type) {
        return this.fExactNameMatcher.match(type.getTypeName());
    }

    public boolean matchesSearchResult(TypeInfo type) {
        return this.matchesCamelCase(type);
    }

    public boolean matchesCachedResult(TypeInfo type) {
        if (!this.matchesName(type) || !this.matchesPackage(type)) {
            return false;
        }
        return this.matchesCamelCase(type);
    }

    public boolean matchesHistoryElement(TypeInfo type) {
        if (!(this.matchesName(type) && this.matchesPackage(type) && this.matchesModifiers(type) && this.matchesScope(type))) {
            return false;
        }
        return this.matchesCamelCase(type);
    }

    private boolean matchesCamelCase(TypeInfo type) {
        if (this.fCamelCasePattern == null) {
            return true;
        }
        String name = type.getTypeName();
        int camelCaseIndex = 0;
        int lastUpperCase = Integer.MAX_VALUE;
        int i = 0;
        while (camelCaseIndex < this.fCamelCasePattern.length() && i < name.length()) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                lastUpperCase = i;
                if (c != this.fCamelCasePattern.charAt(camelCaseIndex)) {
                    return false;
                }
                ++camelCaseIndex;
            }
            ++i;
        }
        if (camelCaseIndex < this.fCamelCasePattern.length()) {
            return false;
        }
        if (lastUpperCase == name.length() - 1) {
            return this.fCamelCaseTailMatcher == null;
        }
        if (this.fCamelCaseTailMatcher == null) {
            return true;
        }
        return this.fCamelCaseTailMatcher.match(name.substring(lastUpperCase + 1));
    }

    private boolean matchesName(TypeInfo type) {
        return this.fNameMatcher.match(type.getTypeName());
    }

    private boolean matchesPackage(TypeInfo type) {
        if (this.fPackageMatcher == null) {
            return true;
        }
        return this.fPackageMatcher.match(type.getTypeContainerName());
    }

    private void createNamePattern(String text) {
        int length = text.length();
        this.fCamelCasePattern = null;
        this.fNamePattern = text;
        if (length > 0) {
            char c = text.charAt(0);
            if (length > 1 && Character.isUpperCase(c)) {
                StringBuffer patternBuffer = new StringBuffer();
                StringBuffer camelCaseBuffer = new StringBuffer();
                patternBuffer.append(c);
                camelCaseBuffer.append(c);
                int index = 1;
                while (index < length) {
                    c = text.charAt(index);
                    if (!Character.isUpperCase(c)) break;
                    patternBuffer.append("*");
                    patternBuffer.append(c);
                    camelCaseBuffer.append(c);
                    ++index;
                }
                if (camelCaseBuffer.length() > 1) {
                    if (index == length) {
                        this.fNamePattern = patternBuffer.toString();
                        this.fCamelCasePattern = camelCaseBuffer.toString();
                    } else if (this.restIsLowerCase(text, index)) {
                        this.fNamePattern = patternBuffer.toString();
                        this.fCamelCasePattern = camelCaseBuffer.toString();
                        this.fCamelCaseTailMatcher = new StringMatcher(TypeInfoFilter.createTextPatternFromText(text.substring(index)), true, false);
                    }
                }
            }
            this.fNamePattern = TypeInfoFilter.createTextPatternFromText(this.fNamePattern);
        }
    }

    private boolean restIsLowerCase(String s, int start) {
        int i = start;
        while (i < s.length()) {
            if (Character.isUpperCase(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String createTextPatternFromText(String text) {
        int length = text.length();
        String result = text;
        switch (text.charAt(length - 1)) {
            case '<': {
                return text.substring(0, length - 1);
            }
            case '*': {
                return result;
            }
            case ' ': {
                return text.trim();
            }
        }
        return String.valueOf(text) + '*';
    }

    private boolean matchesScope(TypeInfo type) {
        if (this.fIsWorkspaceScope) {
            return true;
        }
        return type.isEnclosed(this.fSearchScope);
    }

    private boolean matchesModifiers(TypeInfo type) {
        if (this.fElementKind == 0) {
            return true;
        }
        int modifiers = type.getModifiers() & 0x6200;
        switch (this.fElementKind) {
            case 5: {
                return modifiers == 0;
            }
            case 8: {
                return Flags.isAnnotation((int)modifiers);
            }
            case 6: {
                return Flags.isInterface((int)modifiers);
            }
            case 7: {
                return Flags.isEnum((int)modifiers);
            }
            case 10: {
                return modifiers == 0 || Flags.isInterface((int)modifiers);
            }
            case 9: {
                return modifiers == 0 || Flags.isEnum((int)modifiers);
            }
        }
        return false;
    }
}

