/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class SuperTypesOfSingleton
extends TypeSet {
    private TType fLowerBound;
    private EnumeratedTypeSet fEnumCache = null;

    SuperTypesOfSingleton(TType t, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        this.fLowerBound = t;
    }

    public boolean isUniverse() {
        return false;
    }

    public TypeSet makeClone() {
        return this;
    }

    protected TypeSet specialCasesIntersectedWith(TypeSet other) {
        if (other.isSingleton() && other.anyMember().equals(this.fLowerBound)) {
            return other;
        }
        if (other instanceof SuperTypesOfSingleton) {
            SuperTypesOfSingleton otherSuper = (SuperTypesOfSingleton)other;
            if (TTypes.canAssignTo(otherSuper.fLowerBound, this.fLowerBound)) {
                return this;
            }
            if (TTypes.canAssignTo(this.fLowerBound, otherSuper.fLowerBound)) {
                return otherSuper;
            }
        } else if (other.hasUniqueUpperBound()) {
            TType otherUpper = other.uniqueUpperBound();
            if (otherUpper.equals(this.fLowerBound)) {
                return new SingletonTypeSet(this.fLowerBound, this.getTypeSetEnvironment());
            }
            if (otherUpper != this.fLowerBound && TTypes.canAssignTo(otherUpper, this.fLowerBound) || !TTypes.canAssignTo(this.fLowerBound, otherUpper)) {
                return this.getTypeSetEnvironment().getEmptyTypeSet();
            }
        }
        return null;
    }

    public boolean isEmpty() {
        return false;
    }

    public TypeSet upperBound() {
        return new SingletonTypeSet(this.getJavaLangObject(), this.getTypeSetEnvironment());
    }

    public TypeSet lowerBound() {
        return new SingletonTypeSet(this.fLowerBound, this.getTypeSetEnvironment());
    }

    public boolean hasUniqueLowerBound() {
        return true;
    }

    public boolean hasUniqueUpperBound() {
        return true;
    }

    public TType uniqueLowerBound() {
        return this.fLowerBound;
    }

    public TType uniqueUpperBound() {
        return this.getJavaLangObject();
    }

    public TypeSet superTypes() {
        return this;
    }

    public boolean contains(TType t) {
        if (t.equals(this.fLowerBound)) {
            return true;
        }
        if (t.equals(this.getJavaLangObject())) {
            return true;
        }
        return TTypes.canAssignTo(this.fLowerBound, t);
    }

    public boolean containsAll(TypeSet other) {
        if (other instanceof SuperTypesOfSingleton) {
            SuperTypesOfSingleton otherSuper = (SuperTypesOfSingleton)other;
            return TTypes.canAssignTo(this.fLowerBound, otherSuper.fLowerBound);
        }
        if (other instanceof SuperTypesSet) {
            SuperTypesSet otherSuper = (SuperTypesSet)other;
            TypeSet otherLowerBounds = otherSuper.lowerBound();
            Iterator iter = otherLowerBounds.iterator();
            while (iter.hasNext()) {
                TType t = (TType)iter.next();
                if (TTypes.canAssignTo(this.fLowerBound, t)) continue;
                return false;
            }
            return true;
        }
        Iterator iter = other.iterator();
        while (iter.hasNext()) {
            TType t = (TType)iter.next();
            if (TTypes.canAssignTo(this.fLowerBound, t)) continue;
            return false;
        }
        return true;
    }

    public Iterator iterator() {
        return this.enumerate().iterator();
    }

    public boolean isSingleton() {
        return this.fLowerBound.equals(this.getJavaLangObject());
    }

    public TType anyMember() {
        return this.fLowerBound;
    }

    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            if (this.fLowerBound instanceof ArrayType) {
                ArrayType at = (ArrayType)this.fLowerBound;
                this.fEnumCache = EnumeratedTypeSet.makeArrayTypesForElements(TTypes.getAllSuperTypesIterator(at.getComponentType()), this.getTypeSetEnvironment());
                this.fEnumCache.add(this.getJavaLangObject());
            } else {
                this.fEnumCache = new EnumeratedTypeSet(TTypes.getAllSuperTypesIterator(this.fLowerBound), this.getTypeSetEnvironment());
            }
            this.fEnumCache.add(this.fLowerBound);
            this.fEnumCache.initComplete();
        }
        return this.fEnumCache;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SuperTypesOfSingleton)) {
            return false;
        }
        SuperTypesOfSingleton other = (SuperTypesOfSingleton)o;
        return other.fLowerBound.equals(this.fLowerBound);
    }

    public String toString() {
        return "<" + this.fID + ": superTypes(" + this.fLowerBound.getPrettySignature() + ")>";
    }
}

