/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public class RippleMethodFinder {
    private RippleMethodFinder() {
    }

    public static IMethod[] getRelatedMethods(IMethod method, IProgressMonitor pm, WorkingCopyOwner owner) throws JavaModelException {
        block3: {
            IMethod[] iMethodArray;
            try {
                if (MethodChecks.isVirtual(method) || method.getDeclaringType().isInterface()) break block3;
                iMethodArray = new IMethod[]{method};
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return iMethodArray;
        }
        IMethod[] iMethodArray = RippleMethodFinder.getAllRippleMethods(method, pm, owner);
        Object var3_6 = null;
        pm.done();
        return iMethodArray;
    }

    private static IMethod[] getAllRippleMethods(IMethod method, IProgressMonitor pm, WorkingCopyOwner owner) throws JavaModelException {
        pm.beginTask("", 4);
        HashSet<IMethod> result = new HashSet<IMethod>();
        HashSet<IType> visitedTypes = new HashSet<IType>();
        ArrayList<IMethod> methodQueue = new ArrayList<IMethod>();
        HashSet hierarchies = new HashSet();
        methodQueue.add(method);
        while (!methodQueue.isEmpty()) {
            IMethod m = (IMethod)methodQueue.remove(0);
            if (m.isBinary()) continue;
            IType type = m.getDeclaringType();
            Assert.isTrue(!visitedTypes.contains(type), "! visitedTypes.contains(type)");
            Assert.isTrue(type.isInterface() || RippleMethodFinder.declaresAsVirtual(type, method), "second condition");
            visitedTypes.add(type);
            result.add(m);
            IType[] subTypes = RippleMethodFinder.getAllSubtypes(pm, owner, type, hierarchies);
            int i = 0;
            while (i < subTypes.length) {
                IMethod subTypeMethod;
                if (!visitedTypes.contains(subTypes[i]) && (subTypeMethod = Checks.findSimilarMethod(m, subTypes[i])) != null) {
                    result.add(subTypeMethod);
                }
                ++i;
            }
            i = 0;
            while (i < subTypes.length) {
                IMethod toAdd = RippleMethodFinder.findAppropriateMethod(owner, visitedTypes, methodQueue, subTypes[i], method, (IProgressMonitor)new NullProgressMonitor());
                if (toAdd != null) {
                    methodQueue.add(toAdd);
                }
                ++i;
            }
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return result.toArray(new IMethod[result.size()]);
    }

    private static IType[] getAllSubtypes(IProgressMonitor pm, WorkingCopyOwner owner, IType type, Set cachedHierarchies) throws JavaModelException {
        ITypeHierarchy hierarchy;
        Iterator iter = cachedHierarchies.iterator();
        while (iter.hasNext()) {
            hierarchy = (ITypeHierarchy)iter.next();
            if (!hierarchy.contains(type)) continue;
            return hierarchy.getAllSubtypes(type);
        }
        SubProgressMonitor subPm = new SubProgressMonitor(pm, 1);
        hierarchy = RippleMethodFinder.newTypeHierarchy(type, owner, (IProgressMonitor)subPm);
        cachedHierarchies.add(hierarchy);
        return hierarchy.getAllSubtypes(type);
    }

    private static IMethod findAppropriateMethod(WorkingCopyOwner owner, Set visitedTypes, List methodQueue, IType type, IMethod method, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.RippleMethodFinder_analizing_hierarchy, 1);
        IType[] superTypes = RippleMethodFinder.newSupertypeHierarchy(type, owner, (IProgressMonitor)new SubProgressMonitor(pm, 1)).getAllSupertypes(type);
        int i = 0;
        while (i < superTypes.length) {
            IMethod found;
            IType t = superTypes[i];
            if (!visitedTypes.contains(t) && (found = Checks.findSimilarMethod(method, t)) != null && RippleMethodFinder.declaresAsVirtual(t, method) && !methodQueue.contains(found)) {
                return RippleMethodFinder.getTopMostMethod(owner, visitedTypes, methodQueue, method, t, (IProgressMonitor)new NullProgressMonitor());
            }
            ++i;
        }
        return null;
    }

    private static IMethod getTopMostMethod(WorkingCopyOwner owner, Set visitedTypes, List methodQueue, IMethod method, IType type, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 1);
        IMethod methodInThisType = Checks.findSimilarMethod(method, type);
        Assert.isTrue(methodInThisType != null);
        IType[] superTypes = RippleMethodFinder.newSupertypeHierarchy(type, owner, (IProgressMonitor)new SubProgressMonitor(pm, 1)).getAllSupertypes(type);
        int i = 0;
        while (i < superTypes.length) {
            IMethod found;
            IType t = superTypes[i];
            if (!visitedTypes.contains(t) && (found = Checks.findSimilarMethod(method, t)) != null && RippleMethodFinder.declaresAsVirtual(t, method) && !methodQueue.contains(found)) {
                return RippleMethodFinder.getTopMostMethod(owner, visitedTypes, methodQueue, method, t, (IProgressMonitor)new NullProgressMonitor());
            }
            ++i;
        }
        return methodInThisType;
    }

    private static boolean declaresAsVirtual(IType type, IMethod m) throws JavaModelException {
        IMethod found = Checks.findSimilarMethod(m, type);
        if (found == null) {
            return false;
        }
        if (JdtFlags.isStatic((IMember)found)) {
            return false;
        }
        return !JdtFlags.isPrivate((IMember)found);
    }

    private static ITypeHierarchy newTypeHierarchy(IType type, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaModelException {
        if (owner == null) {
            return type.newTypeHierarchy(pm);
        }
        return type.newTypeHierarchy(owner, pm);
    }

    private static ITypeHierarchy newSupertypeHierarchy(IType type, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaModelException {
        if (owner == null) {
            return type.newSupertypeHierarchy(pm);
        }
        return type.newSupertypeHierarchy(owner, pm);
    }
}

