/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodOccurenceCollector;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class RenameMethodProcessor
extends JavaRenameProcessor
implements IReferenceUpdating {
    private SearchResultGroup[] fOccurrences;
    private boolean fUpdateReferences;
    private IMethod fMethod;
    private Set fMethodsToRename;
    private TextChangeManager fChangeManager;
    private WorkingCopyOwner fWorkingCopyOwner;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameMethodProcessor";
    static /* synthetic */ Class class$0;

    public RenameMethodProcessor(IMethod method) {
        this.initialize(method);
    }

    protected void initialize(IMethod method) {
        this.fMethod = method;
        this.setNewElementName(this.fMethod.getElementName());
        this.fUpdateReferences = true;
        this.fWorkingCopyOwner = new WorkingCopyOwner(){};
    }

    protected void setData(RenameMethodProcessor other) {
        this.fUpdateReferences = other.fUpdateReferences;
        this.setNewElementName(other.getNewElementName());
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fMethod);
    }

    public String getProcessorName() {
        return Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_name, new String[]{this.fMethod.getElementName(), this.getNewElementName()});
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fMethod);
    }

    public Object[] getElements() {
        return new Object[]{this.fMethod};
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
        HashSet derived = new HashSet(this.fMethodsToRename);
        derived.remove(this.fMethod);
        this.loadDerivedParticipants(status, result, derived.toArray(), new RenameArguments(this.getNewElementName(), this.getUpdateReferences()), null, natures, shared);
    }

    public final String getCurrentElementName() {
        return this.fMethod.getElementName();
    }

    public final RefactoringStatus checkNewElementName(String newName) {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = Checks.checkMethodName(newName);
        if (Checks.isAlreadyNamed((IJavaElement)this.fMethod, newName)) {
            result.addFatalError(RefactoringCoreMessages.RenameMethodRefactoring_same_name);
        }
        return result;
    }

    public Object getNewElement() {
        return this.fMethod.getDeclaringType().getMethod(this.getNewElementName(), this.fMethod.getParameterTypes());
    }

    public final IMethod getMethod() {
        return this.fMethod;
    }

    private void initializeMethodsToRename(IProgressMonitor pm) throws CoreException {
        this.fMethodsToRename = new HashSet<IMethod>(Arrays.asList(RippleMethodFinder2.getRelatedMethods(this.fMethod, pm, null)));
    }

    protected Set getMethodsToRename() {
        return this.fMethodsToRename;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public final void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fMethod == null || !this.fMethod.exists()) {
            String message = Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_deleted, this.fMethod.getCompilationUnit().getElementName());
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        RefactoringStatus result = Checks.checkAvailability((IJavaElement)this.fMethod);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
        if (JdtFlags.isNative((IMember)this.fMethod)) {
            result.addError(RefactoringCoreMessages.RenameMethodRefactoring_no_native);
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        Class<?> clazz;
        boolean mustAnalyzeShadowing;
        RefactoringStatus result;
        block15: {
            block14: {
                block13: {
                    RefactoringStatus refactoringStatus;
                    try {
                        result = new RefactoringStatus();
                        pm.beginTask("", 9);
                        if (Checks.isAvailable((IJavaElement)this.fMethod)) break block13;
                        result.addFatalError(RefactoringCoreMessages.RenameMethodProcessor_is_binary, JavaStatusContext.create((IMember)this.fMethod));
                        refactoringStatus = result;
                        Object var8_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        pm.done();
                        throw throwable;
                    }
                    pm.done();
                    return refactoringStatus;
                }
                result.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
                if (!result.hasFatalError()) break block14;
                RefactoringStatus refactoringStatus = result;
                Object var8_9 = null;
                pm.done();
                return refactoringStatus;
            }
            pm.setTaskName(RefactoringCoreMessages.RenameMethodRefactoring_taskName_checkingPreconditions);
            result.merge(this.checkNewElementName(this.getNewElementName()));
            IMethod[] newNameMethods = this.searchForDeclarationsOfClashingMethods((IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (newNameMethods.length == 0) {
                mustAnalyzeShadowing = false;
                pm.worked(1);
            } else {
                boolean hasOldRefsInInnerTypes;
                IType[] outerTypes = this.searchForOuterTypesOfReferences(newNameMethods, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                mustAnalyzeShadowing = outerTypes.length > 0 ? true : (hasOldRefsInInnerTypes = true);
            }
            this.initializeMethodsToRename((IProgressMonitor)new SubProgressMonitor(pm, 1));
            pm.setTaskName(RefactoringCoreMessages.RenameMethodRefactoring_taskName_searchingForReferences);
            this.fOccurrences = this.getOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 3), result);
            pm.setTaskName(RefactoringCoreMessages.RenameMethodRefactoring_taskName_checkingPreconditions);
            if (this.fUpdateReferences) {
                result.merge(this.checkRelatedMethods());
            }
            result.merge(this.analyzeCompilationUnits());
            pm.worked(1);
            if (!result.hasFatalError()) break block15;
            RefactoringStatus refactoringStatus = result;
            Object var8_10 = null;
            pm.done();
            return refactoringStatus;
        }
        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        if (this.fUpdateReferences & mustAnalyzeShadowing) {
            result.merge(this.analyzeRenameChanges((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        } else {
            pm.worked(1);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValidateEditChecker checker = (ValidateEditChecker)context.getChecker((Class)clazz);
        checker.addFiles(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()));
        RefactoringStatus refactoringStatus = result;
        Object var8_11 = null;
        pm.done();
        return refactoringStatus;
    }

    private IType[] searchForOuterTypesOfReferences(IMethod[] newNameMethods, IProgressMonitor pm) throws CoreException {
        final HashSet outerTypesOfReferences = new HashSet();
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])newNameMethods, 2);
        IJavaSearchScope scope = RenameMethodProcessor.createRefactoringScope(this.getMethod());
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IMember member = (IMember)match.getElement();
                IType declaring = member.getDeclaringType();
                if (declaring == null) {
                    return;
                }
                IType outer = declaring.getDeclaringType();
                if (outer != null) {
                    outerTypesOfReferences.add(declaring);
                }
            }
        };
        new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, requestor, pm);
        return outerTypesOfReferences.toArray(new IType[outerTypesOfReferences.size()]);
    }

    private IMethod[] searchForDeclarationsOfClashingMethods(IProgressMonitor pm) throws CoreException {
        final ArrayList results = new ArrayList();
        SearchPattern pattern = this.createNewMethodPattern();
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.getMethod().getJavaProject());
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object method = match.getElement();
                if (method instanceof IMethod) {
                    results.add(method);
                } else {
                    JavaPlugin.logErrorMessage("Unexpected element in search match: " + match.toString());
                }
            }
        };
        new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, requestor, pm);
        return results.toArray(new IMethod[results.size()]);
    }

    private SearchPattern createNewMethodPattern() throws JavaModelException {
        StringBuffer stringPattern = new StringBuffer(this.getNewElementName()).append('(');
        int paramCount = this.getMethod().getParameterNames().length;
        while (paramCount > 1) {
            stringPattern.append("*,");
            --paramCount;
        }
        if (paramCount > 0) {
            stringPattern.append('*');
        }
        stringPattern.append(')');
        return SearchPattern.createPattern((String)stringPattern.toString(), (int)1, (int)0, (int)24);
    }

    protected final IJavaSearchScope createRefactoringScope() throws CoreException {
        return RenameMethodProcessor.createRefactoringScope(this.fMethod);
    }

    protected static final IJavaSearchScope createRefactoringScope(IMethod method) throws CoreException {
        return RefactoringScopeFactory.create((IJavaElement)method);
    }

    SearchPattern createOccurrenceSearchPattern() {
        HashSet<IMethod> methods = new HashSet<IMethod>(this.fMethodsToRename);
        methods.add(this.fMethod);
        IMethod[] ms = methods.toArray(new IMethod[methods.size()]);
        return RefactoringSearchEngine.createOrPattern((IJavaElement[])ms, 3);
    }

    SearchResultGroup[] getOccurrences() {
        return this.fOccurrences;
    }

    protected SearchResultGroup[] getOccurrences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        SearchPattern pattern = this.createOccurrenceSearchPattern();
        return RefactoringSearchEngine.search(pattern, this.createRefactoringScope(), new MethodOccurenceCollector(this.getMethod().getElementName()), pm, status);
    }

    private RefactoringStatus checkRelatedMethods() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        Iterator iter = this.fMethodsToRename.iterator();
        while (iter.hasNext()) {
            IMethod method = (IMethod)iter.next();
            result.merge(Checks.checkIfConstructorName(method, this.getNewElementName(), method.getDeclaringType().getElementName()));
            Object[] msgData = new String[]{method.getElementName(), JavaModelUtil.getFullyQualifiedName(method.getDeclaringType())};
            if (!method.exists()) {
                result.addFatalError(Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_not_in_model, msgData));
                continue;
            }
            if (method.isBinary()) {
                result.addFatalError(Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_no_binary, msgData));
            }
            if (method.isReadOnly()) {
                result.addFatalError(Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_no_read_only, msgData));
            }
            if (!JdtFlags.isNative((IMember)method)) continue;
            result.addError(Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_no_native_1, msgData));
        }
        return result;
    }

    private RefactoringStatus analyzeCompilationUnits() throws CoreException {
        if (this.fOccurrences.length == 0) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        this.fOccurrences = Checks.excludeCompilationUnits(this.fOccurrences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fOccurrences));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus analyzeRenameChanges(IProgressMonitor pm) throws CoreException {
        int i3;
        Throwable throwable2;
        ICompilationUnit[] newDeclarationWCs;
        block9: {
            RefactoringStatus refactoringStatus;
            newDeclarationWCs = null;
            try {
                pm.beginTask("", 4);
                RefactoringStatus result = new RefactoringStatus();
                ICompilationUnit[] declarationCUs = this.getDeclarationCUs();
                newDeclarationWCs = RenameAnalyzeUtil.createNewWorkingCopies(declarationCUs, this.fChangeManager, this.fWorkingCopyOwner, new SubProgressMonitor(pm, 1));
                IMethod[] newMethods = new IMethod[this.fMethodsToRename.size()];
                int i2 = 0;
                Iterator iter = this.fMethodsToRename.iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        SearchResultGroup[] newOccurrences = this.batchFindNewOccurrences(newMethods, newDeclarationWCs, (IProgressMonitor)new SubProgressMonitor(pm, 3), result);
                        result.merge(RenameAnalyzeUtil.analyzeRenameChanges2(this.fChangeManager, this.fOccurrences, newOccurrences, this.getNewElementName()));
                        refactoringStatus = result;
                        Object var10_11 = null;
                        break;
                    }
                    IMethod method = (IMethod)iter.next();
                    ICompilationUnit newCu = RenameAnalyzeUtil.findWorkingCopyForCu(newDeclarationWCs, method.getCompilationUnit());
                    newMethods[i2] = this.getNewMethod(method, newCu);
                    ++i2;
                }
            }
            catch (Throwable throwable2) {
                Object var10_12 = null;
                pm.done();
                if (newDeclarationWCs == null) throw throwable2;
                i3 = 0;
                break block9;
            }
            pm.done();
            if (newDeclarationWCs == null) return refactoringStatus;
            int i3 = 0;
            while (true) {
                if (i3 >= newDeclarationWCs.length) {
                    return refactoringStatus;
                }
                newDeclarationWCs[i3].discardWorkingCopy();
                ++i3;
            }
        }
        while (true) {
            if (i3 >= newDeclarationWCs.length) {
                throw throwable2;
            }
            newDeclarationWCs[i3].discardWorkingCopy();
            ++i3;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SearchResultGroup[] batchFindNewOccurrences(IMethod[] newMethods, ICompilationUnit[] newDeclarationWCs, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 2);
        refsPattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])newMethods, 2);
        searchParticipants = SearchUtils.getDefaultSearchParticipants();
        scope = RefactoringScopeFactory.create((IMember[])newMethods);
        requestor = new MethodOccurenceCollector(this.getNewElementName());
        searchEngine = new SearchEngine(this.fWorkingCopyOwner);
        needWCs = new ArrayList<ICompilationUnit>();
        declaringCUs = new HashSet<ICompilationUnit>(newDeclarationWCs.length);
        i = 0;
        while (true) {
            if (i >= newDeclarationWCs.length) break;
            declaringCUs.add(newDeclarationWCs[i].getPrimary());
            ++i;
        }
        i = 0;
        while (true) {
            if (i >= this.fOccurrences.length) {
                otherWCs = null;
                ** try [egrp 0[TRYBLOCK] [0 : 160->223)] { 
lbl21:
                // 1 sources

                break;
            }
            cu = this.fOccurrences[i].getCompilationUnit();
            if (!declaringCUs.contains(cu)) {
                needWCs.add(cu);
            }
            ++i;
        }
        {
            otherWCs = RenameAnalyzeUtil.createNewWorkingCopies(needWCs.toArray(new ICompilationUnit[needWCs.size()]), this.fChangeManager, this.fWorkingCopyOwner, new SubProgressMonitor(pm, 1));
            searchEngine.search(refsPattern, searchParticipants, scope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            ** GOTO lbl-1000
        }
lbl31:
        // 1 sources

        catch (Throwable var14_15) {
            cu = null;
            pm.done();
            if (otherWCs == null) throw var14_15;
            i = 0;
        }
        while (i < otherWCs.length) {
            otherWCs[i].discardWorkingCopy();
            ++i;
        }
        throw var14_15;
lbl-1000:
        // 1 sources

        {
            cu = null;
        }
        pm.done();
        if (otherWCs == null) return RefactoringSearchEngine.groupByCu(requestor.getResults(), status);
        i = 0;
        while (i < otherWCs.length) {
            otherWCs[i].discardWorkingCopy();
            ++i;
        }
        return RefactoringSearchEngine.groupByCu(requestor.getResults(), status);
    }

    private ICompilationUnit[] getDeclarationCUs() {
        HashSet<ICompilationUnit> cus = new HashSet<ICompilationUnit>();
        Iterator iter = this.fMethodsToRename.iterator();
        while (iter.hasNext()) {
            IMethod method = (IMethod)iter.next();
            cus.add(method.getCompilationUnit());
        }
        return cus.toArray(new ICompilationUnit[cus.size()]);
    }

    private IMethod getNewMethod(IMethod method, ICompilationUnit newWorkingCopyOfDeclaringCu) throws CoreException {
        IType type = method.getDeclaringType();
        IType typeWc = (IType)JavaModelUtil.findInCompilationUnit(newWorkingCopyOfDeclaringCu, (IJavaElement)type);
        if (typeWc == null) {
            return null;
        }
        String[] paramTypeSignatures = method.getParameterTypes();
        return typeWc.getMethod(this.getNewElementName(), paramTypeSignatures);
    }

    private static IMethod[] classesDeclareMethodName(ITypeHierarchy hier, List classes, IMethod method, String newName) throws CoreException {
        HashSet<IMethod> result = new HashSet<IMethod>();
        IType type = method.getDeclaringType();
        List<IType> subtypes = Arrays.asList(hier.getAllSubtypes(type));
        int parameterCount = method.getParameterTypes().length;
        boolean isMethodPrivate = JdtFlags.isPrivate((IMember)method);
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            IType clazz = (IType)iter.next();
            IMethod[] methods = clazz.getMethods();
            boolean isSubclass = subtypes.contains(clazz);
            int j = 0;
            while (j < methods.length) {
                IMethod foundMethod = Checks.findMethod(newName, parameterCount, false, new IMethod[]{methods[j]});
                if (foundMethod != null) {
                    if (isSubclass || type.equals(clazz)) {
                        result.add(foundMethod);
                    } else if (!isMethodPrivate && !JdtFlags.isPrivate((IMember)methods[j])) {
                        result.add(foundMethod);
                    }
                }
                ++j;
            }
        }
        return result.toArray(new IMethod[result.size()]);
    }

    static final IMethod[] hierarchyDeclaresMethodName(IProgressMonitor pm, ITypeHierarchy hierarchy, IMethod method, String newName) throws CoreException {
        IType[] implementingClasses;
        IMethod[] foundInImplementingClasses;
        IMethod[] foundInHierarchyClasses;
        HashSet<IMethod> result = new HashSet<IMethod>();
        IType type = method.getDeclaringType();
        IMethod foundMethod = Checks.findMethod(newName, method.getParameterTypes().length, false, type);
        if (foundMethod != null) {
            result.add(foundMethod);
        }
        if ((foundInHierarchyClasses = RenameMethodProcessor.classesDeclareMethodName(hierarchy, Arrays.asList(hierarchy.getAllClasses()), method, newName)) != null) {
            result.addAll(Arrays.asList(foundInHierarchyClasses));
        }
        if ((foundInImplementingClasses = RenameMethodProcessor.classesDeclareMethodName(hierarchy, Arrays.asList(implementingClasses = hierarchy.getImplementingClasses(type)), method, newName)) != null) {
            result.addAll(Arrays.asList(foundInImplementingClasses));
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public final Change createChange(IProgressMonitor pm) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        try {
            dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.Change_javaChanges, (Change[])this.fChangeManager.getAllChanges());
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        TextChangeManager manager = new TextChangeManager(true);
        if (!this.fUpdateReferences) {
            this.addDeclarationUpdate(manager);
        } else {
            this.addOccurrences(manager, pm, status);
        }
        return manager;
    }

    void addOccurrences(TextChangeManager manager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", this.fOccurrences.length);
        int i = 0;
        while (i < this.fOccurrences.length) {
            ICompilationUnit cu = this.fOccurrences[i].getCompilationUnit();
            if (cu != null) {
                TextChange textChange = manager.get(cu);
                SearchMatch[] results = this.fOccurrences[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    String editName = RefactoringCoreMessages.RenameMethodRefactoring_update_occurrence;
                    ReplaceEdit replaceEdit = this.createReplaceEdit(results[j], cu);
                    TextChangeCompatibility.addTextEdit(textChange, editName, (TextEdit)replaceEdit);
                    ++j;
                }
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++i;
        }
        pm.done();
    }

    protected final ReplaceEdit createReplaceEdit(SearchMatch searchResult, ICompilationUnit cu) {
        if (searchResult.isImplicit()) {
            StringBuffer sb = new StringBuffer(this.getNewElementName());
            if ("insert".equals(cu.getJavaProject().getOption("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", true))) {
                sb.append(' ');
            }
            sb.append('=');
            if ("insert".equals(cu.getJavaProject().getOption("org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator", true))) {
                sb.append(' ');
            }
            return new ReplaceEdit(searchResult.getOffset(), 0, sb.toString());
        }
        return new ReplaceEdit(searchResult.getOffset(), searchResult.getLength(), this.getNewElementName());
    }

    private void addDeclarationUpdate(TextChangeManager manager) throws CoreException {
        ICompilationUnit cu = this.fMethod.getCompilationUnit();
        TextChange change = manager.get(cu);
        this.addDeclarationUpdate(change);
    }

    final void addDeclarationUpdate(TextChange change) throws CoreException {
        String editName = RefactoringCoreMessages.RenameMethodRefactoring_update_declaration;
        ISourceRange nameRange = this.fMethod.getNameRange();
        ReplaceEdit replaceEdit = new ReplaceEdit(nameRange.getOffset(), nameRange.getLength(), this.getNewElementName());
        TextChangeCompatibility.addTextEdit(change, editName, (TextEdit)replaceEdit);
    }
}

