/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.corext.util.Strings;

final class MethodOccurenceCollector
extends CollectingSearchRequestor {
    private final int fNameLength;

    public MethodOccurenceCollector(String methodName) {
        this.fNameLength = methodName.length();
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        int theDotIndex;
        ICompilationUnit unit = SearchUtils.getCompilationUnit(match);
        if (unit == null) {
            return;
        }
        int start = match.getOffset();
        int length = match.getLength();
        if (match.isImplicit()) {
            super.acceptSearchMatch(match);
            return;
        }
        String matchText = unit.getBuffer().getText(start, length);
        int leftBracketIndex = matchText.indexOf("(");
        if (leftBracketIndex != -1) {
            matchText = matchText.substring(0, leftBracketIndex);
        }
        if ((theDotIndex = matchText.lastIndexOf(".")) == -1) {
            match.setLength(this.fNameLength);
            super.acceptSearchMatch(match);
        } else {
            start = start + theDotIndex + 1;
            int i = theDotIndex + 1;
            while (i < matchText.length() && Strings.isIndentChar(matchText.charAt(i))) {
                ++start;
                ++i;
            }
            match.setOffset(start);
            match.setLength(this.fNameLength);
            super.acceptSearchMatch(match);
        }
    }
}

