/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassModifier;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class AccessorClassModifier {
    private CompilationUnit fRoot;
    private AST fAst;
    private ASTRewrite fASTRewrite;
    private ListRewrite fListRewrite;
    private ICompilationUnit fCU;

    private AccessorClassModifier(ICompilationUnit cu) throws CoreException {
        this.fCU = cu;
        this.fRoot = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)cu, ASTProvider.WAIT_YES, null);
        this.fAst = this.fRoot.getAST();
        this.fASTRewrite = ASTRewrite.create((AST)this.fAst);
        AbstractTypeDeclaration parent = null;
        if (this.fRoot.types().size() <= 0) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 10001, NLSMessages.AccessorClassModifier_missingType, null);
            throw new CoreException((IStatus)status);
        }
        parent = (AbstractTypeDeclaration)this.fRoot.types().get(0);
        this.fListRewrite = this.fASTRewrite.getListRewrite((ASTNode)parent, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TextEdit getTextEdit() throws CoreException {
        Document document = null;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = this.fCU.getPath();
        if (manager != null && path != null) {
            manager.connect(path, null);
            try {
                ITextFileBuffer buffer = manager.getTextFileBuffer(path);
                if (buffer != null) {
                    document = buffer.getDocument();
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                manager.disconnect(path, null);
                throw throwable;
            }
            {
                Object var5_7 = null;
            }
            manager.disconnect(path, null);
        }
        if (document == null) {
            document = new Document(this.fCU.getSource());
        }
        return this.fASTRewrite.rewriteAST((IDocument)document, this.fCU.getJavaProject().getOptions(true));
    }

    public static Change create(ICompilationUnit cu, NLSSubstitution[] subs) throws CoreException {
        AccessorClassModifier sourceModification = new AccessorClassModifier(cu);
        String message = Messages.format(NLSMessages.NLSSourceModifier_change_description, cu.getElementName());
        CompilationUnitChange change = new CompilationUnitChange(message, cu);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        int i = 0;
        while (i < subs.length) {
            NLSSubstitution substitution = subs[i];
            int newState = substitution.getState();
            if (substitution.hasStateChanged()) {
                if (newState == 0) {
                    if (substitution.getInitialState() == 2) {
                        sourceModification.addKey(substitution, (TextChange)change);
                    }
                } else if (newState == 2) {
                    if (substitution.getInitialState() == 0) {
                        sourceModification.removeKey(substitution, (TextChange)change);
                    }
                } else if (newState == 1 && substitution.getInitialState() == 0) {
                    sourceModification.removeKey(substitution, (TextChange)change);
                }
            } else if (newState == 0) {
                if (substitution.isKeyRename()) {
                    sourceModification.renameKey(substitution, (TextChange)change);
                }
                if (substitution.isAccessorRename()) {
                    sourceModification.replaceAccessor(substitution, (TextChange)change);
                }
            }
            ++i;
        }
        change.addEdit(sourceModification.getTextEdit());
        return change;
    }

    private void removeKey(NLSSubstitution sub, TextChange change) throws CoreException {
        ASTNode node = this.findField((ASTNode)this.fRoot, sub.getKey());
        if (node == null) {
            return;
        }
        String name = Messages.format(NLSMessages.AccessorClassModifier_remove_entry, sub.getKey());
        TextEditGroup editGroup = new TextEditGroup(name);
        this.fListRewrite.remove(node, editGroup);
        change.addTextEditGroup(editGroup);
    }

    private void renameKey(NLSSubstitution sub, TextChange change) throws CoreException {
        ASTNode node = this.findField((ASTNode)this.fRoot, sub.getInitialKey());
        if (node == null) {
            return;
        }
        FieldDeclaration fieldDeclaration = this.getNewFinalStringFieldDeclaration(sub.getKey());
        String name = Messages.format(NLSMessages.AccessorClassModifier_replace_entry, sub.getKey());
        TextEditGroup editGroup = new TextEditGroup(name);
        this.fListRewrite.replace(node, (ASTNode)fieldDeclaration, editGroup);
        change.addTextEditGroup(editGroup);
    }

    private ASTNode findField(ASTNode astRoot, final String name) {
        class STOP_VISITING
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            final /* synthetic */ AccessorClassModifier this$0;

            STOP_VISITING(AccessorClassModifier accessorClassModifier) {
                this.this$0 = accessorClassModifier;
            }
        }
        final ASTNode[] result = new ASTNode[1];
        try {
            astRoot.accept(new ASTVisitor(){

                public boolean visit(VariableDeclarationFragment node) {
                    if (name.equals(node.getName().getFullyQualifiedName())) {
                        result[0] = node.getParent();
                        throw new STOP_VISITING(AccessorClassModifier.this);
                    }
                    return true;
                }
            });
        }
        catch (STOP_VISITING sTOP_VISITING) {}
        return result[0];
    }

    private void addKey(NLSSubstitution sub, TextChange change) throws CoreException {
        if (this.fListRewrite == null) {
            return;
        }
        FieldDeclaration fieldDeclaration = this.getNewFinalStringFieldDeclaration(sub.getKey());
        String name = Messages.format(NLSMessages.AccessorClassModifier_add_entry, sub.getKey());
        TextEditGroup editGroup = new TextEditGroup(name);
        this.fListRewrite.insertLast((ASTNode)fieldDeclaration, editGroup);
        change.addTextEditGroup(editGroup);
    }

    private FieldDeclaration getNewFinalStringFieldDeclaration(String name) {
        VariableDeclarationFragment variableDeclarationFragment = this.fAst.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.fAst.newSimpleName(name));
        FieldDeclaration fieldDeclaration = this.fAst.newFieldDeclaration(variableDeclarationFragment);
        fieldDeclaration.setType((Type)this.fAst.newSimpleType((Name)this.fAst.newSimpleName("String")));
        fieldDeclaration.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        fieldDeclaration.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        return fieldDeclaration;
    }

    private void replaceAccessor(NLSSubstitution substitution, TextChange change) {
        AccessorClassReference accessorClassRef = substitution.getAccessorClassReference();
        if (accessorClassRef != null) {
            Region region = accessorClassRef.getRegion();
            int len = accessorClassRef.getName().length();
            Object[] args = new String[]{accessorClassRef.getName(), substitution.getUpdatedAccessor()};
            TextChangeCompatibility.addTextEdit(change, Messages.format(NLSMessages.NLSSourceModifier_replace_accessor, args), (TextEdit)new ReplaceEdit(region.getOffset(), len, substitution.getUpdatedAccessor()));
        }
    }
}

