/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.BodyUpdater;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;

public class IntroduceParameterRefactoring
extends Refactoring {
    private static final String[] KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is"};
    private ICompilationUnit fSourceCU;
    private int fSelectionStart;
    private int fSelectionLength;
    private IMethod fMethod;
    private ChangeSignatureRefactoring fChangeSignatureRefactoring;
    private ParameterInfo fParameter;
    private Expression fSelectedExpression;
    private String[] fExcludedParameterNames;
    static /* synthetic */ Class class$0;

    private IntroduceParameterRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength) {
        Assert.isTrue(cu != null && cu.exists());
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        this.fSourceCU = cu;
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
    }

    public static IntroduceParameterRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength) {
        return new IntroduceParameterRefactoring(cu, selectionStart, selectionLength);
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceParameterRefactoring_name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus refactoringStatus;
        block18: {
            RefactoringStatus refactoringStatus2;
            block17: {
                RefactoringStatus refactoringStatus3;
                block16: {
                    RefactoringStatus refactoringStatus4;
                    block15: {
                        RefactoringStatus refactoringStatus5;
                        block14: {
                            RefactoringStatus refactoringStatus6;
                            block13: {
                                RefactoringStatus refactoringStatus7;
                                block12: {
                                    RefactoringStatus refactoringStatus8;
                                    block11: {
                                        try {
                                            CompilationUnitRewrite cuRewrite;
                                            RefactoringStatus result;
                                            block20: {
                                                block19: {
                                                    pm.beginTask("", 7);
                                                    if (!this.fSourceCU.isStructureKnown()) {
                                                        refactoringStatus8 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_syntax_error);
                                                        Object var6_10 = null;
                                                        break block11;
                                                    }
                                                    IJavaElement enclosingElement = SelectionConverter.resolveEnclosingElement((IJavaElement)this.fSourceCU, (ITextSelection)new TextSelection(this.fSelectionStart, this.fSelectionLength));
                                                    if (!(enclosingElement instanceof IMethod)) {
                                                        refactoringStatus7 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
                                                        break block12;
                                                    }
                                                    this.fMethod = (IMethod)enclosingElement;
                                                    pm.worked(1);
                                                    this.fChangeSignatureRefactoring = ChangeSignatureRefactoring.create(this.fMethod);
                                                    if (this.fChangeSignatureRefactoring == null) {
                                                        refactoringStatus6 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
                                                        break block13;
                                                    }
                                                    this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
                                                    result = this.fChangeSignatureRefactoring.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 1));
                                                    if (!result.hasFatalError()) break block19;
                                                    RefactoringStatusEntry entry = result.getEntryMatchingSeverity(4);
                                                    if (entry.getCode() == 1 || entry.getCode() == 2) {
                                                        this.fChangeSignatureRefactoring = ChangeSignatureRefactoring.create((IMethod)entry.getData());
                                                        if (this.fChangeSignatureRefactoring == null) {
                                                            String msg = Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_cannot_introduce, entry.getMessage());
                                                            refactoringStatus5 = RefactoringStatus.createFatalErrorStatus((String)msg);
                                                            break block14;
                                                        }
                                                        result = this.fChangeSignatureRefactoring.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 1));
                                                        if (result.hasFatalError()) {
                                                            refactoringStatus4 = result;
                                                            break block15;
                                                        }
                                                        break block20;
                                                    } else {
                                                        refactoringStatus3 = result;
                                                        break block16;
                                                    }
                                                }
                                                pm.worked(1);
                                            }
                                            if (!(cuRewrite = this.fChangeSignatureRefactoring.getBaseCuRewrite()).getCu().equals(this.fSourceCU)) {
                                                cuRewrite = new CompilationUnitRewrite(this.fSourceCU);
                                            }
                                            this.initializeSelectedExpression(cuRewrite);
                                            pm.worked(1);
                                            result.merge(this.checkSelection(cuRewrite, (IProgressMonitor)new SubProgressMonitor(pm, 3)));
                                            if (result.hasFatalError()) {
                                                refactoringStatus2 = result;
                                                break block17;
                                            }
                                            this.initializeExcludedParameterNames(cuRewrite);
                                            this.addParameterInfo(cuRewrite);
                                            this.fChangeSignatureRefactoring.setBodyUpdater(new BodyUpdater(){

                                                public void updateBody(MethodDeclaration methodDeclaration, CompilationUnitRewrite rewrite, RefactoringStatus updaterResult) {
                                                    IntroduceParameterRefactoring.this.replaceSelectedExpression(rewrite);
                                                }
                                            });
                                            refactoringStatus = result;
                                            break block18;
                                        }
                                        catch (Throwable throwable) {
                                            Object var6_18 = null;
                                            pm.done();
                                            if (this.fChangeSignatureRefactoring == null) throw throwable;
                                            this.fChangeSignatureRefactoring.setValidationContext(null);
                                            throw throwable;
                                        }
                                    }
                                    pm.done();
                                    if (this.fChangeSignatureRefactoring == null) return refactoringStatus8;
                                    this.fChangeSignatureRefactoring.setValidationContext(null);
                                    return refactoringStatus8;
                                }
                                Object var6_11 = null;
                                pm.done();
                                if (this.fChangeSignatureRefactoring == null) return refactoringStatus7;
                                this.fChangeSignatureRefactoring.setValidationContext(null);
                                return refactoringStatus7;
                            }
                            Object var6_12 = null;
                            pm.done();
                            if (this.fChangeSignatureRefactoring == null) return refactoringStatus6;
                            this.fChangeSignatureRefactoring.setValidationContext(null);
                            return refactoringStatus6;
                        }
                        Object var6_13 = null;
                        pm.done();
                        if (this.fChangeSignatureRefactoring == null) return refactoringStatus5;
                        this.fChangeSignatureRefactoring.setValidationContext(null);
                        return refactoringStatus5;
                    }
                    Object var6_14 = null;
                    pm.done();
                    if (this.fChangeSignatureRefactoring == null) return refactoringStatus4;
                    this.fChangeSignatureRefactoring.setValidationContext(null);
                    return refactoringStatus4;
                }
                Object var6_15 = null;
                pm.done();
                if (this.fChangeSignatureRefactoring == null) return refactoringStatus3;
                this.fChangeSignatureRefactoring.setValidationContext(null);
                return refactoringStatus3;
            }
            Object var6_16 = null;
            pm.done();
            if (this.fChangeSignatureRefactoring == null) return refactoringStatus2;
            this.fChangeSignatureRefactoring.setValidationContext(null);
            return refactoringStatus2;
        }
        Object var6_17 = null;
        pm.done();
        if (this.fChangeSignatureRefactoring == null) return refactoringStatus;
        this.fChangeSignatureRefactoring.setValidationContext(null);
        return refactoringStatus;
    }

    private void addParameterInfo(CompilationUnitRewrite cuRewrite) throws JavaModelException {
        ITypeBinding typeBinding = Bindings.normalizeForDeclarationUse(this.fSelectedExpression.resolveTypeBinding(), this.fSelectedExpression.getAST());
        String typeName = cuRewrite.getImportRewrite().addImport(typeBinding);
        String name = this.guessedParameterName();
        this.fParameter = ParameterInfo.createInfoForAddedParameter(typeBinding, typeName, name);
        String defaultValue = this.fSourceCU.getBuffer().getText(this.fSelectedExpression.getStartPosition(), this.fSelectedExpression.getLength());
        this.fParameter.setDefaultValue(defaultValue);
        List parameterInfos = this.fChangeSignatureRefactoring.getParameterInfos();
        int parametersCount = parameterInfos.size();
        if (parametersCount > 0 && ((ParameterInfo)parameterInfos.get(parametersCount - 1)).isOldVarargs()) {
            parameterInfos.add(parametersCount - 1, this.fParameter);
        } else {
            parameterInfos.add(this.fParameter);
        }
    }

    private void replaceSelectedExpression(CompilationUnitRewrite cuRewrite) {
        if (!this.fSourceCU.equals(cuRewrite.getCu())) {
            return;
        }
        Expression expression = (Expression)NodeFinder.perform((ASTNode)cuRewrite.getRoot(), this.fSelectedExpression.getStartPosition(), this.fSelectedExpression.getLength());
        SimpleName newExpression = cuRewrite.getRoot().getAST().newSimpleName(this.fParameter.getNewName());
        String description = RefactoringCoreMessages.IntroduceParameterRefactoring_replace;
        cuRewrite.getASTRewrite().replace((ASTNode)expression, (ASTNode)newExpression, cuRewrite.createGroupDescription(description));
    }

    private void initializeSelectedExpression(CompilationUnitRewrite cuRewrite) throws JavaModelException {
        IASTFragment fragment = ASTFragmentFactory.createFragmentForSourceRange(new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)cuRewrite.getRoot(), cuRewrite.getCu());
        if (!(fragment instanceof IExpressionFragment)) {
            return;
        }
        Expression expression = ((IExpressionFragment)fragment).getAssociatedExpression();
        if (fragment.getStartPosition() != expression.getStartPosition() || fragment.getLength() != expression.getLength()) {
            return;
        }
        if (Checks.isInsideJavadoc((ASTNode)expression)) {
            return;
        }
        if (Checks.isEnumCase(expression.getParent())) {
            return;
        }
        this.fSelectedExpression = expression;
    }

    private RefactoringStatus checkSelection(CompilationUnitRewrite cuRewrite, IProgressMonitor pm) {
        MethodDeclaration methodDeclaration;
        if (this.fSelectedExpression == null) {
            String message = RefactoringCoreMessages.IntroduceParameterRefactoring_select;
            return CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, cuRewrite.getRoot(), message);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((methodDeclaration = (MethodDeclaration)ASTNodes.getParent((ASTNode)this.fSelectedExpression, clazz)) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
        }
        if (methodDeclaration.resolveBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_no_binding);
        }
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkExpression());
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(this.checkExpressionBinding());
        if (result.hasFatalError()) {
            return result;
        }
        return result;
    }

    private RefactoringStatus checkExpression() {
        Expression selectedExpression = this.fSelectedExpression;
        if (selectedExpression instanceof Name && selectedExpression.getParent() instanceof ClassInstanceCreation) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_name_in_new);
        }
        if (selectedExpression instanceof NullLiteral) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_null_literals);
        }
        if (selectedExpression instanceof ArrayInitializer) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_array_initializer);
        }
        if (selectedExpression instanceof Assignment) {
            if (selectedExpression.getParent() instanceof Expression) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_assignment);
            }
            return null;
        }
        if (selectedExpression instanceof ConditionalExpression) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_single_conditional_expression);
        }
        if (selectedExpression instanceof SimpleName) {
            if (((SimpleName)selectedExpression).isDeclaration()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_names_in_declarations);
            }
            if (selectedExpression.getParent() instanceof QualifiedName && selectedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || selectedExpression.getParent() instanceof FieldAccess && selectedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression);
            }
        }
        return null;
    }

    private RefactoringStatus checkExpressionBinding() {
        return this.checkExpressionFragmentIsRValue();
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() {
        switch (Checks.checkExpressionIsRValue(this.fSelectedExpression)) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.IntroduceParameterRefactoring_select, null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.IntroduceParameterRefactoring_no_void, null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue(false);
        return null;
    }

    public List getParameterInfos() {
        return this.fChangeSignatureRefactoring.getParameterInfos();
    }

    public ParameterInfo getAddedParameterInfo() {
        return this.fParameter;
    }

    public String getMethodSignaturePreview() throws JavaModelException {
        return this.fChangeSignatureRefactoring.getMethodSignaturePreview();
    }

    public void setParameterName(String name) {
        Assert.isNotNull(name);
        this.fParameter.setNewName(name);
    }

    public String guessedParameterName() {
        String[] proposals = this.guessParameterNames();
        if (proposals.length == 0) {
            return "";
        }
        return proposals[0];
    }

    public String[] guessParameterNames() {
        LinkedHashSet proposals = new LinkedHashSet();
        if (this.fSelectedExpression instanceof MethodInvocation) {
            proposals.addAll(this.guessTempNamesFromMethodInvocation((MethodInvocation)this.fSelectedExpression, this.fExcludedParameterNames));
        }
        proposals.addAll(this.guessTempNamesFromExpression(this.fSelectedExpression, this.fExcludedParameterNames));
        return proposals.toArray(new String[proposals.size()]);
    }

    private List guessTempNamesFromMethodInvocation(MethodInvocation selectedMethodInvocation, String[] excludedVariableNames) {
        String methodName = selectedMethodInvocation.getName().getIdentifier();
        int i = 0;
        while (i < KNOWN_METHOD_NAME_PREFIXES.length) {
            String prefix = KNOWN_METHOD_NAME_PREFIXES[i];
            if (methodName.startsWith(prefix)) {
                if (methodName.length() == prefix.length()) {
                    return Collections.EMPTY_LIST;
                }
                char firstAfterPrefix = methodName.charAt(prefix.length());
                if (Character.isUpperCase(firstAfterPrefix)) {
                    String proposal;
                    methodName = proposal = String.valueOf(Character.toLowerCase(firstAfterPrefix)) + methodName.substring(prefix.length() + 1);
                    break;
                }
            }
            ++i;
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(this.fSourceCU.getJavaProject(), methodName, 0, excludedVariableNames);
        return Arrays.asList(proposals);
    }

    private List guessTempNamesFromExpression(Expression selectedExpression, String[] excluded) {
        ITypeBinding expressionBinding = Bindings.normalizeForDeclarationUse(selectedExpression.resolveTypeBinding(), selectedExpression.getAST());
        String typeName = IntroduceParameterRefactoring.getQualifiedName(expressionBinding);
        if (typeName.length() == 0) {
            typeName = expressionBinding.getName();
        }
        if (typeName.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        int typeParamStart = typeName.indexOf("<");
        if (typeParamStart != -1) {
            typeName = typeName.substring(0, typeParamStart);
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(this.fSourceCU.getJavaProject(), typeName, expressionBinding.getDimensions(), excluded);
        return Arrays.asList(proposals);
    }

    private static String getQualifiedName(ITypeBinding typeBinding) {
        if (typeBinding.isAnonymous()) {
            return IntroduceParameterRefactoring.getQualifiedName(typeBinding.getSuperclass());
        }
        if (!typeBinding.isArray()) {
            return typeBinding.getQualifiedName();
        }
        return typeBinding.getElementType().getQualifiedName();
    }

    private void initializeExcludedParameterNames(CompilationUnitRewrite cuRewrite) {
        IBinding[] bindings = new ScopeAnalyzer(cuRewrite.getRoot()).getDeclarationsInScope(this.fSelectedExpression.getStartPosition(), 2);
        this.fExcludedParameterNames = new String[bindings.length];
        int i = 0;
        while (i < this.fExcludedParameterNames.length) {
            this.fExcludedParameterNames[i] = bindings[i].getName();
            ++i;
        }
    }

    public RefactoringStatus validateInput() {
        return this.fChangeSignatureRefactoring.checkSignature();
    }

    private RefactoringStatus checkExcludedParameterNames() {
        return new RefactoringStatus();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result;
        this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
        try {
            result = this.fChangeSignatureRefactoring.checkFinalConditions(pm);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fChangeSignatureRefactoring.setValidationContext(null);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fChangeSignatureRefactoring.setValidationContext(null);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        Change result;
        this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
        try {
            result = this.fChangeSignatureRefactoring.createChange(pm);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fChangeSignatureRefactoring.setValidationContext(null);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fChangeSignatureRefactoring.setValidationContext(null);
        return result;
    }
}

