/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.AddToClasspathChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class DeleteFromClasspathChange
extends JDTChange {
    private final String fProjectHandle;
    private final IPath fPathToDelete;
    private IPath fPath;
    private IPath fSourceAttachmentPath;
    private IPath fSourceAttachmentRootPath;
    private int fEntryKind;

    public DeleteFromClasspathChange(IPackageFragmentRoot root) {
        this(root.getPath(), root.getJavaProject());
    }

    DeleteFromClasspathChange(IPath pathToDelete, IJavaProject project) {
        Assert.isNotNull(pathToDelete);
        this.fPathToDelete = pathToDelete;
        this.fProjectHandle = project.getHandleIdentifier();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, 3);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        AddToClasspathChange addToClasspathChange;
        pm.beginTask(this.getName(), 1);
        try {
            IJavaProject project = this.getJavaProject();
            IClasspathEntry[] cp = project.getRawClasspath();
            IClasspathEntry[] newCp = new IClasspathEntry[cp.length - 1];
            int i = 0;
            int j = 0;
            while (j < newCp.length) {
                IClasspathEntry current = JavaCore.getResolvedClasspathEntry((IClasspathEntry)cp[i]);
                if (current != null && this.toBeDeleted(current)) {
                    ++i;
                    this.setDeletedEntryProperties(current);
                }
                newCp[j] = cp[i];
                ++i;
                ++j;
            }
            IClasspathEntry last = JavaCore.getResolvedClasspathEntry((IClasspathEntry)cp[cp.length - 1]);
            if (last != null && this.toBeDeleted(last)) {
                this.setDeletedEntryProperties(last);
            }
            project.setRawClasspath(newCp, pm);
            addToClasspathChange = new AddToClasspathChange(this.getJavaProject(), this.fEntryKind, this.fPath, this.fSourceAttachmentPath, this.fSourceAttachmentRootPath);
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return addToClasspathChange;
    }

    private boolean toBeDeleted(IClasspathEntry entry) {
        if (entry == null) {
            return false;
        }
        return this.fPathToDelete.equals((Object)entry.getPath());
    }

    private void setDeletedEntryProperties(IClasspathEntry entry) {
        this.fEntryKind = entry.getEntryKind();
        this.fPath = entry.getPath();
        this.fSourceAttachmentPath = entry.getSourceAttachmentPath();
        this.fSourceAttachmentRootPath = entry.getSourceAttachmentRootPath();
    }

    private IJavaProject getJavaProject() {
        return (IJavaProject)JavaCore.create((String)this.fProjectHandle);
    }

    public String getName() {
        return String.valueOf(RefactoringCoreMessages.DeleteFromClassPathChange_remove) + this.getJavaProject().getElementName();
    }

    public Object getModifiedElement() {
        return this.getJavaProject();
    }
}

