/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class Bindings {
    public static final String ARRAY_LENGTH_FIELD_BINDING_STRING = "(array type):length";
    private static final boolean CHECK_CORE_BINDING_IS_EQUAL_TO;
    private static final boolean CHECK_CORE_BINDING_GET_JAVA_ELEMENT;
    private static final boolean USE_UI_BINDING_GET_JAVA_ELEMENT;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/checkCoreBindingIsEqualTo");
        CHECK_CORE_BINDING_IS_EQUAL_TO = value != null && value.equalsIgnoreCase("true");
        value = Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/checkCoreBindingGetJavaElement");
        CHECK_CORE_BINDING_GET_JAVA_ELEMENT = value != null && value.equalsIgnoreCase("true");
        value = Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/useUIBindingGetJavaElement");
        USE_UI_BINDING_GET_JAVA_ELEMENT = value != null && value.equalsIgnoreCase("true");
    }

    private Bindings() {
    }

    public static boolean equals(IBinding b1, IBinding b2) {
        boolean originalEquals;
        boolean isEqualTo = b1.isEqualTo(b2);
        if (CHECK_CORE_BINDING_IS_EQUAL_TO && (originalEquals = Bindings.originalEquals(b1, b2)) != isEqualTo) {
            String message = "Unexpected difference between Bindings.equals(..) and IBinding#isEqualTo(..)";
            String detail = "\nb1 == " + b1.getKey() + ",\nb2 == " + (b2 == null ? "null binding" : b2.getKey());
            try {
                detail = String.valueOf(detail) + "\nb1.getJavaElement() == " + b1.getJavaElement() + ",\nb2.getJavaElement() == " + (b2 == null ? "null binding" : b2.getJavaElement().toString());
            }
            catch (Exception e) {
                detail = String.valueOf(detail) + "\nException in getJavaElement():\n" + e;
            }
            JavaPlugin.logRepeatedMessage(message, detail);
        }
        return isEqualTo;
    }

    private static boolean originalEquals(IBinding b1, IBinding b2) {
        Assert.isNotNull(b1);
        if (b1 == b2) {
            return true;
        }
        if (b2 == null) {
            return false;
        }
        String k1 = b1.getKey();
        String k2 = b2.getKey();
        if (k1 == null || k2 == null) {
            return false;
        }
        return k1.equals(k2);
    }

    public static boolean equals(IBinding[] b1, IBinding[] b2) {
        Assert.isNotNull(b1);
        if (b1 == b2) {
            return true;
        }
        if (b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        int i = 0;
        while (i < b1.length) {
            if (!Bindings.equals(b1[i], b2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int hashCode(IBinding binding) {
        Assert.isNotNull(binding);
        String key = binding.getKey();
        if (key == null) {
            return binding.hashCode();
        }
        return key.hashCode();
    }

    public static String asString(IBinding binding) {
        if (binding instanceof IMethodBinding) {
            return Bindings.asString((IMethodBinding)binding);
        }
        if (binding instanceof ITypeBinding) {
            return Bindings.asString((ITypeBinding)binding);
        }
        if (binding instanceof IVariableBinding) {
            return Bindings.asString((IVariableBinding)binding);
        }
        return binding.toString();
    }

    private static String asString(IVariableBinding variableBinding) {
        if (!variableBinding.isField()) {
            return variableBinding.toString();
        }
        if (variableBinding.getDeclaringClass() == null) {
            Assert.isTrue(variableBinding.getName().equals("length"));
            return ARRAY_LENGTH_FIELD_BINDING_STRING;
        }
        StringBuffer result = new StringBuffer();
        result.append(variableBinding.getDeclaringClass().getName());
        result.append(':');
        result.append(variableBinding.getName());
        return result.toString();
    }

    private static String asString(ITypeBinding type) {
        return type.getQualifiedName();
    }

    private static String asString(IMethodBinding method) {
        StringBuffer result = new StringBuffer();
        result.append(method.getDeclaringClass().getName());
        result.append(':');
        result.append(method.getName());
        result.append('(');
        ITypeBinding[] parameters = method.getParameterTypes();
        int lastComma = parameters.length - 1;
        int i = 0;
        while (i < parameters.length) {
            ITypeBinding parameter = parameters[i];
            result.append(parameter.getName());
            if (i < lastComma) {
                result.append(", ");
            }
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    public static String getTypeQualifiedName(ITypeBinding type) {
        ArrayList result = new ArrayList(5);
        Bindings.createName(type, false, result);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < result.size()) {
            if (i > 0) {
                buffer.append('.');
            }
            buffer.append((String)result.get(i));
            ++i;
        }
        return buffer.toString();
    }

    public static String getFullyQualifiedName(ITypeBinding type) {
        String name = type.getQualifiedName();
        int index = name.indexOf(60);
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    public static String getImportName(IBinding binding) {
        ITypeBinding declaring = null;
        switch (binding.getKind()) {
            case 2: {
                return Bindings.getRawQualifiedName((ITypeBinding)binding);
            }
            case 1: {
                return String.valueOf(binding.getName()) + ".*";
            }
            case 4: {
                declaring = ((IMethodBinding)binding).getDeclaringClass();
                break;
            }
            case 3: {
                declaring = ((IVariableBinding)binding).getDeclaringClass();
                break;
            }
            default: {
                return binding.getName();
            }
        }
        return JavaModelUtil.concatenateName(Bindings.getRawQualifiedName(declaring), binding.getName());
    }

    private static void createName(ITypeBinding type, boolean includePackage, List list) {
        ITypeBinding baseType = type;
        if (type.isArray()) {
            baseType = type.getElementType();
        }
        if (!baseType.isPrimitive() && !baseType.isNullType()) {
            ITypeBinding declaringType = baseType.getDeclaringClass();
            if (declaringType != null) {
                Bindings.createName(declaringType, includePackage, list);
            } else if (includePackage && !baseType.getPackage().isUnnamed()) {
                String[] components = baseType.getPackage().getNameComponents();
                int i = 0;
                while (i < components.length) {
                    list.add(components[i]);
                    ++i;
                }
            }
        }
        if (!baseType.isAnonymous()) {
            list.add(type.getName());
        } else {
            list.add("$local$");
        }
    }

    public static String[] getNameComponents(ITypeBinding type) {
        ArrayList result = new ArrayList(5);
        Bindings.createName(type, false, result);
        return result.toArray(new String[result.size()]);
    }

    public static String[] getAllNameComponents(ITypeBinding type) {
        ArrayList result = new ArrayList(5);
        Bindings.createName(type, true, result);
        return result.toArray(new String[result.size()]);
    }

    public static ITypeBinding getTopLevelType(ITypeBinding type) {
        ITypeBinding parent = type.getDeclaringClass();
        while (parent != null) {
            type = parent;
            parent = type.getDeclaringClass();
        }
        return type;
    }

    public static boolean isRuntimeException(ITypeBinding thrownException) {
        if (thrownException == null || thrownException.isPrimitive() || thrownException.isArray()) {
            return false;
        }
        return Bindings.findTypeInHierarchy(thrownException, "java.lang.RuntimeException") != null;
    }

    public static IVariableBinding findFieldInType(ITypeBinding type, String fieldName) {
        if (type.isPrimitive()) {
            return null;
        }
        IVariableBinding[] fields = type.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            IVariableBinding field = fields[i];
            if (field.getName().equals(fieldName)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodInType(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        if (type.isPrimitive()) {
            return null;
        }
        IMethodBinding[] methods = type.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (parameters == null ? methodName.equals(methods[i].getName()) : Bindings.isEqualMethod(methods[i], methodName, parameters)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodInType(ITypeBinding type, String methodName, String[] parameters) {
        if (type.isPrimitive()) {
            return null;
        }
        IMethodBinding[] methods = type.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (parameters == null ? methodName.equals(methods[i].getName()) : Bindings.isEqualMethod(methods[i], methodName, parameters)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findOverriddenMethodInType(ITypeBinding type, IMethodBinding method) {
        return Bindings.findMethodInType(type, method.getName(), method.getParameterTypes());
    }

    public static IVariableBinding findFieldInHierarchy(ITypeBinding type, String fieldName) {
        IVariableBinding field = Bindings.findFieldInType(type, fieldName);
        if (field != null) {
            return field;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (field = Bindings.findFieldInType(type, fieldName)) != null) {
            return field;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            field = Bindings.findFieldInType(type, fieldName);
            if (field != null) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodInHierarchy(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        IMethodBinding method = Bindings.findMethodInType(type, methodName, parameters);
        if (method != null) {
            return method;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (method = Bindings.findMethodInHierarchy(superClass, methodName, parameters)) != null) {
            return method;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            method = Bindings.findMethodInHierarchy(interfaces[i], methodName, parameters);
            if (method != null) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodInHierarchy(ITypeBinding typeObject, ITypeBinding type, String methodName, String[] parameters) {
        IMethodBinding method = Bindings.findMethodInType(type, methodName, parameters);
        if (method != null) {
            return method;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass == null && type.isInterface()) {
            superClass = typeObject;
        }
        if (superClass != null && (method = Bindings.findMethodInHierarchy(typeObject, superClass, methodName, parameters)) != null) {
            return method;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            method = Bindings.findMethodInHierarchy(typeObject, interfaces[i], methodName, parameters);
            if (method != null) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findOverriddenMethodInHierarchy(ITypeBinding type, IMethodBinding binding) {
        IMethodBinding method = Bindings.findOverriddenMethodInType(type, binding);
        if (method != null) {
            return method;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (method = Bindings.findOverriddenMethodInHierarchy(superClass, binding)) != null) {
            return method;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            method = Bindings.findOverriddenMethodInHierarchy(interfaces[i], binding);
            if (method != null) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodDefininition(IMethodBinding method, boolean testVisibility) {
        IMethodBinding res;
        int modifiers = method.getModifiers();
        if (Modifier.isPrivate((int)modifiers) || Modifier.isStatic((int)modifiers) || method.isConstructor()) {
            return null;
        }
        ITypeBinding type = method.getDeclaringClass();
        if (type.isInterface()) {
            return null;
        }
        if (!(type.getSuperclass() == null || (res = Bindings.findOverriddenMethodInHierarchy(type.getSuperclass(), method)) == null || Modifier.isPrivate((int)res.getModifiers()) || testVisibility && !Bindings.isVisibleInHierarchy(res, method.getDeclaringClass().getPackage()))) {
            return res;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            IMethodBinding res2 = Bindings.findOverriddenMethodInHierarchy(interfaces[i], method);
            if (res2 != null) {
                return res2;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodImplementation(IMethodBinding method, boolean testVisibility) {
        ITypeBinding superClass = method.getDeclaringClass().getSuperclass();
        String methodName = method.getName();
        ITypeBinding[] parameters = method.getParameterTypes();
        while (superClass != null) {
            IMethodBinding res = Bindings.findMethodInType(superClass, methodName, parameters);
            if (res != null) {
                if (Bindings.isVisibleInHierarchy(res, method.getDeclaringClass().getPackage())) {
                    return res;
                }
                return null;
            }
            superClass = superClass.getSuperclass();
        }
        return null;
    }

    public static boolean isVisibleInHierarchy(IMethodBinding member, IPackageBinding pack) {
        int otherflags = member.getModifiers();
        ITypeBinding declaringType = member.getDeclaringClass();
        if (Modifier.isPublic((int)otherflags) || Modifier.isProtected((int)otherflags) || declaringType != null && declaringType.isInterface()) {
            return true;
        }
        if (Modifier.isPrivate((int)otherflags)) {
            return false;
        }
        return pack == declaringType.getPackage();
    }

    public static IMethodBinding findDeclarationInHierarchy(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            ITypeBinding curr = interfaces[i];
            IMethodBinding method = Bindings.findMethodInType(curr, methodName, parameters);
            if (method != null) {
                return method;
            }
            method = Bindings.findDeclarationInHierarchy(interfaces[i], methodName, parameters);
            if (method != null) {
                return method;
            }
            ++i;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null) {
            IMethodBinding method = Bindings.findMethodInType(superClass, methodName, parameters);
            if (method != null) {
                return method;
            }
            method = Bindings.findDeclarationInHierarchy(superClass, methodName, parameters);
            if (method != null) {
                return method;
            }
        }
        return null;
    }

    public static ITypeBinding[] getAllSuperTypes(ITypeBinding type) {
        HashSet result = new HashSet();
        Bindings.collectSuperTypes(type, result);
        result.remove(type);
        return result.toArray(new ITypeBinding[result.size()]);
    }

    private static void collectSuperTypes(ITypeBinding curr, Set collection) {
        if (collection.add(curr)) {
            ITypeBinding[] interfaces = curr.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                Bindings.collectSuperTypes(interfaces[i], collection);
                ++i;
            }
            ITypeBinding superClass = curr.getSuperclass();
            if (superClass != null) {
                Bindings.collectSuperTypes(superClass, collection);
            }
        }
    }

    public static boolean visitHierarchy(ITypeBinding type, TypeBindingVisitor visitor) {
        boolean result = Bindings.visitSuperclasses(type, visitor);
        if (result) {
            result = Bindings.visitInterfaces(type, visitor);
        }
        return result;
    }

    public static boolean visitInterfaces(ITypeBinding type, TypeBindingVisitor visitor) {
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (!visitor.visit(interfaces[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean visitSuperclasses(ITypeBinding type, TypeBindingVisitor visitor) {
        while ((type = type.getSuperclass()) != null) {
            if (visitor.visit(type)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualMethod(IMethodBinding method, String methodName, ITypeBinding[] parameters) {
        if (!method.getName().equals(methodName)) {
            return false;
        }
        ITypeBinding[] methodParameters = method.getParameterTypes();
        if (methodParameters.length != parameters.length) {
            return false;
        }
        int i = 0;
        while (i < parameters.length) {
            if (!Bindings.equals((IBinding)methodParameters[i].getErasure(), (IBinding)parameters[i].getErasure())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEqualMethod(IMethodBinding method, String methodName, String[] parameters) {
        if (!method.getName().equals(methodName)) {
            return false;
        }
        ITypeBinding[] methodParameters = method.getParameterTypes();
        if (methodParameters.length != parameters.length) {
            return false;
        }
        int i = 0;
        while (i < parameters.length) {
            String second;
            String first = parameters[i];
            int index = first.indexOf(60);
            if (index > 0) {
                first = first.substring(0, index);
            }
            if ((index = (second = methodParameters[i].getErasure().getQualifiedName()).indexOf(60)) > 0) {
                second = second.substring(0, index);
            }
            if (!first.equals(second)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ITypeBinding findTypeInHierarchy(ITypeBinding hierarchyType, String fullyQualifiedTypeName) {
        ITypeBinding res;
        if (hierarchyType.isArray() || hierarchyType.isPrimitive()) {
            return null;
        }
        if (fullyQualifiedTypeName.equals(hierarchyType.getQualifiedName())) {
            return hierarchyType;
        }
        ITypeBinding superClass = hierarchyType.getSuperclass();
        if (superClass != null && (res = Bindings.findTypeInHierarchy(superClass, fullyQualifiedTypeName)) != null) {
            return res;
        }
        ITypeBinding[] superInterfaces = hierarchyType.getInterfaces();
        int i = 0;
        while (i < superInterfaces.length) {
            ITypeBinding res2 = Bindings.findTypeInHierarchy(superInterfaces[i], fullyQualifiedTypeName);
            if (res2 != null) {
                return res2;
            }
            ++i;
        }
        return null;
    }

    public static IVariableBinding getAssignedVariable(Assignment assignment) {
        Expression leftHand = assignment.getLeftHandSide();
        switch (leftHand.getNodeType()) {
            case 42: {
                return (IVariableBinding)((SimpleName)leftHand).resolveBinding();
            }
            case 40: {
                return (IVariableBinding)((QualifiedName)leftHand).getName().resolveBinding();
            }
            case 22: {
                return ((FieldAccess)leftHand).resolveFieldBinding();
            }
            case 47: {
                return ((SuperFieldAccess)leftHand).resolveFieldBinding();
            }
        }
        return null;
    }

    public static boolean isSuperType(ITypeBinding type, ITypeBinding candidate) {
        if (candidate.isArray() || candidate.isPrimitive()) {
            return false;
        }
        if (Bindings.equals((IBinding)candidate, (IBinding)type)) {
            return true;
        }
        ITypeBinding superClass = candidate.getSuperclass();
        if (superClass != null && Bindings.isSuperType(type, superClass)) {
            return true;
        }
        if (type.isInterface()) {
            ITypeBinding[] superInterfaces = candidate.getInterfaces();
            int i = 0;
            while (i < superInterfaces.length) {
                if (Bindings.isSuperType(type, superInterfaces[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static ICompilationUnit findCompilationUnit(ITypeBinding typeBinding, IJavaProject project) throws JavaModelException {
        ICompilationUnit coreFindCompilationUnit = Bindings.coreFindCompilationUnit(typeBinding);
        if (CHECK_CORE_BINDING_GET_JAVA_ELEMENT) {
            ICompilationUnit originalFindCompilationUnit = Bindings.originalFindCompilationUnit(typeBinding, project);
            if (coreFindCompilationUnit == null) {
                if (originalFindCompilationUnit != null) {
                    JavaPlugin.logRepeatedMessage("ITypeBinding#getJavaElement() is not supposed to be null: ", "typeBinding == " + typeBinding.getKey() + ", project == " + project.getElementName() + ", coreFindCompilationUnit == " + coreFindCompilationUnit + ", originalFindCompilationUnit == " + originalFindCompilationUnit);
                }
            } else if (!coreFindCompilationUnit.equals(originalFindCompilationUnit)) {
                JavaPlugin.logRepeatedMessage("ITypeBinding#getJavaElement() is not correct element: ", "typeBinding == " + typeBinding.getKey() + ", project == " + project.getElementName() + ", coreFindCompilationUnit == " + coreFindCompilationUnit + ", originalFindCompilationUnit == " + originalFindCompilationUnit);
            }
        }
        return coreFindCompilationUnit;
    }

    private static ICompilationUnit coreFindCompilationUnit(ITypeBinding typeBinding) {
        IJavaElement type = typeBinding.getJavaElement();
        if (type instanceof IType) {
            return ((IType)type).getCompilationUnit();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static ICompilationUnit originalFindCompilationUnit(ITypeBinding typeBinding, IJavaProject project) throws JavaModelException {
        if (typeBinding.isFromSource()) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            typeBinding = typeBinding.getDeclaringClass();
lbl4:
            // 2 sources

            ** while (typeBinding != null && !typeBinding.isTopLevel())
        }
lbl5:
        // 1 sources

        if (typeBinding != null && (type = project.findType(packageName = (pack = (typeBinding = typeBinding.getTypeDeclaration()).getPackage()).isUnnamed() != false ? "" : pack.getName(), typeBinding.getName())) != null) {
            return type.getCompilationUnit();
        }
        return null;
    }

    public static IField findField(IVariableBinding field, IJavaProject in) throws JavaModelException {
        Assert.isTrue(field.isField());
        IField iField = (IField)field.getJavaElement();
        if (CHECK_CORE_BINDING_GET_JAVA_ELEMENT) {
            IField originalFindField = Bindings.originalFindField(field, in);
            if (iField != null && !iField.equals(originalFindField) || iField == null && originalFindField != null) {
                JavaPlugin.logRepeatedMessage("IVariableBinding#getJavaElement() is not correct element: ", "field == " + field.getKey() + ", project == " + in.getElementName() + ", iField == " + iField + ", originalFindField == " + originalFindField);
            }
        }
        return iField;
    }

    private static IField originalFindField(IVariableBinding field, IJavaProject in) throws JavaModelException {
        ITypeBinding declaringClassBinding = field.getDeclaringClass();
        if (declaringClassBinding == null) {
            return null;
        }
        IType declaringClass = Bindings.findType(declaringClassBinding, in);
        if (declaringClass == null) {
            return null;
        }
        IField foundField = declaringClass.getField(field.getName());
        if (!foundField.exists()) {
            return null;
        }
        return foundField;
    }

    public static IType findType(ITypeBinding type, IJavaProject scope) throws JavaModelException {
        IType iType = (IType)type.getJavaElement();
        if (CHECK_CORE_BINDING_GET_JAVA_ELEMENT) {
            IType originalFindType = Bindings.originalFindType(type, scope);
            if (iType != null && !iType.equals(originalFindType) || iType == null && originalFindType != null) {
                JavaPlugin.logRepeatedMessage("ITypeBinding#getJavaElement() is not correct element: ", "type == " + type.getKey() + ", project == " + scope.getElementName() + ", iType == " + iType + ", originalFindType == " + originalFindType);
            }
        }
        return iType;
    }

    private static IType originalFindType(ITypeBinding type, IJavaProject scope) throws JavaModelException {
        if (type.isPrimitive() || type.isAnonymous() || type.isNullType()) {
            return null;
        }
        if (type.isArray()) {
            return Bindings.findType(type.getElementType(), scope);
        }
        String[] typeElements = Bindings.getNameComponents(type);
        IJavaElement element = scope.findElement(Bindings.getPathToCompilationUnit(type.getPackage(), typeElements[0]));
        IType candidate = null;
        if (element instanceof ICompilationUnit) {
            candidate = ((ICompilationUnit)element).getType(typeElements[0]);
        } else if (element instanceof IClassFile) {
            candidate = ((IClassFile)element).getType();
        } else if (element == null) {
            candidate = type.isMember() ? JavaModelUtil.findType(scope, Bindings.getFullyQualifiedName(type.getDeclaringClass())) : JavaModelUtil.findType(scope, Bindings.getFullyQualifiedName(type));
        }
        if (candidate == null || typeElements.length == 1) {
            return candidate;
        }
        return Bindings.findTypeInType(typeElements, candidate);
    }

    public static IMethod findMethod(IMethodBinding method, IJavaProject scope) throws JavaModelException {
        IMethod iMethod;
        if (!USE_UI_BINDING_GET_JAVA_ELEMENT) {
            IMethod iMethod2 = (IMethod)method.getJavaElement();
            if (CHECK_CORE_BINDING_GET_JAVA_ELEMENT) {
                IMethod originalFindMethod = Bindings.originalFindMethod(method, scope);
                if (iMethod2 != null && !iMethod2.equals(originalFindMethod) || iMethod2 == null && originalFindMethod != null) {
                    JavaPlugin.logRepeatedMessage("IMethodBinding#getJavaElement() is not correct element: ", "method == " + method.getKey() + ", project == " + scope.getElementName() + ", iMethod == " + iMethod2 + ", originalFindMethod == " + originalFindMethod);
                }
            }
            return iMethod2;
        }
        IMethod originalFindMethod = Bindings.originalFindMethod(method, scope);
        if (CHECK_CORE_BINDING_GET_JAVA_ELEMENT && ((iMethod = (IMethod)method.getJavaElement()) != null && !iMethod.equals(originalFindMethod) || iMethod == null && originalFindMethod != null)) {
            JavaPlugin.logRepeatedMessage("IMethodBinding#getJavaElement() is not correct element: ", "method == " + method.getKey() + ", project == " + scope.getElementName() + ", iMethod == " + iMethod + ", originalFindMethod == " + originalFindMethod);
        }
        return originalFindMethod;
    }

    private static IMethod originalFindMethod(IMethodBinding method, IJavaProject scope) throws JavaModelException {
        IType type = Bindings.findType(method.getDeclaringClass(), scope);
        if (type == null) {
            return null;
        }
        return Bindings.findMethod(method, type);
    }

    public static IMethod findMethod(IMethodBinding method, IType type) throws JavaModelException {
        method = method.getMethodDeclaration();
        IMethod[] candidates = type.getMethods();
        int i = 0;
        while (i < candidates.length) {
            IMethod candidate = candidates[i];
            if (candidate.getElementName().equals(method.getName()) && Bindings.sameParameters(method, candidate)) {
                return candidate;
            }
            ++i;
        }
        return null;
    }

    private static IPath getPathToCompilationUnit(IPackageBinding packageBinding, String topLevelTypeName) {
        Path result = Path.EMPTY;
        String[] packageNames = packageBinding.getNameComponents();
        int i = 0;
        while (i < packageNames.length) {
            result = result.append(packageNames[i]);
            ++i;
        }
        return result.append(String.valueOf(topLevelTypeName) + ".java");
    }

    private static IType findTypeInType(String[] typeElements, IType jmType) {
        IType result = jmType;
        int i = 1;
        while (i < typeElements.length) {
            if (!(result = result.getType(typeElements[i])).exists()) {
                return null;
            }
            ++i;
        }
        return result == jmType ? null : result;
    }

    private static boolean sameParameters(IMethodBinding method, IMethod candidate) throws JavaModelException {
        String[] candidateParameters;
        ITypeBinding[] methodParamters = method.getParameterTypes();
        if (methodParamters.length != (candidateParameters = candidate.getParameterTypes()).length) {
            return false;
        }
        IType scope = candidate.getDeclaringType();
        int i = 0;
        while (i < methodParamters.length) {
            ITypeBinding methodParameter = methodParamters[i];
            String candidateParameter = candidateParameters[i];
            if (!Bindings.sameParameter(methodParameter, candidateParameter, scope)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean sameParameter(ITypeBinding type, String candidate, IType scope) throws JavaModelException {
        if (type.getDimensions() != Signature.getArrayCount((String)candidate)) {
            return false;
        }
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (Bindings.isPrimitiveType(candidate = Signature.getElementType((String)candidate)) != type.isPrimitive()) {
            return false;
        }
        if (type.isPrimitive() || type.isTypeVariable()) {
            return type.getName().equals(Signature.toString((String)candidate));
        }
        candidate = Signature.getTypeErasure((String)candidate);
        type = type.getErasure();
        if (Bindings.isResolvedType(candidate)) {
            return Signature.toString((String)candidate).equals(Bindings.getFullyQualifiedName(type));
        }
        String[][] qualifiedCandidates = scope.resolveType(Signature.toString((String)candidate));
        if (qualifiedCandidates == null || qualifiedCandidates.length == 0) {
            return false;
        }
        String packageName = type.getPackage().isUnnamed() ? "" : type.getPackage().getName();
        String typeName = Bindings.getTypeQualifiedName(type);
        int i = 0;
        while (i < qualifiedCandidates.length) {
            String[] qualifiedCandidate = qualifiedCandidates[i];
            if (qualifiedCandidate[0].equals(packageName) && qualifiedCandidate[1].equals(typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isPrimitiveType(String s) {
        return Signature.getTypeSignatureKind((String)s) == 2;
    }

    private static boolean isResolvedType(String s) {
        int arrayCount = Signature.getArrayCount((String)s);
        return s.charAt(arrayCount) == 'L';
    }

    public static ITypeBinding normalizeTypeBinding(ITypeBinding binding) {
        if (binding != null && !binding.isNullType() && !Bindings.isVoidType(binding)) {
            if (binding.isAnonymous()) {
                ITypeBinding[] baseBindings = binding.getInterfaces();
                if (baseBindings.length > 0) {
                    return baseBindings[0];
                }
                return binding.getSuperclass();
            }
            if (binding.isCapture()) {
                return binding.getWildcard();
            }
            return binding;
        }
        return null;
    }

    public static boolean isVoidType(ITypeBinding binding) {
        return "void".equals(binding.getName());
    }

    public static ITypeBinding normalizeForDeclarationUse(ITypeBinding binding, AST ast) {
        if (binding.isNullType()) {
            return ast.resolveWellKnownType("java.lang.Object");
        }
        if (binding.isPrimitive()) {
            return binding;
        }
        if ((binding = Bindings.normalizeTypeBinding(binding)) == null || !binding.isWildcardType()) {
            return binding;
        }
        if (binding.isUpperbound()) {
            return binding.getBound();
        }
        return ast.resolveWellKnownType("java.lang.Object");
    }

    public static ITypeBinding getBindingOfParentType(ASTNode node) {
        while (node != null) {
            if (node instanceof AbstractTypeDeclaration) {
                return ((AbstractTypeDeclaration)node).resolveBinding();
            }
            if (node instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            node = node.getParent();
        }
        return null;
    }

    public static String getRawName(ITypeBinding binding) {
        int idx;
        String name = binding.getName();
        if ((binding.isParameterizedType() || binding.isGenericType()) && (idx = name.indexOf(60)) != -1) {
            return name.substring(0, idx);
        }
        return name;
    }

    public static String getRawQualifiedName(ITypeBinding binding) {
        if (binding.isAnonymous() || binding.isLocal()) {
            return "";
        }
        if (binding.isPrimitive() || binding.isNullType() || binding.isTypeVariable()) {
            return binding.getName();
        }
        if (binding.isArray()) {
            String elementTypeQualifiedName = Bindings.getRawQualifiedName(binding.getElementType());
            if (elementTypeQualifiedName.length() != 0) {
                StringBuffer stringBuffer = new StringBuffer(elementTypeQualifiedName);
                stringBuffer.append('[').append(']');
                return stringBuffer.toString();
            }
            return "";
        }
        if (binding.isMember()) {
            String outerName = Bindings.getRawQualifiedName(binding.getDeclaringClass());
            if (outerName.length() > 0) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(outerName);
                buffer.append('.');
                buffer.append(Bindings.getRawName(binding));
                return buffer.toString();
            }
            return "";
        }
        if (binding.isTopLevel()) {
            IPackageBinding packageBinding = binding.getPackage();
            StringBuffer buffer = new StringBuffer();
            if (packageBinding != null && packageBinding.getName().length() > 0) {
                buffer.append(packageBinding.getName()).append('.');
            }
            buffer.append(Bindings.getRawName(binding));
            return buffer.toString();
        }
        return "";
    }

    public static IVariableBinding getVariableDeclaration(IVariableBinding var) {
        ITypeBinding declaringClass = var.getDeclaringClass();
        if (declaringClass == null) {
            return var;
        }
        if (declaringClass.getTypeDeclaration() == declaringClass) {
            return var;
        }
        IVariableBinding[] genericFields = declaringClass.getTypeDeclaration().getDeclaredFields();
        String name = var.getName();
        int i = 0;
        while (i < genericFields.length) {
            if (name.equals(genericFields[i].getName())) {
                return genericFields[i];
            }
            ++i;
        }
        Assert.isTrue(false, "field does not exist in generic type");
        return var;
    }

    public static boolean isDeclarationBinding(IBinding binding) {
        switch (binding.getKind()) {
            case 2: {
                return ((ITypeBinding)binding).getTypeDeclaration() == binding;
            }
            case 3: {
                IVariableBinding var = (IVariableBinding)binding;
                return !var.isField() || Bindings.isDeclarationBinding((IBinding)var.getDeclaringClass());
            }
            case 4: {
                return ((IMethodBinding)binding).getMethodDeclaration() == binding;
            }
        }
        return true;
    }

    public static boolean containsOverridingMethod(IMethodBinding[] candidates, IMethodBinding overridable) {
        int index = 0;
        while (index < candidates.length) {
            if (Bindings.areOverriddenMethods(candidates[index], overridable)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public static boolean containsSignatureEquivalentConstructor(IMethodBinding[] candidates, IMethodBinding overridable) {
        int index = 0;
        while (index < candidates.length) {
            if (Bindings.isSignatureEquivalentConstructor(candidates[index], overridable)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public static boolean isSignatureEquivalentConstructor(IMethodBinding overridden, IMethodBinding overridable) {
        if (!overridden.isConstructor() || !overridable.isConstructor()) {
            return false;
        }
        if (overridden.isDefaultConstructor()) {
            return false;
        }
        return Bindings.areSubTypeCompatible(overridden, overridable);
    }

    public static boolean areOverriddenMethods(IMethodBinding overridden, IMethodBinding overridable) {
        if (!overridden.getName().equals(overridable.getName())) {
            return false;
        }
        return Bindings.areSubTypeCompatible(overridden, overridable);
    }

    private static boolean areSubTypeCompatible(IMethodBinding overridden, IMethodBinding overridable) {
        ITypeBinding[] overridableTypes;
        if (overridden.getParameterTypes().length != overridable.getParameterTypes().length) {
            return false;
        }
        ITypeBinding overriddenReturn = overridden.getReturnType();
        ITypeBinding overridableReturn = overridable.getReturnType();
        if (overriddenReturn == null || overridableReturn == null) {
            return false;
        }
        if (!overriddenReturn.getErasure().isSubTypeCompatible(overridableReturn.getErasure())) {
            return false;
        }
        ITypeBinding[] overriddenTypes = overridden.getParameterTypes();
        Assert.isTrue(overriddenTypes.length == (overridableTypes = overridable.getParameterTypes()).length);
        int index = 0;
        while (index < overriddenTypes.length) {
            ITypeBinding overriddenErasure;
            ITypeBinding overridableErasure = overridableTypes[index].getErasure();
            if (!overridableErasure.isSubTypeCompatible(overriddenErasure = overriddenTypes[index].getErasure()) || !overridableErasure.getKey().equals(overriddenErasure.getKey())) {
                return false;
            }
            ++index;
        }
        ITypeBinding[] overriddenExceptions = overridden.getExceptionTypes();
        ITypeBinding[] overridableExceptions = overridable.getExceptionTypes();
        boolean checked = false;
        int index2 = 0;
        while (index2 < overriddenExceptions.length) {
            checked = false;
            int offset = 0;
            while (offset < overridableExceptions.length) {
                if (overriddenExceptions[index2].isSubTypeCompatible(overridableExceptions[offset])) {
                    checked = true;
                }
                ++offset;
            }
            if (!checked) {
                return false;
            }
            ++index2;
        }
        return true;
    }
}

