/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public final class ImportRewrite {
    private ImportsStructure fImportsStructure;

    private ImportRewrite(ICompilationUnit cu, String[] preferenceOrder, int importThreshold) throws CoreException {
        Assert.isNotNull(cu);
        Assert.isNotNull(preferenceOrder);
        this.fImportsStructure = new ImportsStructure(cu, preferenceOrder, importThreshold, true);
    }

    public ImportRewrite(ICompilationUnit cunit) throws CoreException {
        this(cunit, JavaPreferencesSettings.getImportOrderPreference(cunit.getJavaProject()), JavaPreferencesSettings.getImportNumberThreshold(cunit.getJavaProject()));
    }

    public final TextEdit createEdit(IDocument document) throws CoreException {
        return this.createEdit(document, null);
    }

    public final TextEdit createEdit(IDocument document, IProgressMonitor monitor) throws CoreException {
        try {
            return this.fImportsStructure.getResultingEdits(document, monitor);
        }
        catch (BadLocationException e) {
            throw new CoreException(JavaUIStatus.createError(4, e));
        }
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fImportsStructure.getCompilationUnit();
    }

    public void setFilterImplicitImports(boolean filterImplicitImports) {
        this.fImportsStructure.setFilterImplicitImports(filterImplicitImports);
    }

    public void setFindAmbiguosImports(boolean findAmbiguosImports) {
        this.fImportsStructure.setFindAmbiguousImports(findAmbiguosImports);
    }

    public String addImport(String qualifiedTypeName) {
        return this.fImportsStructure.addImport(qualifiedTypeName);
    }

    public String addStaticImport(String qualifiedName, String selector, boolean isField) {
        return this.fImportsStructure.addStaticImport(qualifiedName, selector, isField);
    }

    public String addStaticImport(IBinding binding) {
        return this.fImportsStructure.addStaticImport(binding);
    }

    public String addImport(ITypeBinding binding) {
        return this.fImportsStructure.addImport(binding);
    }

    public Type addImport(ITypeBinding binding, AST ast) {
        return this.fImportsStructure.addImport(binding, ast);
    }

    public Type addImportFromSignature(String typeSig, AST ast) {
        return this.fImportsStructure.addImportFromSignature(typeSig, ast);
    }

    public String findImport(String simpleName) {
        return this.fImportsStructure.findImport(simpleName);
    }

    public boolean removeImport(ITypeBinding binding) {
        return this.fImportsStructure.removeImport(binding);
    }

    public boolean removeImport(String qualifiedTypeName) {
        return this.fImportsStructure.removeImport(qualifiedTypeName);
    }

    public boolean removeStaticImport(String qualifiedName) {
        return this.fImportsStructure.removeStaticImport(qualifiedName);
    }

    public boolean isEmpty() {
        return !this.fImportsStructure.hasChanges();
    }

    public String[] getCreatedImports() {
        return this.fImportsStructure.getCreatedImports();
    }

    public String[] getCreatedStaticImports() {
        return this.fImportsStructure.getCreatedStaticImports();
    }
}

