/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jface.text.Region;

public class ImportReferencesCollector
extends GenericVisitor {
    private CompilationUnit fASTRoot;
    private Region fSubRange;
    private Collection fTypeImports;
    private Collection fStaticImports;

    public static void collect(ASTNode node, IJavaProject project, Region rangeLimit, Collection resultingTypeImports, Collection resultingStaticImports) {
        CompilationUnit astRoot = (CompilationUnit)node.getRoot();
        node.accept((ASTVisitor)new ImportReferencesCollector(project, astRoot, rangeLimit, resultingTypeImports, resultingStaticImports));
    }

    private ImportReferencesCollector(IJavaProject project, CompilationUnit astRoot, Region rangeLimit, Collection resultingTypeImports, Collection resultingStaticImports) {
        super(true);
        this.fTypeImports = resultingTypeImports;
        this.fStaticImports = resultingStaticImports;
        this.fSubRange = rangeLimit;
        if (project == null || !"1.5".equals(project.getOption("org.eclipse.jdt.core.compiler.source", true))) {
            this.fStaticImports = null;
        }
        this.fASTRoot = astRoot;
    }

    public ImportReferencesCollector(IJavaProject project, Region rangeLimit, Collection resultingTypeImports, Collection resultingStaticImports) {
        this(project, null, rangeLimit, resultingTypeImports, resultingStaticImports);
    }

    public CompilationUnit getASTRoot(ASTNode node) {
        if (this.fASTRoot == null) {
            this.fASTRoot = (CompilationUnit)node.getRoot();
        }
        return this.fASTRoot;
    }

    private boolean isAffected(ASTNode node) {
        if (this.fSubRange == null) {
            return true;
        }
        int nodeStart = node.getStartPosition();
        return nodeStart + node.getLength() > this.fSubRange.getOffset() && this.fSubRange.getOffset() + this.fSubRange.getLength() > nodeStart;
    }

    private void addReference(SimpleName name) {
        if (this.isAffected((ASTNode)name)) {
            this.fTypeImports.add(name);
        }
    }

    private void typeRefFound(Name node) {
        if (node != null) {
            while (node.isQualifiedName()) {
                node = ((QualifiedName)node).getQualifier();
            }
            this.addReference((SimpleName)node);
        }
    }

    private void possibleTypeRefFound(Name node) {
        while (node.isQualifiedName()) {
            node = ((QualifiedName)node).getQualifier();
        }
        IBinding binding = node.resolveBinding();
        if (binding == null || binding.getKind() == 2) {
            this.addReference((SimpleName)node);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void possibleStaticImportFound(Name name) {
        if (this.fStaticImports != null) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            name = ((QualifiedName)name).getQualifier();
lbl4:
            // 2 sources

            ** while (name.isQualifiedName())
        }
lbl5:
        // 1 sources

        if (!this.isAffected((ASTNode)name)) {
            return;
        }
        binding = name.resolveBinding();
        if (binding == null || binding instanceof ITypeBinding || !Modifier.isStatic((int)binding.getModifiers()) || ((SimpleName)name).isDeclaration()) {
            return;
        }
        if (binding instanceof IVariableBinding) {
            varBinding = (IVariableBinding)binding;
            if (varBinding.isField() && (declaringClass = varBinding.getDeclaringClass()) != null && !declaringClass.isLocal()) {
                declarationsInScope = new ScopeAnalyzer(this.getASTRoot((ASTNode)name)).getDeclarationsInScope(name.getStartPosition(), 2);
                i = 0;
                while (i < declarationsInScope.length) {
                    if (declarationsInScope[i] == binding) {
                        return;
                    }
                    ++i;
                }
                this.fStaticImports.add(name);
            }
        } else if (binding instanceof IMethodBinding && (declaringClass = (methodBinding = ((IMethodBinding)binding).getMethodDeclaration()).getDeclaringClass()) != null && !declaringClass.isLocal()) {
            declarationsInScope = new ScopeAnalyzer(this.getASTRoot((ASTNode)name)).getDeclarationsInScope(name.getStartPosition(), 1);
            i = 0;
            while (i < declarationsInScope.length) {
                curr = (IMethodBinding)declarationsInScope[i];
                if (curr.getMethodDeclaration() == methodBinding) {
                    return;
                }
                ++i;
            }
            this.fStaticImports.add(name);
        }
    }

    private void doVisitChildren(List elements) {
        int nElements = elements.size();
        int i = 0;
        while (i < nElements) {
            ((ASTNode)elements.get(i)).accept((ASTVisitor)this);
            ++i;
        }
    }

    private void doVisitNode(ASTNode node) {
        if (node != null) {
            node.accept((ASTVisitor)this);
        }
    }

    protected boolean visitNode(ASTNode node) {
        return this.isAffected(node);
    }

    public boolean visit(ArrayType node) {
        this.doVisitNode((ASTNode)node.getElementType());
        return false;
    }

    public boolean visit(SimpleType node) {
        this.typeRefFound(node.getName());
        return false;
    }

    public boolean visit(QualifiedType node) {
        return true;
    }

    public boolean visit(QualifiedName node) {
        this.possibleTypeRefFound((Name)node);
        this.possibleStaticImportFound((Name)node);
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        if (node.getAST().apiLevel() >= 3) {
            this.doVisitChildren(node.annotations());
        }
        return false;
    }

    public boolean visit(ThisExpression node) {
        this.typeRefFound(node.getQualifier());
        return false;
    }

    private void evalQualifyingExpression(Expression expr, Name selector) {
        if (expr != null) {
            if (expr instanceof Name) {
                Name name = (Name)expr;
                this.possibleTypeRefFound(name);
                this.possibleStaticImportFound(name);
            } else {
                expr.accept((ASTVisitor)this);
            }
        } else if (selector != null) {
            this.possibleStaticImportFound(selector);
        }
    }

    public boolean visit(ClassInstanceCreation node) {
        this.doVisitNode((ASTNode)node.getType());
        this.evalQualifyingExpression(node.getExpression(), null);
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        this.doVisitChildren(node.arguments());
        return false;
    }

    public boolean visit(MethodInvocation node) {
        this.evalQualifyingExpression(node.getExpression(), (Name)node.getName());
        this.doVisitChildren(node.arguments());
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (!this.isAffected((ASTNode)node)) {
            return false;
        }
        this.evalQualifyingExpression(node.getExpression(), null);
        this.doVisitChildren(node.arguments());
        return false;
    }

    public boolean visit(FieldAccess node) {
        this.evalQualifyingExpression(node.getExpression(), (Name)node.getName());
        return false;
    }

    public boolean visit(SimpleName node) {
        this.possibleStaticImportFound((Name)node);
        return false;
    }

    public boolean visit(MarkerAnnotation node) {
        this.typeRefFound(node.getTypeName());
        return false;
    }

    public boolean visit(NormalAnnotation node) {
        this.typeRefFound(node.getTypeName());
        this.doVisitChildren(node.values());
        return false;
    }

    public boolean visit(SingleMemberAnnotation node) {
        this.typeRefFound(node.getTypeName());
        this.doVisitNode((ASTNode)node.getValue());
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        return this.isAffected((ASTNode)node);
    }

    public boolean visit(MethodDeclaration node) {
        if (!this.isAffected((ASTNode)node)) {
            return false;
        }
        this.doVisitNode((ASTNode)node.getJavadoc());
        if (node.getAST().apiLevel() >= 3) {
            this.doVisitChildren(node.modifiers());
            this.doVisitChildren(node.typeParameters());
        }
        if (!node.isConstructor()) {
            this.doVisitNode((ASTNode)node.getReturnType2());
        }
        this.doVisitChildren(node.parameters());
        Iterator iter = node.thrownExceptions().iterator();
        while (iter.hasNext()) {
            this.typeRefFound((Name)iter.next());
        }
        this.doVisitNode((ASTNode)node.getBody());
        return false;
    }

    public boolean visit(TagElement node) {
        Object first;
        String tagName = node.getTagName();
        List list = node.fragments();
        int idx = 0;
        if (tagName != null && !list.isEmpty() && (first = list.get(0)) instanceof Name) {
            if ("@throws".equals(tagName) || "@exception".equals(tagName)) {
                this.typeRefFound((Name)first);
            } else if ("@see".equals(tagName) || "@link".equals(tagName) || "@linkplain".equals(tagName)) {
                Name name = (Name)first;
                this.possibleTypeRefFound(name);
                this.possibleStaticImportFound(name);
            }
            ++idx;
        }
        int i = idx;
        while (i < list.size()) {
            this.doVisitNode((ASTNode)list.get(i));
            ++i;
        }
        return false;
    }

    public boolean visit(MemberRef node) {
        Name qualifier = node.getQualifier();
        if (qualifier != null) {
            this.typeRefFound(qualifier);
        } else {
            SimpleName name = node.getName();
            if (name != null) {
                this.possibleStaticImportFound((Name)name);
            }
        }
        return false;
    }

    public boolean visit(MethodRef node) {
        Name qualifier = node.getQualifier();
        if (qualifier != null) {
            this.typeRefFound(qualifier);
        } else {
            SimpleName name = node.getName();
            if (name != null) {
                this.possibleStaticImportFound((Name)name);
            }
        }
        List list = node.parameters();
        if (list != null) {
            this.doVisitChildren(list);
        }
        return false;
    }
}

