/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFactory;
import org.eclipse.update.core.ISiteFactoryExtension;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.Response;
import org.eclipse.update.internal.core.SiteLocal;
import org.eclipse.update.internal.core.SiteTypeFactory;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ITimestamp;

public class InternalSiteManager {
    public static ILocalSite localSite;
    public static final String DEFAULT_SITE_TYPE = "org.eclipse.update.core.http";
    private static final String DEFAULT_EXECUTABLE_SITE_TYPE = "org.eclipse.update.core.file";
    private static Map estimates;
    private static Map sites;
    private static Map httpSitesUpdatedUrls;
    private static Map siteTimestamps;
    public static boolean globalUseCache;
    private static CoreException exceptionOccured;

    static {
        sites = new HashMap();
        httpSitesUpdatedUrls = new HashMap();
        siteTimestamps = new HashMap();
        globalUseCache = true;
        exceptionOccured = null;
    }

    public static ILocalSite getLocalSite() throws CoreException {
        return InternalSiteManager.internalGetLocalSite();
    }

    private static ILocalSite internalGetLocalSite() throws CoreException {
        if (exceptionOccured != null) {
            throw exceptionOccured;
        }
        if (localSite == null) {
            try {
                localSite = SiteLocal.internalGetLocalSite();
            }
            catch (CoreException e) {
                exceptionOccured = e;
                throw e;
            }
        }
        return localSite;
    }

    private static boolean isValidCachedSite(URL siteURL) {
        if (!sites.containsKey(siteURL.toExternalForm())) {
            return false;
        }
        Long timestamp = (Long)siteTimestamps.get(siteURL);
        if (timestamp == null) {
            return false;
        }
        long localLastModified = timestamp;
        return UpdateManagerUtils.isSameTimestamp(siteURL, localLastModified);
    }

    public static ISite getSite(URL siteURL, boolean useCache, IProgressMonitor monitor) throws CoreException {
        ISite site;
        block22: {
            File dir;
            File f;
            site = null;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if (siteURL == null) {
                return null;
            }
            if (httpSitesUpdatedUrls.containsKey(siteURL.toExternalForm())) {
                siteURL = (URL)httpSitesUpdatedUrls.get(siteURL.toExternalForm());
            }
            String siteURLString = siteURL.toExternalForm();
            if (useCache && globalUseCache && InternalSiteManager.isValidCachedSite(siteURL)) {
                site = (ISite)sites.get(siteURLString);
                return site;
            }
            if ("file".equals(siteURL.getProtocol()) && (f = new File(siteURL.getFile())).isDirectory() && !"eclipse".equals(f.getName())) {
                f = new File(f, "eclipse");
                try {
                    if (useCache && globalUseCache && InternalSiteManager.isValidCachedSite(f.toURL())) {
                        site = (ISite)sites.get(f.toURL().toExternalForm());
                        return site;
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            boolean fileProtocol = "file".equalsIgnoreCase(siteURL.getProtocol());
            boolean directoryExists = false;
            if (fileProtocol && (dir = new File(siteURL.getFile())) != null && dir.isDirectory() && !new File(dir, "site.xml").exists()) {
                directoryExists = true;
            }
            monitor.beginTask(Messages.InternalSiteManager_ConnectingToSite, 8);
            if (fileProtocol && directoryExists) {
                site = InternalSiteManager.attemptCreateSite(DEFAULT_EXECUTABLE_SITE_TYPE, siteURL, monitor);
                monitor.worked(4);
            } else {
                try {
                    monitor.worked(3);
                    site = InternalSiteManager.attemptCreateSite(DEFAULT_SITE_TYPE, siteURL, monitor);
                    monitor.worked(1);
                }
                catch (CoreException preservedException) {
                    if (monitor.isCanceled()) break block22;
                    if (!fileProtocol) {
                        throw preservedException;
                    }
                    try {
                        site = InternalSiteManager.attemptCreateSite(DEFAULT_EXECUTABLE_SITE_TYPE, siteURL, monitor);
                    }
                    catch (CoreException retryException) {
                        IStatus firstStatus = preservedException.getStatus();
                        MultiStatus multi = new MultiStatus(firstStatus.getPlugin(), 0, Messages.InternalSiteManager_FailedRetryAccessingSite, (Throwable)retryException);
                        multi.addAll(firstStatus);
                        throw preservedException;
                    }
                }
            }
        }
        if (site != null) {
            sites.put(site.getURL().toExternalForm(), site);
            if (site instanceof ITimestamp) {
                siteTimestamps.put(site.getURL(), new Long(((ITimestamp)((Object)site)).getTimestamp().getTime()));
            } else {
                try {
                    Response response = UpdateCore.getPlugin().get(URLEncoder.encode(siteURL));
                    siteTimestamps.put(siteURL, new Long(response.getLastModified()));
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
            }
        }
        JarContentReference.shutdown();
        return site;
    }

    private static ISite attemptCreateSite(String guessedTypeSite, URL siteURL, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ISite site = null;
        try {
            monitor.worked(1);
            site = InternalSiteManager.createSite(guessedTypeSite, siteURL, monitor);
            monitor.worked(1);
        }
        catch (InvalidSiteTypeException e) {
            if (monitor.isCanceled()) {
                return null;
            }
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_TYPE) {
                UpdateCore.debug("The Site :" + siteURL.toExternalForm() + " is a different type than the guessed type based on the protocol. new Type:" + e.getNewType());
            }
            try {
                if (e.getNewType() == null) {
                    throw e;
                }
                site = InternalSiteManager.createSite(e.getNewType(), siteURL, monitor);
            }
            catch (InvalidSiteTypeException e1) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.InternalSiteManager_UnableToCreateSiteWithType, (Object[])new String[]{e.getNewType(), siteURL.toExternalForm()}), e1);
            }
        }
        return site;
    }

    private static ISite createSite(String siteType, URL url, IProgressMonitor monitor) throws CoreException, InvalidSiteTypeException {
        URL fixedUrl;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ISiteFactory factory = SiteTypeFactory.getInstance().getFactory(siteType);
        try {
            fixedUrl = url.getRef() != null || url.getFile().endsWith("site.xml") || url.getProtocol().equalsIgnoreCase("file") ? url : (url.getFile().endsWith("/") ? new URL(url, "site.xml") : new URL(url.getProtocol(), url.getHost(), url.getPort(), String.valueOf(url.getFile()) + "/" + "site.xml"));
        }
        catch (MalformedURLException malformedURLException) {
            fixedUrl = url;
        }
        try {
            try {
                monitor.worked(1);
                return InternalSiteManager.createSite(factory, fixedUrl, url, monitor);
            }
            catch (CoreException ce) {
                if (monitor.isCanceled()) {
                    return null;
                }
                if (!fixedUrl.equals(url)) {
                    return InternalSiteManager.createSite(factory, url, url, monitor);
                }
                if (url.getProtocol().equalsIgnoreCase("file") && !url.getFile().endsWith("site.xml")) {
                    try {
                        if (url.getFile().endsWith("/")) {
                            return InternalSiteManager.createSite(factory, new URL(url, "site.xml"), url, monitor);
                        }
                        return InternalSiteManager.createSite(factory, new URL(url.getProtocol(), url.getHost(), url.getPort(), String.valueOf(url.getFile()) + "/" + "site.xml"), url, monitor);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw ce;
                    }
                }
                throw ce;
            }
        }
        catch (CoreException ce) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InternalSiteManager_UnableToAccessURL, (Object[])new String[]{url.toExternalForm()}), ce);
        }
    }

    private static ISite createSite(ISiteFactory factory, URL url, URL originalUrl, IProgressMonitor monitor) throws CoreException, InvalidSiteTypeException {
        ISite site = InternalSiteManager.createSite(factory, url, monitor);
        httpSitesUpdatedUrls.put(originalUrl.toExternalForm(), url);
        return site;
    }

    private static ISite createSite(ISiteFactory factory, URL url, IProgressMonitor monitor) throws CoreException, InvalidSiteTypeException {
        if (factory instanceof ISiteFactoryExtension) {
            return ((ISiteFactoryExtension)((Object)factory)).createSite(url, monitor);
        }
        return factory.createSite(url);
    }

    public static ISite createSite(File siteLocation) throws CoreException {
        ISite site = null;
        if (siteLocation != null) {
            try {
                URL siteURL = siteLocation.toURL();
                site = InternalSiteManager.getSite(siteURL, false, null);
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.InternalSiteManager_UnableToCreateURL, (Object[])new String[]{siteLocation.getAbsolutePath()}), e);
            }
        }
        return site;
    }

    public static void downloaded(long downloadSize, long time, URL url) {
        if (downloadSize <= 0L || time < 0L) {
            return;
        }
        String host = url.getHost();
        long sizeByTime = time == 0L ? 0L : downloadSize / time;
        Long value = new Long(sizeByTime);
        if (estimates == null) {
            estimates = new HashMap();
        } else {
            Long previous = (Long)estimates.get(host);
            if (previous != null) {
                value = new Long((previous + sizeByTime) / 2L);
            }
        }
        estimates.put(host, value);
    }

    public static long getEstimatedTransferRate(String host) {
        if (estimates == null) {
            return 0L;
        }
        Long value = (Long)estimates.get(host);
        if (value == null) {
            return 0L;
        }
        return value;
    }
}

