/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIFieldVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceType;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public class JDIObjectValue
extends JDIValue
implements IJavaObject {
    public JDIObjectValue(JDIDebugTarget target, ObjectReference object) {
        super(target, object);
    }

    public IJavaValue sendMessage(String selector, String signature, IJavaValue[] args, IJavaThread thread, boolean superSend) throws DebugException {
        JDIThread javaThread = (JDIThread)thread;
        ArrayList<Value> arguments = null;
        if (args == null) {
            arguments = Collections.EMPTY_LIST;
        } else {
            arguments = new ArrayList<Value>(args.length);
            int i = 0;
            while (i < args.length) {
                arguments.add(((JDIValue)args[i]).getUnderlyingValue());
                ++i;
            }
        }
        ObjectReference object = this.getUnderlyingObject();
        Method method = null;
        ReferenceType refType = this.getUnderlyingReferenceType();
        try {
            if (superSend) {
                refType = ((ClassType)refType).superclass();
            }
            if ((method = this.concreteMethodByName(refType, selector, signature)) == null) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIObjectValue_11, selector, signature), null);
            }
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIObjectValue_exception_while_performing_method_lookup_for_selector, e.toString(), selector, signature), e);
        }
        Value result = javaThread.invokeMethod(null, object, method, arguments, superSend);
        return JDIValue.createValue((JDIDebugTarget)this.getDebugTarget(), result);
    }

    public IJavaValue sendMessage(String selector, String signature, IJavaValue[] args, IJavaThread thread, String typeSignature) throws DebugException {
        JDIThread javaThread = (JDIThread)thread;
        ArrayList<Value> arguments = null;
        if (args == null) {
            arguments = Collections.EMPTY_LIST;
        } else {
            arguments = new ArrayList<Value>(args.length);
            int i = 0;
            while (i < args.length) {
                arguments.add(((JDIValue)args[i]).getUnderlyingValue());
                ++i;
            }
        }
        ObjectReference object = this.getUnderlyingObject();
        Method method = null;
        ReferenceType refType = this.getUnderlyingReferenceType();
        try {
            while (typeSignature != null && !refType.signature().equals(typeSignature)) {
                if ((refType = ((ClassType)refType).superclass()) != null) continue;
                this.targetRequestFailed(JDIDebugModelMessages.JDIObjectValueMethod_declaring_type_not_found_1, null);
            }
            method = this.concreteMethodByName(refType, selector, signature);
            if (method == null) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIObjectValue_11, selector, signature), null);
            }
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIObjectValue_exception_while_performing_method_lookup_for_selector, e.toString(), selector, signature), e);
        }
        Value result = javaThread.invokeMethod(null, object, method, arguments, true);
        return JDIValue.createValue((JDIDebugTarget)this.getDebugTarget(), result);
    }

    private Method concreteMethodByName(ReferenceType refType, String selector, String signature) throws DebugException {
        if (refType instanceof ClassType) {
            return ((ClassType)refType).concreteMethodByName(selector, signature);
        }
        if (refType instanceof ArrayType) {
            return ((ClassType)refType.classObject().referenceType()).superclass().concreteMethodByName(selector, signature);
        }
        this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIObjectValue_method_lookup_failed_for_selector____0____with_signature____1___1, selector, signature), null);
        return null;
    }

    public ObjectReference getUnderlyingObject() {
        return (ObjectReference)this.getUnderlyingValue();
    }

    public IJavaFieldVariable getField(String name, boolean superField) throws DebugException {
        ReferenceType ref = this.getUnderlyingReferenceType();
        try {
            Field field;
            if (superField) {
                ref = ((ClassType)ref).superclass();
            }
            if ((field = ref.fieldByName(name)) != null) {
                return new JDIFieldVariable((JDIDebugTarget)this.getDebugTarget(), field, this.getUnderlyingObject());
            }
            Field enclosingThis = null;
            Iterator<Field> fields = ref.fields().iterator();
            while (fields.hasNext()) {
                Field fieldTmp = fields.next();
                if (!fieldTmp.name().startsWith("this$")) continue;
                enclosingThis = fieldTmp;
                break;
            }
            return ((JDIObjectValue)new JDIFieldVariable((JDIDebugTarget)this.getDebugTarget(), enclosingThis, this.getUnderlyingObject()).getValue()).getField(name, false);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIObjectValue_exception_retrieving_field, e.toString()), e);
            return null;
        }
    }

    public IJavaFieldVariable getField(String name, String declaringTypeSignature) throws DebugException {
        ReferenceType ref = this.getUnderlyingReferenceType();
        try {
            Field field = null;
            Field fieldTmp = null;
            Iterator<Field> fields = ref.allFields().iterator();
            while (fields.hasNext()) {
                fieldTmp = fields.next();
                if (!name.equals(fieldTmp.name()) || !declaringTypeSignature.equals(fieldTmp.declaringType().signature())) continue;
                field = fieldTmp;
                break;
            }
            if (field != null) {
                return new JDIFieldVariable((JDIDebugTarget)this.getDebugTarget(), field, this.getUnderlyingObject());
            }
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIObjectValue_exception_retrieving_field, e.toString()), e);
        }
        return null;
    }

    public IJavaFieldVariable getField(String name, int superClassLevel) throws DebugException {
        ReferenceType ref = this.getUnderlyingReferenceType();
        try {
            int i = 0;
            while (i < superClassLevel) {
                ref = ((ClassType)ref).superclass();
                ++i;
            }
            Field field = ref.fieldByName(name);
            if (field != null) {
                return new JDIFieldVariable((JDIDebugTarget)this.getDebugTarget(), field, this.getUnderlyingObject());
            }
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIObjectValue_exception_retrieving_field, e.toString()), e);
        }
        return null;
    }

    protected ReferenceType getUnderlyingReferenceType() throws DebugException {
        try {
            return this.getUnderlyingObject().referenceType();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIObjectValue_exception_retrieving_reference_type, e.toString()), e);
            return null;
        }
    }

    public IJavaObject getEnclosingObject(int enclosingLevel) throws DebugException {
        JDIObjectValue res = this;
        int i = 0;
        while (i < enclosingLevel) {
            block5: {
                ReferenceType ref = res.getUnderlyingReferenceType();
                try {
                    Field enclosingThis = null;
                    Field fieldTmp = null;
                    Iterator<Field> fields = ref.fields().iterator();
                    while (fields.hasNext()) {
                        fieldTmp = fields.next();
                        if (!fieldTmp.name().startsWith("this$")) continue;
                        enclosingThis = fieldTmp;
                    }
                    if (enclosingThis != null) {
                        res = (JDIObjectValue)new JDIFieldVariable((JDIDebugTarget)this.getDebugTarget(), enclosingThis, res.getUnderlyingObject()).getValue();
                        break block5;
                    }
                    return null;
                }
                catch (RuntimeException e) {
                    this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIObjectValue_exception_retrieving_field, e.toString()), e);
                }
            }
            ++i;
        }
        return res;
    }

    public IJavaThread[] getWaitingThreads() throws DebugException {
        ArrayList<JDIThread> waiting = new ArrayList<JDIThread>();
        try {
            List<ThreadReference> threads = this.getUnderlyingObject().waitingThreads();
            JDIDebugTarget debugTarget = (JDIDebugTarget)this.getDebugTarget();
            Iterator<ThreadReference> iter = threads.iterator();
            while (iter.hasNext()) {
                JDIThread jdiThread = debugTarget.findThread(iter.next());
                if (jdiThread == null) continue;
                waiting.add(jdiThread);
            }
        }
        catch (IncompatibleThreadStateException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIObjectValue_0, e);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIObjectValue_0, e);
        }
        return waiting.toArray(new IJavaThread[waiting.size()]);
    }

    public IJavaThread getOwningThread() throws DebugException {
        JDIThread owningThread = null;
        try {
            ThreadReference thread = this.getUnderlyingObject().owningThread();
            JDIDebugTarget debugTarget = (JDIDebugTarget)this.getDebugTarget();
            if (thread != null) {
                owningThread = debugTarget.findThread(thread);
            }
        }
        catch (IncompatibleThreadStateException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIObjectValue_1, e);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return null;
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIObjectValue_1, e);
        }
        return owningThread;
    }

    public String getReferenceTypeName() throws DebugException {
        try {
            return JDIReferenceType.getGenericName(this.getUnderlyingReferenceType());
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIValue_exception_retrieving_reference_type_name, e.toString()), e);
            return null;
        }
    }
}

