/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;
import org.eclipse.jdt.internal.debug.core.model.JDIVariable;

public abstract class JDIModificationVariable
extends JDIVariable {
    private static final ArrayList fgValidSignatures = new ArrayList(9);

    static {
        fgValidSignatures.add("B");
        fgValidSignatures.add("C");
        fgValidSignatures.add("D");
        fgValidSignatures.add("F");
        fgValidSignatures.add("I");
        fgValidSignatures.add("J");
        fgValidSignatures.add("S");
        fgValidSignatures.add("Z");
        fgValidSignatures.add("Ljava/lang/String;");
    }

    public JDIModificationVariable(JDIDebugTarget target) {
        super(target);
    }

    public boolean supportsValueModification() {
        return true;
    }

    protected Value generateVMValue(String expression) throws DebugException {
        String signature = null;
        Value cValue = this.getCurrentValue();
        VirtualMachine vm = this.getVM();
        if (vm == null) {
            this.requestFailed(JDIDebugModelMessages.JDIModificationVariable_Unable_to_generate_value___VM_disconnected__1, null);
        }
        if ((signature = cValue == null ? "Ljava/lang/String;" : cValue.type().signature()).length() > 1 && !signature.equals("Ljava/lang/String;")) {
            return null;
        }
        Value vmValue = null;
        try {
            switch (signature.charAt(0)) {
                case 'Z': {
                    String flse = Boolean.FALSE.toString();
                    String tre = Boolean.TRUE.toString();
                    if (!expression.equals(tre) && !expression.equals(flse)) break;
                    boolean booleanValue = Boolean.valueOf(expression);
                    vmValue = vm.mirrorOf(booleanValue);
                    break;
                }
                case 'B': {
                    byte byteValue = Byte.valueOf(expression);
                    vmValue = vm.mirrorOf(byteValue);
                    break;
                }
                case 'C': {
                    char charValue;
                    if (expression.length() == 1) {
                        char charValue2 = expression.charAt(0);
                        vmValue = vm.mirrorOf(charValue2);
                        break;
                    }
                    if (expression.length() != 2) break;
                    if (expression.charAt(0) != '\\') {
                        return null;
                    }
                    switch (expression.charAt(1)) {
                        case 'b': {
                            charValue = '\b';
                            break;
                        }
                        case 'f': {
                            charValue = '\f';
                            break;
                        }
                        case 'n': {
                            charValue = '\n';
                            break;
                        }
                        case 'r': {
                            charValue = '\r';
                            break;
                        }
                        case 't': {
                            charValue = '\t';
                            break;
                        }
                        case '\'': {
                            charValue = '\'';
                            break;
                        }
                        case '\"': {
                            charValue = '\"';
                            break;
                        }
                        case '\\': {
                            charValue = '\\';
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    vmValue = vm.mirrorOf(charValue);
                    break;
                }
                case 'S': {
                    short shortValue = Short.valueOf(expression);
                    vmValue = vm.mirrorOf(shortValue);
                    break;
                }
                case 'I': {
                    int intValue = Integer.valueOf(expression);
                    vmValue = vm.mirrorOf(intValue);
                    break;
                }
                case 'J': {
                    long longValue = Long.valueOf(expression);
                    vmValue = vm.mirrorOf(longValue);
                    break;
                }
                case 'F': {
                    float floatValue = Float.valueOf(expression).floatValue();
                    vmValue = vm.mirrorOf(floatValue);
                    break;
                }
                case 'D': {
                    double doubleValue = Double.valueOf(expression);
                    vmValue = vm.mirrorOf(doubleValue);
                    break;
                }
                case 'L': {
                    vmValue = expression.equals("null") ? null : (expression.equals("\"null\"") ? vm.mirrorOf("null") : vm.mirrorOf(expression));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return vmValue;
    }

    public boolean verifyValue(String expression) {
        try {
            JDIValue value = JDIValue.createValue(this.getJavaDebugTarget(), this.generateVMValue(expression));
            return this.verifyValue(value);
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public boolean verifyValue(IValue value) {
        return value instanceof IJavaValue && value.getDebugTarget().equals(this.getDebugTarget());
    }

    public final void setValue(String expression) throws DebugException {
        Value value = this.generateVMValue(expression);
        this.setJDIValue(value);
    }

    protected abstract void setJDIValue(Value var1) throws DebugException;
}

