/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIModificationVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceType;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public class JDILocalVariable
extends JDIModificationVariable {
    private LocalVariable fLocal;
    private JDIStackFrame fStackFrame;

    public JDILocalVariable(JDIStackFrame frame, LocalVariable local) {
        super((JDIDebugTarget)frame.getDebugTarget());
        this.fStackFrame = frame;
        this.fLocal = local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Value retrieveValue() throws DebugException {
        IThread iThread = this.fStackFrame.getThread();
        synchronized (iThread) {
            if (this.getStackFrame().isSuspended()) {
                return this.getStackFrame().getUnderlyingStackFrame().getValue(this.fLocal);
            }
        }
        return this.getLastKnownValue();
    }

    public String getName() throws DebugException {
        try {
            return this.getLocal().name();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDILocalVariable_exception_retrieving_local_variable_name, e.toString()), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setJDIValue(Value value) throws DebugException {
        try {
            IThread iThread = this.getStackFrame().getThread();
            synchronized (iThread) {
                this.getStackFrame().getUnderlyingStackFrame().setValue(this.getLocal(), value);
            }
            this.fireChangeEvent(512);
        }
        catch (ClassNotLoadedException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDILocalVariable_exception_modifying_local_variable_value, e.toString()), e);
        }
        catch (InvalidTypeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDILocalVariable_exception_modifying_local_variable_value, e.toString()), e);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDILocalVariable_exception_modifying_local_variable_value, e.toString()), e);
        }
    }

    public String getReferenceTypeName() throws DebugException {
        try {
            String genericSignature = this.getLocal().genericSignature();
            if (genericSignature != null) {
                return JDIReferenceType.getTypeName(genericSignature);
            }
            Type underlyingType = this.getUnderlyingType();
            if (underlyingType instanceof ReferenceType) {
                return JDIReferenceType.getGenericName((ReferenceType)underlyingType);
            }
            return this.getLocal().typeName();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDILocalVariable_exception_retrieving_local_variable_type_name, e.toString()), e);
            return null;
        }
    }

    public String getSignature() throws DebugException {
        try {
            return this.getLocal().signature();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDILocalVariable_exception_retrieving_local_variable_type_signature, e.toString()), e);
            return null;
        }
    }

    public String getGenericSignature() throws DebugException {
        try {
            String genericSignature = this.fLocal.genericSignature();
            if (genericSignature != null) {
                return genericSignature;
            }
            return this.fLocal.signature();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDILocalVariable_exception_retrieving_local_variable_type_signature, e.toString()), e);
            return null;
        }
    }

    protected void setLocal(LocalVariable local) {
        this.fLocal = local;
    }

    protected LocalVariable getLocal() {
        return this.fLocal;
    }

    protected JDIStackFrame getStackFrame() {
        return this.fStackFrame;
    }

    public String toString() {
        return this.getLocal().toString();
    }

    public void setValue(IValue v) throws DebugException {
        if (this.verifyValue(v)) {
            JDIValue value = (JDIValue)v;
            this.setJDIValue(value.getUnderlyingValue());
        }
    }

    protected Type getUnderlyingType() throws DebugException {
        try {
            return this.getLocal().type();
        }
        catch (ClassNotLoadedException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDILocalVariable_exception_while_retrieving_type_of_local_variable, e.toString()), e);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDILocalVariable_exception_while_retrieving_type_of_local_variable, e.toString()), e);
        }
        return null;
    }

    public boolean isLocal() {
        return true;
    }
}

