/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDEClasspathContainer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.TargetPlatform;

public class RequiredPluginsClasspathContainer
extends PDEClasspathContainer
implements IClasspathContainer {
    private IPluginModelBase fModel;
    private static boolean DEBUG = false;
    private IClasspathEntry[] fEntries = null;

    static {
        DEBUG = PDECore.getDefault().isDebugging() && "true".equals(Platform.getDebugOption((String)"org.eclipse.pde.core/classpath"));
    }

    public RequiredPluginsClasspathContainer(IPluginModelBase model) {
        this.fModel = model;
    }

    public void reset() {
        this.fEntries = null;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return new Path("org.eclipse.pde.core.requiredPlugins");
    }

    public String getDescription() {
        return PDECoreMessages.RequiredPluginsClasspathContainer_description;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.fModel == null) {
            if (DEBUG) {
                System.out.println("********Returned an empty container");
                System.out.println();
            }
            return new IClasspathEntry[0];
        }
        if (this.fEntries == null) {
            this.fEntries = this.computePluginEntries();
        }
        if (DEBUG) {
            System.out.println("Dependencies for plugin '" + this.fModel.getPluginBase().getId() + "':");
            int i = 0;
            while (i < this.fEntries.length) {
                System.out.println(this.fEntries[i]);
                ++i;
            }
            System.out.println();
        }
        return this.fEntries;
    }

    private IClasspathEntry[] computePluginEntries() {
        ArrayList entries = new ArrayList();
        try {
            BundleDescription desc = this.fModel.getBundleDescription();
            if (desc == null) {
                return new IClasspathEntry[0];
            }
            Map map = this.retrieveVisiblePackagesFromState(desc);
            HashSet added = new HashSet();
            HostSpecification host = desc.getHost();
            if (desc.isResolved() && host != null) {
                this.addHostPlugin(host, added, map, entries);
            }
            BundleSpecification[] required = desc.getRequiredBundles();
            int i = 0;
            while (i < required.length) {
                this.addDependency(this.getSupplier(required[i]), added, map, entries);
                ++i;
            }
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                IPluginModelBase model;
                String symbolicName = iter.next().toString();
                if (symbolicName.equals(desc.getSymbolicName()) || (model = PDECore.getDefault().getModelManager().findModel(symbolicName)) == null || !model.isEnabled()) continue;
                this.addDependencyViaImportPackage(model.getBundleDescription(), added, map, entries);
            }
            this.addExtraClasspathEntries(added, entries);
            this.addImplicitDependencies(added, map, entries);
        }
        catch (CoreException coreException) {}
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    private BundleDescription getSupplier(BundleSpecification spec) {
        if (spec.isResolved()) {
            return (BundleDescription)spec.getSupplier();
        }
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(spec.getName());
        return model != null && model.isEnabled() ? model.getBundleDescription() : null;
    }

    private Map retrieveVisiblePackagesFromState(BundleDescription bundle) {
        TreeMap<String, ArrayList<PDEClasspathContainer.Rule>> visiblePackages = new TreeMap<String, ArrayList<PDEClasspathContainer.Rule>>();
        if (bundle.isResolved()) {
            BundleDescription desc = bundle;
            if (desc.getHost() != null) {
                desc = (BundleDescription)desc.getHost().getSupplier();
            }
            StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
            ExportPackageDescription[] exports = helper.getVisiblePackages(desc);
            int i = 0;
            while (i < exports.length) {
                BundleDescription exporter = exports[i].getExporter();
                if (exporter != null) {
                    ArrayList<PDEClasspathContainer.Rule> list = (ArrayList<PDEClasspathContainer.Rule>)visiblePackages.get(exporter.getName());
                    if (list == null) {
                        list = new ArrayList<PDEClasspathContainer.Rule>();
                    }
                    list.add(this.getRule(helper, desc, exports[i]));
                    visiblePackages.put(exporter.getName(), list);
                }
                ++i;
            }
        }
        return visiblePackages;
    }

    private PDEClasspathContainer.Rule getRule(StateHelper helper, BundleDescription desc, ExportPackageDescription export) {
        PDEClasspathContainer.Rule rule = new PDEClasspathContainer.Rule();
        rule.discouraged = helper.getAccessCode(desc, export) == 2;
        rule.path = new Path(String.valueOf(export.getName().replaceAll("\\.", "/")) + "/*");
        return rule;
    }

    private void addDependencyViaImportPackage(BundleDescription desc, HashSet added, Map map, ArrayList entries) throws CoreException {
        if (desc == null || !added.add(desc.getSymbolicName())) {
            return;
        }
        this.addPlugin(desc, true, map, entries);
        if (this.hasExtensibleAPI(desc) && desc.getContainingState() != null) {
            BundleDescription[] fragments = desc.getFragments();
            int i = 0;
            while (i < fragments.length) {
                if (fragments[i].isResolved()) {
                    this.addDependencyViaImportPackage(fragments[i], added, map, entries);
                }
                ++i;
            }
        }
    }

    private void addDependency(BundleDescription desc, HashSet added, Map map, ArrayList entries) throws CoreException {
        int i;
        if (desc == null || !added.add(desc.getSymbolicName())) {
            return;
        }
        this.addPlugin(desc, true, map, entries);
        if (this.hasExtensibleAPI(desc) && desc.getContainingState() != null) {
            BundleDescription[] fragments = desc.getFragments();
            i = 0;
            while (i < fragments.length) {
                if (fragments[i].isResolved()) {
                    this.addDependency(fragments[i], added, map, entries);
                }
                ++i;
            }
        }
        BundleSpecification[] required = desc.getRequiredBundles();
        i = 0;
        while (i < required.length) {
            if (required[i].isExported()) {
                this.addDependency(this.getSupplier(required[i]), added, map, entries);
            }
            ++i;
        }
    }

    private void addPlugin(BundleDescription desc, boolean useInclusions, Map map, ArrayList entries) throws CoreException {
        PDEClasspathContainer.Rule[] rules;
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(desc);
        if (model == null || !model.isEnabled()) {
            return;
        }
        IResource resource = model.getUnderlyingResource();
        PDEClasspathContainer.Rule[] ruleArray = rules = useInclusions ? this.getInclusions(map, model) : null;
        if (resource != null) {
            this.addProjectEntry(resource.getProject(), rules, entries);
        } else {
            this.addExternalPlugin(model, rules, entries);
        }
    }

    private PDEClasspathContainer.Rule[] getInclusions(Map map, IPluginModelBase model) {
        if ("false".equals(System.getProperty("pde.restriction")) || !this.fModel.getBundleDescription().isResolved()) {
            return null;
        }
        String version = PDECore.getDefault().getTargetVersion();
        if (version.equals("2.1") || version.equals("3.0")) {
            return null;
        }
        BundleDescription desc = model.getBundleDescription();
        if (desc == null || !desc.isResolved()) {
            return null;
        }
        PDEClasspathContainer.Rule[] rules = desc.getHost() != null ? this.getInclusions(map, (BundleDescription)desc.getHost().getSupplier()) : this.getInclusions(map, desc);
        return rules.length == 0 && !ClasspathUtilCore.isBundle(model) ? null : rules;
    }

    private PDEClasspathContainer.Rule[] getInclusions(Map map, BundleDescription desc) {
        ArrayList list = (ArrayList)map.get(desc.getSymbolicName());
        return list != null ? list.toArray(new PDEClasspathContainer.Rule[list.size()]) : new PDEClasspathContainer.Rule[]{};
    }

    private void addImplicitDependencies(HashSet added, Map map, ArrayList entries) throws CoreException {
        String id = this.fModel.getPluginBase().getId();
        String schemaVersion = this.fModel.getPluginBase().getSchemaVersion();
        boolean isOSGi = TargetPlatform.isOSGi();
        if (isOSGi && schemaVersion != null || id.equals("org.eclipse.core.boot") || id.equals("org.apache.xerces") || id.startsWith("org.eclipse.swt")) {
            return;
        }
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        if (schemaVersion == null && isOSGi) {
            IPluginModelBase plugin;
            if (!id.equals("org.eclipse.core.runtime") && (plugin = manager.findModel("org.eclipse.core.runtime.compatibility")) != null && plugin.isEnabled()) {
                this.addDependency(plugin.getBundleDescription(), added, map, entries);
            }
        } else {
            IPluginModelBase plugin = manager.findModel("org.eclipse.core.boot");
            if (plugin != null && plugin.isEnabled()) {
                this.addDependency(plugin.getBundleDescription(), added, map, entries);
            }
            if (!id.equals("org.eclipse.core.runtime") && (plugin = manager.findModel("org.eclipse.core.runtime")) != null && plugin.isEnabled()) {
                this.addDependency(plugin.getBundleDescription(), added, map, entries);
            }
        }
    }

    private void addHostPlugin(HostSpecification hostSpec, HashSet added, Map map, ArrayList entries) throws CoreException {
        BaseDescription desc = hostSpec.getSupplier();
        if (desc instanceof BundleDescription && added.add(desc.getName())) {
            BundleDescription host = (BundleDescription)desc;
            this.addPlugin(host, false, map, entries);
            BundleSpecification[] required = host.getRequiredBundles();
            int i = 0;
            while (i < required.length) {
                desc = this.getSupplier(required[i]);
                if (desc != null && desc instanceof BundleDescription) {
                    this.addDependency((BundleDescription)desc, added, map, entries);
                }
                ++i;
            }
        }
    }

    private boolean hasExtensibleAPI(BundleDescription desc) {
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(desc);
        return model instanceof IPluginModel ? ClasspathUtilCore.hasExtensibleAPI(((IPluginModel)model).getPlugin()) : false;
    }

    protected void addExtraClasspathEntries(HashSet added, ArrayList entries) throws CoreException {
        IBuildEntry entry;
        IBuild build = ClasspathUtilCore.getBuild(this.fModel);
        IBuildEntry iBuildEntry = entry = build == null ? null : build.getEntry("jars.extra.classpath");
        if (entry == null) {
            return;
        }
        String[] tokens = entry.getTokens();
        int i = 0;
        while (i < tokens.length) {
            block15: {
                File file;
                IPath path;
                block13: {
                    block14: {
                        IFile resource;
                        path = Path.fromPortableString((String)tokens[i]);
                        if (path.isAbsolute()) break block13;
                        file = new File(this.fModel.getInstallLocation(), path.toString());
                        if (!file.exists() || (resource = PDECore.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()))) == null || !resource.getProject().equals((Object)this.fModel.getUnderlyingResource().getProject())) break block14;
                        this.addExtraLibrary(resource.getFullPath(), null, entries);
                        break block15;
                    }
                    if (path.segmentCount() < 3 || !"..".equals(path.segment(0))) break block15;
                    path = path.removeFirstSegments(1);
                    path = Path.fromPortableString((String)"platform:/plugin/").append(path);
                }
                if (!path.toPortableString().startsWith("platform:")) {
                    file = new File(path.toOSString());
                    if (file.exists()) {
                        this.addExtraLibrary(path, null, entries);
                    }
                } else {
                    IPluginModelBase model;
                    String pluginID;
                    int count;
                    int n = count = path.getDevice() == null ? 4 : 3;
                    if (path.segmentCount() >= count && !added.contains(pluginID = path.segment(count - 2)) && (model = PDECore.getDefault().getModelManager().findModel(pluginID)) != null && model.isEnabled()) {
                        path = path.setDevice(null);
                        path = path.removeFirstSegments(count - 1);
                        if (model.getUnderlyingResource() == null) {
                            File file2 = new File(model.getInstallLocation(), path.toOSString());
                            if (file2.exists()) {
                                this.addExtraLibrary((IPath)new Path(file2.getAbsolutePath()), model, entries);
                            }
                        } else {
                            IProject project = model.getUnderlyingResource().getProject();
                            IFile file3 = project.getFile(path);
                            if (file3.exists()) {
                                this.addExtraLibrary(file3.getFullPath(), model, entries);
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void addExtraLibrary(IPath path, IPluginModelBase model, ArrayList entries) throws CoreException {
        IClasspathEntry clsEntry;
        IPath srcPath = null;
        if (model != null) {
            IPath shortPath = path.removeFirstSegments(path.matchingFirstSegments((IPath)new Path(model.getInstallLocation())));
            srcPath = ClasspathUtilCore.getSourceAnnotation(model, shortPath.toString());
        }
        if (!entries.contains(clsEntry = JavaCore.newLibraryEntry((IPath)path, srcPath, null))) {
            entries.add(clsEntry);
        }
    }
}

