/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingLine;
import org.eclipse.debug.ui.memory.AbstractTableRendering;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractTableRenderingLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    protected AbstractTableRendering fRendering;

    public AbstractTableRenderingLabelProvider() {
    }

    public AbstractTableRenderingLabelProvider(AbstractTableRendering rendering) {
        this.fRendering = rendering;
    }

    public void dispose() {
        this.fRendering = null;
        super.dispose();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        int endOffset;
        if (columnIndex == 0) {
            return DebugPluginImages.getImage("IMG_OBJECT_MEMORY");
        }
        if (columnIndex > this.fRendering.getBytesPerLine() / this.fRendering.getBytesPerColumn()) {
            return DebugPluginImages.getImage("IMG_OBJECT_MEMORY");
        }
        int startOffset = (columnIndex - 1) * this.fRendering.getBytesPerColumn();
        if (((TableRenderingLine)element).isRangeChange(startOffset, endOffset = startOffset + this.fRendering.getBytesPerColumn() - 1)) {
            return DebugPluginImages.getImage("IMG_OBJECT_MEMORY_CHANGED");
        }
        return DebugPluginImages.getImage("IMG_OBJECT_MEMORY");
    }

    public String getColumnText(Object element, int columnIndex) {
        String columnLabel = null;
        if (columnIndex == 0) {
            columnLabel = ((TableRenderingLine)element).getAddress();
        } else if (columnIndex > this.fRendering.getBytesPerLine() / this.fRendering.getBytesPerColumn()) {
            columnLabel = " ";
        } else {
            int start = (columnIndex - 1) * this.fRendering.getBytesPerColumn();
            int end = start + this.fRendering.getBytesPerColumn();
            MemoryByte[] bytes = ((TableRenderingLine)element).getBytes(start, end);
            BigInteger address = new BigInteger(((TableRenderingLine)element).getAddress(), 16);
            address = address.add(BigInteger.valueOf(start));
            columnLabel = this.fRendering.getString(this.fRendering.getRenderingId(), address, bytes);
        }
        return columnLabel;
    }
}

