/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.expression;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.views.DebugViewInterimLabelProvider;
import org.eclipse.debug.internal.ui.views.DebugViewLabelDecorator;
import org.eclipse.debug.internal.ui.views.RemoteTreeViewer;
import org.eclipse.debug.internal.ui.views.expression.ExpressionViewEventHandler;
import org.eclipse.debug.internal.ui.views.expression.RemoteExpressionsContentProvider;
import org.eclipse.debug.internal.ui.views.variables.AvailableLogicalStructuresAction;
import org.eclipse.debug.internal.ui.views.variables.RemoteVariablesContentProvider;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewEventHandler;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;

public class ExpressionView
extends VariablesView {
    protected IBaseLabelProvider createLabelProvider(StructuredViewer viewer) {
        return new ExpressionViewDecoratingLabelProvider(viewer, (ILabelProvider)new DebugViewInterimLabelProvider(this.getModelPresentation()), new DebugViewLabelDecorator(this.getModelPresentation()));
    }

    protected RemoteVariablesContentProvider createContentProvider(Viewer viewer) {
        return new RemoteExpressionsContentProvider((RemoteTreeViewer)viewer, this.getSite(), this);
    }

    protected VariablesViewEventHandler createEventHandler() {
        return new ExpressionViewEventHandler(this);
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.EXPRESSION_VIEW;
    }

    protected void setInitialContent() {
        this.getViewer().setInput((Object)DebugPlugin.getDefault().getExpressionManager());
    }

    protected void configureToolBar(IToolBarManager tbm) {
        super.configureToolBar(tbm);
        tbm.add((IContributionItem)new Separator("emptyExpressionGroup"));
        tbm.add((IContributionItem)new Separator("expressionGroup"));
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyExpressionGroup"));
        menu.add((IContributionItem)new Separator("expressionGroup"));
        menu.add(this.getAction("ChangeVariableValue"));
        AvailableLogicalStructuresAction action = new AvailableLogicalStructuresAction(this);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isVisible()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IDebugElement context = null;
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.size() < 2) {
                Object object = ss.getFirstElement();
                if (object instanceof IDebugElement) {
                    context = (IDebugElement)object;
                } else if (object instanceof ILaunch) {
                    context = ((ILaunch)object).getDebugTarget();
                }
            }
            IExpression[] expressions = DebugPlugin.getDefault().getExpressionManager().getExpressions();
            int i = 0;
            while (i < expressions.length) {
                IExpression expression = expressions[i];
                if (expression instanceof IWatchExpression) {
                    ((IWatchExpression)expression).setExpressionContext(context);
                }
                ++i;
            }
        }
        this.updateAction("ContentAssist");
    }

    protected void setViewerInput(IStructuredSelection ssel) {
    }

    protected void treeSelectionChanged(SelectionChangedEvent event) {
        Object input;
        IStructuredSelection ssel;
        super.treeSelectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)selection).size() == 1 && (input = ssel.getFirstElement()) instanceof IDebugElement) {
            this.getDetailViewer().setEditable(true);
            return;
        }
        this.getDetailViewer().setEditable(false);
    }

    protected String getDetailPanePreferenceKey() {
        return "Expressions.detail.orientation";
    }

    protected String getToggleActionLabel() {
        return VariablesViewMessages.ExpressionView_4;
    }

    protected void createActions() {
        super.createActions();
        this.setInitialContent();
    }

    protected void restoreState() {
    }

    public void saveState(IMemento memento) {
    }

    protected class ExpressionViewDecoratingLabelProvider
    extends VariablesView.VariablesViewDecoratingLabelProvider {
        public Color getForeground(Object element) {
            Object parent;
            boolean expressionWithError = false;
            IErrorReportingExpression expression = null;
            if (element instanceof IErrorReportingExpression) {
                expression = (IErrorReportingExpression)element;
            } else if (element instanceof String && (parent = ((ITreeContentProvider)ExpressionView.this.getVariablesViewer().getContentProvider()).getParent(element)) instanceof IErrorReportingExpression) {
                expression = (IErrorReportingExpression)parent;
            }
            if (expression != null && expression.hasErrors()) {
                expressionWithError = true;
            }
            if (expressionWithError) {
                return Display.getDefault().getSystemColor(3);
            }
            return super.getForeground(element);
        }

        public ExpressionViewDecoratingLabelProvider(StructuredViewer viewer, ILabelProvider provider, DebugViewLabelDecorator decorator) {
            super(ExpressionView.this, viewer, provider, decorator);
        }
    }
}

