/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.internal.ui.views.DebugViewLabelDecorator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IDelayedLabelDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;

public class DebugViewDecoratingLabelProvider
extends DecoratingLabelProvider {
    private Map computedText = new HashMap();
    private StructuredViewer viewer = null;
    private boolean disposed = false;

    public DebugViewDecoratingLabelProvider(StructuredViewer viewer, ILabelProvider provider, DebugViewLabelDecorator decorator) {
        super(provider, (ILabelDecorator)decorator);
        decorator.setLabelProvider(this);
        this.viewer = viewer;
    }

    public void textComputed(Object element, String text) {
        this.computedText.put(element, text);
    }

    public void labelsComputed(Object[] elements) {
        if (!this.disposed) {
            this.viewer.update(elements, null);
        }
        int i = 0;
        while (i < elements.length) {
            this.computedText.remove(elements[i]);
            ++i;
        }
    }

    public String getText(Object element) {
        String text = (String)this.computedText.get(element);
        if (text != null) {
            return text;
        }
        return super.getText(element);
    }

    public void dispose() {
        this.disposed = true;
        super.dispose();
    }

    public void updateLabel(ViewerLabel settings, Object element) {
        IDelayedLabelDecorator delayedDecorator;
        boolean decorationReady;
        ILabelDecorator currentDecorator = this.getLabelDecorator();
        String oldText = settings.getText();
        String text = this.getText(element);
        boolean bl = decorationReady = !"...".equals(text);
        if (currentDecorator instanceof IDelayedLabelDecorator && !(delayedDecorator = (IDelayedLabelDecorator)currentDecorator).prepareDecoration(element, oldText)) {
            decorationReady = false;
        }
        if (decorationReady || oldText == null || settings.getText().length() == 0) {
            settings.setText(this.getText(element));
        }
        Image oldImage = settings.getImage();
        if (decorationReady || oldImage == null) {
            settings.setImage(this.getImage(element));
        }
        if (decorationReady) {
            this.updateForDecorationReady(settings, element);
        }
    }
}

