/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.views.variables.RemoteVariableContentManager;
import org.eclipse.debug.ui.DeferredDebugElementWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredStackFrame
extends DeferredDebugElementWorkbenchAdapter {
    public Object[] getChildren(Object parent) {
        if (parent instanceof IStackFrame) {
            IStackFrame frame = (IStackFrame)parent;
            try {
                return frame.getVariables();
            }
            catch (DebugException e) {
                return new Object[]{e};
            }
        }
        return EMPTY;
    }

    public Object getParent(Object element) {
        return ((IStackFrame)element).getThread();
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        Object[] children = this.getChildren(object);
        if (monitor.isCanceled()) {
            return;
        }
        if (children.length > 0) {
            if (collector instanceof RemoteVariableContentManager.VariableCollector) {
                RemoteVariableContentManager.VariableCollector remoteCollector = (RemoteVariableContentManager.VariableCollector)collector;
                int i = 0;
                while (i < children.length) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    Object child = children[i];
                    remoteCollector.setHasChildren(child, this.hasChildren(child));
                    ++i;
                }
            }
            collector.add(children, monitor);
        }
        collector.done();
    }

    protected boolean hasChildren(Object child) {
        if (child instanceof IVariable) {
            IVariable variable = (IVariable)child;
            try {
                IValue value = variable.getValue();
                return value.hasVariables();
            }
            catch (DebugException debugException) {}
        }
        return false;
    }
}

