/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.views.variables.RemoteVariableContentManager;
import org.eclipse.debug.ui.DeferredDebugElementWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredExpressionManager
extends DeferredDebugElementWorkbenchAdapter {
    public Object[] getChildren(Object parent) {
        return ((IExpressionManager)parent).getExpressions();
    }

    public Object getParent(Object element) {
        return null;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        Object[] children = this.getChildren(object);
        if (monitor.isCanceled()) {
            return;
        }
        if (children.length > 0) {
            if (collector instanceof RemoteVariableContentManager.VariableCollector) {
                RemoteVariableContentManager.VariableCollector remoteCollector = (RemoteVariableContentManager.VariableCollector)collector;
                int i = 0;
                while (i < children.length) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    IExpression child = (IExpression)children[i];
                    try {
                        IValue value = child.getValue();
                        if (value == null) {
                            remoteCollector.setHasChildren(child, false);
                        } else {
                            remoteCollector.setHasChildren(child, value.hasVariables());
                        }
                    }
                    catch (DebugException debugException) {}
                    ++i;
                }
            }
            collector.add(children, monitor);
        }
        collector.done();
    }

    public boolean isContainer() {
        return DebugPlugin.getDefault().getExpressionManager().hasExpressions();
    }
}

