/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.actions.AbstractRemoveAllActionDelegate;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.ui.IViewPart;

public class RemoveAllTerminatedAction
extends AbstractRemoveAllActionDelegate
implements ILaunchesListener {
    protected void doHandleDebugEvent(DebugEvent event) {
        if (event.getKind() == 8) {
            Object source = event.getSource();
            if (event.getKind() == 8 && (source instanceof IDebugTarget || source instanceof IProcess)) {
                this.update();
            }
        }
    }

    protected void update() {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        if (launches != null) {
            int i = 0;
            while (i < launches.length) {
                if (launches[i].isTerminated()) {
                    this.getAction().setEnabled(true);
                    return;
                }
                ++i;
            }
        }
        this.getAction().setEnabled(false);
    }

    protected void doAction() {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        RemoveAllTerminatedAction.removeTerminatedLaunches(launches);
    }

    public static void removeTerminatedLaunches(ILaunch[] elements) {
        ArrayList<ILaunch> removed = new ArrayList<ILaunch>();
        int i = 0;
        while (i < elements.length) {
            ILaunch launch = elements[i];
            if (launch.isTerminated()) {
                removed.add(launch);
            }
            ++i;
        }
        if (!removed.isEmpty()) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            manager.removeLaunches(removed.toArray(new ILaunch[removed.size()]));
        }
    }

    public void init(IViewPart view) {
        super.init(view);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        IViewPart view = this.getView();
        if (view != null) {
            view.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.getAction());
        }
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        if (this.getAction().isEnabled()) {
            this.update();
        }
    }
}

