/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.actions.AbstractListenerActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.FindVariableDialog;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class FindVariableAction
extends Action
implements IUpdate {
    private AbstractListenerActionDelegate fDelegate;

    public FindVariableAction(VariablesView view) {
        this.setText(ActionMessages.FindVariableAction_0);
        this.setId(String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".FindVariableAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IDebugHelpContextIds.FIND_VARIABLE_ACTION);
        this.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.fDelegate = new FindVariableDelegate();
        this.fDelegate.init(view);
        this.fDelegate.setAction((IAction)this);
    }

    public void run() {
        this.fDelegate.run((IAction)this);
    }

    public void update() {
        Viewer viewer;
        VariablesView view = (VariablesView)this.fDelegate.getView();
        if (view != null && (viewer = view.getViewer()) != null) {
            this.setEnabled(viewer.getInput() instanceof IStackFrame);
            return;
        }
        this.setEnabled(false);
    }

    public void dispose() {
        this.fDelegate.dispose();
    }

    private class FindVariableDelegate
    extends AbstractListenerActionDelegate {
        FindVariableDelegate() {
        }

        protected void doAction(Object element) {
            VariablesView view = (VariablesView)this.getView();
            Shell shell = view.getSite().getShell();
            FindVariableDialog dialog = new FindVariableDialog(shell, view);
            dialog.open();
        }

        protected void update(IAction action, ISelection s) {
            if (action != null) {
                ((IUpdate)action).update();
            }
        }

        protected void doHandleDebugEvent(DebugEvent event) {
            this.update(this.getAction(), null);
        }

        public void run(IAction action) {
            this.doAction(null);
        }
    }
}

